/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap.entities;

import com.sun.apoc.spi.PolicySource;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.EntityTreeProvider;
import com.sun.apoc.spi.entities.Node;
import com.sun.apoc.spi.ldap.LdapConnectionHandler;
import com.sun.apoc.spi.ldap.datastore.LdapDataStore;
import com.sun.apoc.spi.ldap.environment.LdapEnvironmentMgr;

public abstract class LdapEntityProvider
implements EntityTreeProvider {
    protected Node mRootNode;
    protected PolicySource mPolicySource;
    protected LdapConnectionHandler mConnection;
    protected LdapDataStore mDataStore;
    protected LdapEnvironmentMgr mEnvironmentMgr;
    protected String mURL;

    public LdapEntityProvider(PolicySource policySource, String string) throws SPIException {
        this.mPolicySource = policySource;
        this.mURL = string;
        this.mEnvironmentMgr = new LdapEnvironmentMgr(this.mPolicySource.getEnvironment());
        this.mConnection = (LdapConnectionHandler)this.mPolicySource.getConnectionHandler(this.mURL);
        if (this.mConnection == null) {
            this.mEnvironmentMgr.checkEnvironment();
        }
    }

    public void close() throws SPIException {
        if (this.mPolicySource.getConnectionHandler(this.mURL) != null) {
            this.mPolicySource.setConnectionHandler(this.mURL, null);
        }
        this.mConnection.disconnect();
    }

    public Node getRootEntity() throws SPIException {
        return this.mRootNode;
    }

    public Entity getEntity(String string) throws SPIException {
        Entity entity = null;
        entity = string.equals(this.mRootNode.getId()) ? this.mRootNode : this.mRootNode.getEntity(string);
        return entity;
    }
}

