/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap.entities;

import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.Host;
import com.sun.apoc.spi.ldap.LdapClientContext;
import com.sun.apoc.spi.ldap.datastore.LdapDataStore;
import com.sun.apoc.spi.ldap.entities.LdapDomain;
import com.sun.apoc.spi.ldap.entities.LdapEntity;
import com.sun.apoc.spi.ldap.entities.LdapEntityType;
import com.sun.apoc.spi.ldap.entities.mapping.LdapEntityMapping;
import java.util.Iterator;
import java.util.Vector;
import netscape.ldap.LDAPDN;

public class LdapHost
extends LdapEntity
implements Host {
    private LdapDomain mParent;

    public LdapHost(String string, int n, LdapDataStore ldapDataStore, LdapEntityMapping ldapEntityMapping, LdapClientContext ldapClientContext) {
        super(string, n, ldapDataStore, ldapEntityMapping, ldapClientContext);
        this.setIsDomainTree();
    }

    public boolean equals(Object object) {
        if (object instanceof LdapHost) {
            return LDAPDN.equals((String)this.mLocation.toLowerCase(), (String)((LdapHost)object).mLocation.toLowerCase());
        }
        return false;
    }

    public Entity getParent() {
        if (this.mParent == null) {
            String[] stringArray = LDAPDN.explodeDN((String)this.mLocation, (boolean)false);
            StringBuffer stringBuffer = new StringBuffer(stringArray[this.mParentIndex]);
            for (int i = this.mParentIndex + 1; i < stringArray.length; ++i) {
                stringBuffer.append(",").append(stringArray[i]);
            }
            this.mParent = (LdapDomain)this.getEntityFromDN(stringBuffer.toString(), LdapEntityType.DOMAIN, false, null);
        }
        return this.mParent;
    }

    public Iterator getMemberships() throws SPIException {
        return this.getListOfRoles().iterator();
    }

    public Entity[] getMembershipsArray() throws SPIException {
        Vector vector = this.getListOfRoles();
        Entity[] entityArray = new Entity[vector.size()];
        for (int i = 0; i < entityArray.length; ++i) {
            entityArray[i] = (Entity)vector.get(i);
        }
        return entityArray;
    }

    private Vector getListOfRoles() throws SPIException {
        Vector vector = this.getDataStore().getListedRolesForEntity(this, this.mEntityMapping.mRoleMapping.getListingAttribute(), this.getContext());
        Vector<Entity> vector2 = new Vector<Entity>();
        if (!vector.isEmpty()) {
            int n = vector.size();
            Entity entity = null;
            for (int i = 0; i < n; ++i) {
                try {
                    String string = this.getDataStore().readEntryDN((String)vector.get(i), this.getContext());
                    entity = this.getEntityFromDN((String)vector.get(i), LdapEntityType.ROLE, false, null);
                    if (entity == null) continue;
                    vector2.add(entity);
                    continue;
                }
                catch (SPIException sPIException) {
                    // empty catch block
                }
            }
        }
        return vector2;
    }

    public Iterator getLayeredProfiles() throws SPIException {
        Iterator iterator = this.getAllParents();
        Iterator iterator2 = this.getMemberships();
        return this.getLayeredProfiles(iterator, iterator2);
    }
}

