/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap.entities;

import com.sun.apoc.spi.IllegalReadException;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.InvalidFilterException;
import com.sun.apoc.spi.entities.Organization;
import com.sun.apoc.spi.ldap.LdapClientContext;
import com.sun.apoc.spi.ldap.datastore.LdapDataStore;
import com.sun.apoc.spi.ldap.entities.LdapEntityType;
import com.sun.apoc.spi.ldap.entities.LdapNode;
import com.sun.apoc.spi.ldap.entities.mapping.LdapEntityMapping;
import com.sun.apoc.spi.util.BooleanReturnValue;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import netscape.ldap.LDAPDN;

public class LdapOrganization
extends LdapNode
implements Organization {
    private LdapOrganization mParent;

    public LdapOrganization(String string, int n, LdapDataStore ldapDataStore, LdapEntityMapping ldapEntityMapping, LdapClientContext ldapClientContext) {
        super(string, n, ldapDataStore, ldapEntityMapping, ldapClientContext);
    }

    public boolean equals(Object object) {
        if (object instanceof LdapOrganization) {
            return LDAPDN.equals((String)this.mLocation.toLowerCase(), (String)((LdapOrganization)object).mLocation.toLowerCase());
        }
        return false;
    }

    public Iterator getChildren() throws SPIException {
        BooleanReturnValue booleanReturnValue = new BooleanReturnValue(false);
        return this.getChildren(false, booleanReturnValue);
    }

    public Iterator getChildren(boolean bl, BooleanReturnValue booleanReturnValue) throws SPIException {
        Vector vector = this.getAllChildrenList(bl, booleanReturnValue);
        return vector.iterator();
    }

    public Entity[] getChildrenArray() throws SPIException {
        BooleanReturnValue booleanReturnValue = new BooleanReturnValue(false);
        return this.getChildrenArray(false, booleanReturnValue);
    }

    public Entity[] getChildrenArray(boolean bl, BooleanReturnValue booleanReturnValue) throws SPIException {
        Vector vector = this.getAllChildrenList(bl, booleanReturnValue);
        Entity[] entityArray = new Entity[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.get(i);
            entityArray[i] = (Entity)vector.get(i);
        }
        return entityArray;
    }

    public boolean hasChildren() throws SPIException {
        BooleanReturnValue booleanReturnValue = new BooleanReturnValue(false);
        this.getChildren(true, booleanReturnValue);
        return booleanReturnValue.getReturnValue();
    }

    public Vector getAllChildrenList(boolean bl, BooleanReturnValue booleanReturnValue) throws SPIException {
        Vector vector = new Vector();
        String string = null;
        String string2 = this.buildClassFilter(this.mEntityMapping.mOrganizationMapping, false);
        Vector vector2 = this.getChildrenList(string2, LdapEntityType.ORG, string, bl, booleanReturnValue);
        if (bl && booleanReturnValue.getReturnValue()) {
            return vector;
        }
        vector.addAll(vector2);
        string2 = this.buildClassFilter(this.mEntityMapping.mRoleMapping, false);
        vector2 = this.getChildrenList(string2, LdapEntityType.ROLE, string, bl, booleanReturnValue);
        if (bl && booleanReturnValue.getReturnValue()) {
            return vector;
        }
        vector.addAll(vector2);
        string2 = this.buildClassFilter(this.mEntityMapping.mUserMapping, false);
        string = this.mEntityMapping.mUserMapping.getContainerEntry();
        vector2 = this.getChildrenList(string2, LdapEntityType.USERID, string, bl, booleanReturnValue);
        if (bl && booleanReturnValue.getReturnValue()) {
            return vector;
        }
        if (vector2 != null) {
            vector.addAll(vector2);
        }
        return vector;
    }

    public Iterator getSubOrganizations() throws SPIException {
        BooleanReturnValue booleanReturnValue = new BooleanReturnValue(false);
        String string = this.buildClassFilter(this.mEntityMapping.mOrganizationMapping, false);
        Vector vector = this.getChildrenList(string, LdapEntityType.ORG, null, false, booleanReturnValue);
        return vector.iterator();
    }

    public Entity[] getSubOrganizationsArray() throws SPIException {
        BooleanReturnValue booleanReturnValue = new BooleanReturnValue(false);
        String string = this.buildClassFilter(this.mEntityMapping.mOrganizationMapping, false);
        Vector vector = this.getChildrenList(string, LdapEntityType.ORG, null, false, booleanReturnValue);
        Entity[] entityArray = new Entity[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            entityArray[i] = (Entity)vector.get(i);
        }
        return entityArray;
    }

    public Iterator getUsers() throws SPIException {
        BooleanReturnValue booleanReturnValue = new BooleanReturnValue(false);
        String string = this.buildClassFilter(this.mEntityMapping.mUserMapping, false);
        Vector vector = this.getChildrenList(string, LdapEntityType.USERID, this.mEntityMapping.mUserMapping.getContainerEntry(), false, booleanReturnValue);
        return vector.iterator();
    }

    public Entity[] getUsersArray() throws SPIException {
        BooleanReturnValue booleanReturnValue = new BooleanReturnValue(false);
        String string = this.buildClassFilter(this.mEntityMapping.mUserMapping, false);
        Vector vector = this.getChildrenList(string, LdapEntityType.USERID, this.mEntityMapping.mUserMapping.getContainerEntry(), false, booleanReturnValue);
        Entity[] entityArray = new Entity[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            entityArray[i] = (Entity)vector.get(i);
        }
        return entityArray;
    }

    public Iterator findSubOrganizationsByName(String string, boolean bl) throws SPIException {
        Vector vector = this.findSubOrganizationsByNameList(string, bl);
        return vector.iterator();
    }

    public Entity[] findSubOrganizationsByNameArray(String string, boolean bl) throws SPIException {
        Vector vector = this.findSubOrganizationsByNameList(string, bl);
        Entity[] entityArray = new Entity[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            entityArray[i] = (Entity)vector.get(i);
        }
        return entityArray;
    }

    public Iterator findSubOrganizationsByFilter(String string, boolean bl) throws SPIException {
        Vector vector = this.findSubOrganizationsByFilterList(string, bl);
        return vector.iterator();
    }

    public Entity[] findSubOrganizationsByFilterArray(String string, boolean bl) throws SPIException {
        Vector vector = this.findSubOrganizationsByFilterList(string, bl);
        Entity[] entityArray = new Entity[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            entityArray[i] = (Entity)vector.get(i);
        }
        return entityArray;
    }

    public Iterator findUsersByName(String string, boolean bl) throws SPIException {
        Vector vector = this.findUsersByNameList(string, bl);
        return vector.iterator();
    }

    public Entity[] findUsersByNameArray(String string, boolean bl) throws SPIException {
        Vector vector = this.findUsersByNameList(string, bl);
        Entity[] entityArray = new Entity[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            entityArray[i] = (Entity)vector.get(i);
        }
        return entityArray;
    }

    public Iterator findUsersByFilter(String string, boolean bl) throws SPIException {
        Vector vector = this.findUsersByFilterList(string, bl);
        return vector.iterator();
    }

    public Entity[] findUsersByFilterArray(String string, boolean bl) throws SPIException {
        Vector vector = this.findUsersByFilterList(string, bl);
        Entity[] entityArray = new Entity[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            entityArray[i] = (Entity)vector.get(i);
        }
        return entityArray;
    }

    public Entity getParent() {
        if (this.mParent == null && this.mParentIndex != -1) {
            String[] stringArray = LDAPDN.explodeDN((String)this.mLocation, (boolean)false);
            if (stringArray == null || this.mParentIndex >= stringArray.length) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer(stringArray[this.mParentIndex]);
            for (int i = this.mParentIndex + 1; i < stringArray.length; ++i) {
                stringBuffer.append(",").append(stringArray[i]);
            }
            this.mParent = (LdapOrganization)this.getEntityFromDN(stringBuffer.toString(), LdapEntityType.ORG, false, null);
        }
        return this.mParent;
    }

    public Vector findEntitiesByNameList(String string, boolean bl) throws SPIException {
        Vector vector = this.findUsersByNameList(string, bl);
        Vector vector2 = this.findSubOrganizationsByNameList(string, bl);
        for (int i = 0; i < vector2.size(); ++i) {
            vector.add(vector2.get(i));
        }
        Vector vector3 = this.findRolesByNameList(string, bl);
        for (int i = 0; i < vector3.size(); ++i) {
            vector.add(vector3.get(i));
        }
        return vector;
    }

    public Vector findSubOrganizationsByNameList(String string, boolean bl) throws SPIException {
        String string2 = this.buildNameFilter(string, "=", this.mEntityMapping.mOrganizationMapping, bl);
        Vector vector = this.searchForOrganizations(string2, bl);
        return vector;
    }

    public Vector findUsersByNameList(String string, boolean bl) throws SPIException {
        String string2 = this.buildNameFilter(string, "=", this.mEntityMapping.mUserMapping, bl);
        Vector vector = this.searchForUsers(string2, bl);
        return vector;
    }

    public Vector findEntitiesByFilterList(String string, boolean bl) throws SPIException {
        Vector vector = this.findUsersByFilterList(string, bl);
        Vector vector2 = this.findSubOrganizationsByFilterList(string, bl);
        for (int i = 0; i < vector2.size(); ++i) {
            vector.add(vector2.get(i));
        }
        Vector vector3 = this.findRolesByFilterList(string, bl);
        for (int i = 0; i < vector3.size(); ++i) {
            vector.add(vector3.get(i));
        }
        return vector;
    }

    public Vector findSubOrganizationsByFilterList(String string, boolean bl) throws SPIException {
        String string2 = this.mapFilter(string, this.mEntityMapping.mOrganizationMapping, bl);
        Vector vector = this.searchForOrganizations(string2, bl);
        return vector;
    }

    public Vector findUsersByFilterList(String string, boolean bl) throws SPIException {
        String string2 = this.mapFilter(string, this.mEntityMapping.mUserMapping, bl);
        Vector vector = this.searchForUsers(string2, bl);
        return vector;
    }

    private Vector searchForOrganizations(String string, boolean bl) throws SPIException {
        StringBuffer stringBuffer = new StringBuffer(200);
        String[] stringArray = new String[]{"objectclass"};
        Vector vector = null;
        try {
            vector = this.getDataStore().performSearch(this.mLocation, bl, string, stringArray, true, false, null, false, this.getContext());
        }
        catch (IllegalReadException illegalReadException) {
            if (LdapDataStore.getLdapErrorCode(illegalReadException) == 32) {
                return new Vector();
            }
            throw illegalReadException;
        }
        Vector<Entity> vector2 = new Vector<Entity>();
        if (!vector.isEmpty()) {
            int n = vector.size();
            Entity entity = null;
            for (int i = 0; i < n; ++i) {
                try {
                    Hashtable hashtable = (Hashtable)vector.get(i);
                    Vector vector3 = (Vector)hashtable.get("DN");
                    if (vector3 != null && !vector3.isEmpty()) {
                        entity = this.getEntityFromDN((String)vector3.get(0), LdapEntityType.ORG, false, hashtable);
                    }
                    if (entity == null) continue;
                    boolean bl2 = bl;
                    if (bl2) {
                        if (!this.equals(entity)) {
                            vector2.add(entity);
                            continue;
                        }
                        bl2 = false;
                        continue;
                    }
                    vector2.add(entity);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return vector2;
    }

    private Vector searchForUsers(String string, boolean bl) throws SPIException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer(200);
        String[] stringArray = new String[2 + this.mEntityMapping.mUserMapping.getDisplayAttributes().length];
        stringArray[0] = "objectclass";
        stringArray[1] = this.mEntityMapping.mUserMapping.getUniqueAttribute();
        int n = 2;
        for (int i = 0; i < this.mEntityMapping.mUserMapping.getDisplayAttributes().length; ++i) {
            stringArray[n++] = this.mEntityMapping.mUserMapping.getDisplayAttributes()[i];
        }
        if (!bl && (string2 = this.mEntityMapping.mUserMapping.getContainerEntry()) != null && string2 != "") {
            stringBuffer.append(string2).append(",");
        }
        stringBuffer.append(this.mLocation);
        Vector vector = null;
        try {
            vector = this.getDataStore().performSearch(stringBuffer.toString(), bl, string, stringArray, true, false, null, false, this.getContext());
        }
        catch (IllegalReadException illegalReadException) {
            if (LdapDataStore.getLdapErrorCode(illegalReadException) == 32) {
                return new Vector();
            }
            throw illegalReadException;
        }
        Vector<Entity> vector2 = new Vector<Entity>();
        if (!vector.isEmpty()) {
            int n2 = vector.size();
            Entity entity = null;
            for (int i = 0; i < n2; ++i) {
                try {
                    Hashtable hashtable = (Hashtable)vector.get(i);
                    Vector vector3 = (Vector)hashtable.get("DN");
                    if (vector3 != null && !vector3.isEmpty()) {
                        entity = this.getEntityFromDN((String)vector3.get(0), LdapEntityType.USERID, false, hashtable);
                    }
                    if (entity == null) continue;
                    vector2.add(entity);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return vector2;
    }

    public Iterator findSubOrganizations(String string, boolean bl) throws SPIException {
        if (string == null) {
            throw new InvalidFilterException();
        }
        if (string.startsWith("(")) {
            return this.findSubOrganizationsByFilter(string, bl);
        }
        return this.findSubOrganizationsByName(string, bl);
    }

    public Entity[] findSubOrganizationsArray(String string, boolean bl) throws SPIException {
        if (string == null) {
            throw new InvalidFilterException();
        }
        if (string.startsWith("(")) {
            return this.findSubOrganizationsByFilterArray(string, bl);
        }
        return this.findSubOrganizationsByNameArray(string, bl);
    }

    public Iterator findUsers(String string, boolean bl) throws SPIException {
        if (string == null) {
            throw new InvalidFilterException();
        }
        if (string.startsWith("(")) {
            return this.findUsersByFilter(string, bl);
        }
        return this.findUsersByName(string, bl);
    }

    public Entity[] findUsersArray(String string, boolean bl) throws SPIException {
        if (string == null) {
            throw new InvalidFilterException();
        }
        if (string.startsWith("(")) {
            return this.findUsersByFilterArray(string, bl);
        }
        return this.findUsersByNameArray(string, bl);
    }
}

