/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap.entities;

import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.Role;
import com.sun.apoc.spi.ldap.LdapClientContext;
import com.sun.apoc.spi.ldap.datastore.LdapDataStore;
import com.sun.apoc.spi.ldap.entities.LdapEntityType;
import com.sun.apoc.spi.ldap.entities.LdapNode;
import com.sun.apoc.spi.ldap.entities.mapping.LdapEntityMapping;
import com.sun.apoc.spi.util.BooleanReturnValue;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import netscape.ldap.LDAPDN;

public class LdapRole
extends LdapNode
implements Role {
    private Entity mParent;
    private Entity mParentOrgOrDomain;
    public static final String ROLE_FILTER_PLUS = "(objectclass=ldapsubentry)";

    public LdapRole(String string, int n, LdapDataStore ldapDataStore, LdapEntityMapping ldapEntityMapping, LdapClientContext ldapClientContext) {
        super(string, n, ldapDataStore, ldapEntityMapping, ldapClientContext);
    }

    public boolean equals(Object object) {
        if (object instanceof LdapRole) {
            return LDAPDN.equals((String)this.mLocation.toLowerCase(), (String)((LdapRole)object).mLocation.toLowerCase());
        }
        return false;
    }

    public boolean hasMembers() throws SPIException {
        BooleanReturnValue booleanReturnValue = new BooleanReturnValue(false);
        this.getMembers(true, booleanReturnValue);
        return booleanReturnValue.getReturnValue();
    }

    public Iterator getMembers() throws SPIException {
        return this.getMembers(false, null);
    }

    public Entity[] getMembersArray() throws SPIException {
        return this.getMembersArray(false, null);
    }

    private Iterator getMembers(boolean bl, BooleanReturnValue booleanReturnValue) throws SPIException {
        Vector vector = null;
        vector = this.searchForMembers(bl, booleanReturnValue);
        return vector.iterator();
    }

    private Entity[] getMembersArray(boolean bl, BooleanReturnValue booleanReturnValue) throws SPIException {
        Vector vector = null;
        Entity[] entityArray = null;
        vector = this.searchForMembers(bl, booleanReturnValue);
        if (!bl && vector != null) {
            int n = vector.size();
            entityArray = new Entity[n];
            for (int i = 0; i < n; ++i) {
                entityArray[i] = (Entity)vector.get(i);
            }
        }
        return entityArray == null ? new Entity[]{} : entityArray;
    }

    public Iterator getChildren() throws SPIException {
        return this.getChildren(false, null);
    }

    public Entity[] getChildrenArray() throws SPIException {
        return this.getChildrenArray(false, null);
    }

    private Iterator getChildren(boolean bl, BooleanReturnValue booleanReturnValue) throws SPIException {
        Vector vector = this.getChildrenList(this.buildClassFilter(this.mEntityMapping.mRoleMapping, false), LdapEntityType.ROLE, this.mEntityMapping.mRoleMapping.getContainerEntry(), bl, booleanReturnValue);
        return vector.iterator();
    }

    private Entity[] getChildrenArray(boolean bl, BooleanReturnValue booleanReturnValue) throws SPIException {
        Vector vector = this.getChildrenList(this.buildClassFilter(this.mEntityMapping.mRoleMapping, false), LdapEntityType.ROLE, this.mEntityMapping.mRoleMapping.getContainerEntry(), bl, booleanReturnValue);
        Entity[] entityArray = new Entity[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            entityArray[i] = (Entity)vector.get(i);
        }
        return entityArray;
    }

    public boolean hasChildren() throws SPIException {
        BooleanReturnValue booleanReturnValue = new BooleanReturnValue(false);
        this.getChildren(true, booleanReturnValue);
        return booleanReturnValue.getReturnValue();
    }

    public Entity getParent() {
        if (this.mParent == null) {
            this.mParent = this.getParentRole();
            if (this.mParent == null) {
                String[] stringArray = LDAPDN.explodeDN((String)this.mLocation, (boolean)false);
                if (stringArray == null || this.mParentIndex >= stringArray.length) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer(stringArray[this.mParentIndex]);
                for (int i = this.mParentIndex + 1; i < stringArray.length; ++i) {
                    stringBuffer.append(",").append(stringArray[i]);
                }
                this.mParent = this.getEntityFromDN(stringBuffer.toString(), LdapEntityType.UNKNOWN, false, null);
            }
        }
        return this.mParent;
    }

    public Entity getParentOrgOrDomain() {
        if (this.mParentOrgOrDomain == null) {
            this.mParentOrgOrDomain = this.getParent();
            while (this.mParentOrgOrDomain instanceof LdapRole) {
                this.mParentOrgOrDomain = this.mParentOrgOrDomain.getParent();
            }
        }
        return this.mParentOrgOrDomain;
    }

    private LdapRole getParentRole() {
        if (this.mParentIndex == -1) {
            return null;
        }
        int n = this.mParentIndex - 1;
        if (this.mEntityMapping.mRoleMapping.getContainerEntry() != null) {
            --n;
        }
        if (n < 1) {
            return null;
        }
        String[] stringArray = LDAPDN.explodeDN((String)this.mLocation, (boolean)false);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[1]);
        for (int i = 2; i < stringArray.length; ++i) {
            stringBuffer.append(",").append(stringArray[i]);
        }
        LdapRole ldapRole = new LdapRole(stringBuffer.toString(), this.mParentIndex - 1, this.getDataStore(), this.mEntityMapping, this.getContext());
        return ldapRole;
    }

    private Vector searchForMembers(boolean bl, BooleanReturnValue booleanReturnValue) throws SPIException {
        int n;
        Vector vector;
        block8: {
            Entity entity = this.getParentOrgOrDomain();
            vector = null;
            try {
                vector = this.getDataStore().getRoleMembers(this, this.mEntityMapping.mUserMapping.getObjectClass(), this.mEntityMapping.mRoleMapping.getMemberAttribute(), this.mEntityMapping.mUserMapping.getDisplayAttributes(), bl, booleanReturnValue);
                if (bl) {
                    return new Vector();
                }
            }
            catch (SPIException sPIException) {
                n = LdapDataStore.getLdapErrorCode(sPIException);
                if (n == 94 || n == 16 || n == 32) break block8;
                throw sPIException;
            }
        }
        Vector<Entity> vector2 = new Vector<Entity>();
        if (vector != null && !vector.isEmpty()) {
            n = vector.size();
            Object var7_8 = null;
            Entity entity = null;
            for (int i = 0; i < n; ++i) {
                Hashtable hashtable = (Hashtable)vector.get(i);
                try {
                    Vector vector3 = (Vector)hashtable.get("DN");
                    String string = (String)vector3.get(0);
                    entity = this.getEntityFromDN(string, LdapEntityType.USERID, false, hashtable);
                    if (entity != null) {
                        vector2.add(entity);
                    }
                    entity = null;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return vector2 == null ? new Vector<Entity>() : vector2;
    }

    public Vector findEntitiesByNameList(String string, boolean bl) throws SPIException {
        Vector vector = this.searchForRoles(this.buildNameFilter(string, "=", this.mEntityMapping.mRoleMapping, bl), bl);
        return vector;
    }

    public Vector findEntitiesByFilterList(String string, boolean bl) throws SPIException {
        Vector vector = this.searchForRoles(this.mapFilter(string, this.mEntityMapping.mRoleMapping, bl), bl);
        return vector;
    }

    public Entity getEntity(String string) throws SPIException {
        return this.getEntityFromDN(string, LdapEntityType.UNKNOWN, false, null);
    }

    public Role getRole(String string) throws SPIException {
        return null;
    }

    public Iterator getAllParentRoles() {
        ArrayList<LdapRole> arrayList = new ArrayList<LdapRole>();
        for (LdapRole ldapRole = this.getParentRole(); ldapRole != null; ldapRole = ldapRole.getParentRole()) {
            arrayList.add(ldapRole);
        }
        return arrayList.iterator();
    }

    public Iterator getAllOrgOrDomainParents() {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        for (Entity entity = this.getParentOrgOrDomain(); entity != null; entity = entity.getParent()) {
            arrayList.add(entity);
        }
        return arrayList.iterator();
    }

    public Iterator getLayeredProfiles() throws SPIException {
        Iterator iterator = this.getAllOrgOrDomainParents();
        Iterator iterator2 = this.getAllParentRoles();
        return this.getLayeredProfiles(iterator, iterator2);
    }
}

