/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap.profiles;

import com.sun.apoc.spi.PolicySource;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.ldap.datastore.LdapDataStore;
import com.sun.apoc.spi.ldap.entities.LdapEntity;
import com.sun.apoc.spi.ldap.policies.LdapPolicy;
import com.sun.apoc.spi.ldap.profiles.LdapProfileRepository;
import com.sun.apoc.spi.ldap.util.Timestamp;
import com.sun.apoc.spi.policies.Policy;
import com.sun.apoc.spi.profiles.Applicability;
import com.sun.apoc.spi.profiles.InvalidDisplayNameException;
import com.sun.apoc.spi.profiles.ProfileImpl;
import com.sun.apoc.spi.profiles.ProfileRepositoryImpl;
import com.sun.apoc.spi.profiles.UnknownApplicabilityException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import netscape.ldap.LDAPDN;

public class LdapProfile
extends ProfileImpl {
    private static final String DEFAULT_DISPLAY_NAME = "Settings for ";
    private String mLocation;
    private long mLastModified = 0L;
    private Entity mAuthor;

    public LdapProfile(String string, ProfileRepositoryImpl profileRepositoryImpl, String string2, Applicability applicability, int n) {
        super(string, profileRepositoryImpl, string2, applicability, n);
        this.mLocation = string;
    }

    public String getDisplayName() {
        if (this.mDisplayName == null || this.mDisplayName.length() == 0 || this.mDisplayName.equals("_DefaultHostPolicyGroup_") || this.mDisplayName.equals("_DefaultUserPolicyGroup_")) {
            String string = "";
            try {
                string = this.getProfileRepository().getEntity().getDisplayName(null);
            }
            catch (SPIException sPIException) {
                // empty catch block
            }
            return DEFAULT_DISPLAY_NAME + string;
        }
        return this.mDisplayName;
    }

    public void setPriority(int n) throws SPIException {
        if (this.isLocal()) {
            LdapProfileRepository ldapProfileRepository = (LdapProfileRepository)this.getProfileRepository();
            ldapProfileRepository.migrateProfile(this);
        }
        ((LdapEntity)this.getProfileRepository().getEntity()).getDataStore().setProfilePriority(this, n);
        this.mPriority = n;
    }

    public void setDisplayName(String string) throws SPIException {
        if (string == null || string.length() == 0) {
            throw new InvalidDisplayNameException();
        }
        ((LdapEntity)this.getProfileRepository().getEntity()).getDataStore().setProfileDisplayName(this, string);
        this.mDisplayName = string;
    }

    public void setComment(String string) throws SPIException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ((LdapEntity)this.getProfileRepository().getEntity()).getDataStore().setProfileComment(this, string);
        this.mComment = string;
        if (string == null) {
            this.mNoCommentFound = true;
        }
    }

    public void setApplicability(Applicability applicability) throws SPIException {
        if (applicability == null) {
            throw new IllegalArgumentException();
        }
        if (this.mApplicability.equals(applicability)) {
            return;
        }
        if (applicability.equals(Applicability.UNKNOWN)) {
            throw new UnknownApplicabilityException();
        }
        if (this.isLocal()) {
            LdapProfileRepository ldapProfileRepository = (LdapProfileRepository)this.getProfileRepository();
            ldapProfileRepository.migrateProfile(this);
        }
        ((LdapEntity)this.getProfileRepository().getEntity()).getDataStore().setProfileApplicability(this, applicability);
        this.mApplicability = applicability;
    }

    public String getLocation() {
        return this.mLocation;
    }

    public void storePolicy(Policy policy) throws SPIException {
        if (policy == null) {
            throw new IllegalArgumentException();
        }
        ((LdapEntity)this.getProfileRepository().getEntity()).getDataStore().storePolicy(this, policy);
    }

    public void destroyPolicy(Policy policy) throws SPIException {
        if (policy == null) {
            throw new IllegalArgumentException();
        }
        ((LdapEntity)this.getProfileRepository().getEntity()).getDataStore().destroyPolicy(policy);
    }

    public boolean hasPolicies() throws SPIException {
        return ((LdapEntity)this.getProfileRepository().getEntity()).getDataStore().hasPolicies(this);
    }

    public Iterator getPolicies() throws SPIException {
        this.mPolicies = ((LdapEntity)this.getProfileRepository().getEntity()).getDataStore().getPolicies(this);
        return this.mPolicies.iterator();
    }

    public Iterator getPolicies(Iterator iterator) throws SPIException {
        if (iterator == null) {
            throw new IllegalArgumentException();
        }
        return ((LdapEntity)this.getProfileRepository().getEntity()).getDataStore().getPolicies((ProfileImpl)this, iterator).iterator();
    }

    public Iterator getPolicyInfos(Iterator iterator) throws SPIException {
        if (iterator == null) {
            throw new IllegalArgumentException();
        }
        return ((LdapEntity)this.getProfileRepository().getEntity()).getDataStore().getPolicyInfos((ProfileImpl)this, iterator).iterator();
    }

    public Policy getPolicy(String string) throws SPIException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return ((LdapEntity)this.getProfileRepository().getEntity()).getDataStore().getPolicy(this, string);
    }

    public boolean hasAssignedEntities() throws SPIException {
        LdapDataStore ldapDataStore = ((LdapEntity)this.getProfileRepository().getEntity()).getDataStore();
        if (ldapDataStore.isVersion1() && this.isLocal()) {
            return true;
        }
        Vector vector = ldapDataStore.getListOfEntitiesForProfile(this);
        return vector != null && !vector.isEmpty();
    }

    public Iterator getAssignedEntities() throws SPIException {
        PolicySource policySource = ((ProfileRepositoryImpl)this.getProfileRepository()).getPolicySource();
        return policySource.getAssignmentProvider().getAssignedEntities(this);
    }

    public long getLastModified() throws SPIException {
        long l = this.getLastModifiedForEntry();
        this.getPolicies();
        if (this.mPolicies != null) {
            Iterator iterator = this.mPolicies.iterator();
            while (iterator.hasNext()) {
                Policy policy = (Policy)iterator.next();
                long l2 = policy.getLastModified();
                if (l2 <= l) continue;
                l = l2;
            }
        }
        return l;
    }

    private long getLastModifiedForEntry() throws SPIException {
        if (this.mLastModified == 0L) {
            LdapEntity ldapEntity = (LdapEntity)this.getProfileRepository().getEntity();
            ArrayList arrayList = ldapEntity.getDataStore().getModificationDetails(this);
            this.setLastModified((String)arrayList.get(0));
            if (arrayList.size() > 1) {
                this.mAuthor = (Entity)arrayList.get(1);
            }
        }
        return this.mLastModified;
    }

    public String getAuthor() throws SPIException {
        Entity entity = null;
        String string = new String("");
        if (this.mPolicies == null) {
            this.getPolicies();
        }
        Iterator iterator = this.mPolicies.iterator();
        LdapPolicy ldapPolicy = null;
        long l = 0L;
        while (iterator.hasNext()) {
            LdapPolicy ldapPolicy2 = (LdapPolicy)iterator.next();
            long l2 = ldapPolicy2.getLastModified();
            if (l2 <= l) continue;
            l = l2;
            ldapPolicy = ldapPolicy2;
        }
        entity = this.getLastModifiedForEntry() >= l ? this.getAuthorForEntry() : ldapPolicy.getAuthor();
        if (entity != null) {
            string = entity.getDisplayName(null);
        }
        return string;
    }

    public Entity getAuthorForEntry() throws SPIException {
        if (this.mAuthor == null) {
            LdapEntity ldapEntity = (LdapEntity)this.getProfileRepository().getEntity();
            ArrayList arrayList = ldapEntity.getDataStore().getModificationDetails(this);
            this.setLastModified((String)arrayList.get(0));
            if (arrayList.size() > 1) {
                this.mAuthor = (Entity)arrayList.get(1);
            }
        }
        return this.mAuthor;
    }

    public void setLastModified(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.mLastModified = Timestamp.getMillis(string);
    }

    public String getComment() throws SPIException {
        if (this.mComment == null && !this.mNoCommentFound) {
            this.mComment = this.findComment();
        }
        if (this.mComment == null) {
            return new String("");
        }
        return this.mComment;
    }

    private String findComment() throws SPIException {
        return ((LdapEntity)this.getProfileRepository().getEntity()).getDataStore().getProfileComment(this);
    }

    public boolean equals(Object object) {
        if (object instanceof LdapProfile) {
            return LDAPDN.equals((String)this.mLocation.toLowerCase(), (String)((LdapProfile)object).mLocation.toLowerCase());
        }
        return false;
    }

    public boolean isLocal() {
        return LdapProfile.isLocalProfileDN(this.getId());
    }

    public static boolean isLocalProfileDN(String string) {
        String string2 = "ou=_defaulthostpolicygroup_";
        String string3 = "ou=_defaultuserpolicygroup_";
        return string.startsWith(string2) || string.startsWith(string3);
    }

    public void copy(LdapProfile ldapProfile) {
        this.mLocation = ldapProfile.getLocation();
        this.mLastModified = 0L;
        this.mAuthor = null;
        this.mId = ldapProfile.getId();
        this.mRepository = (ProfileRepositoryImpl)ldapProfile.getProfileRepository();
        this.mDisplayName = ldapProfile.getDisplayName();
        this.mApplicability = ldapProfile.getApplicability();
        this.mPriority = ldapProfile.getPriority();
        this.mComment = null;
    }
}

