/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.memory.profiles;

import com.sun.apoc.spi.PolicySource;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.memory.profiles.ProfileRepositoryImpl;
import com.sun.apoc.spi.policies.Policy;
import com.sun.apoc.spi.profiles.Applicability;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileProvider;
import com.sun.apoc.spi.profiles.ProfileRepository;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class ProfileProviderImpl
implements ProfileProvider {
    private static final String DEFAULT_REPOSITORY_ID = "default";
    private static ProfileRepository m_defaultRepository = null;
    private Hashtable m_repositories = null;
    private PolicySource m_mgr = null;

    public ProfileProviderImpl(PolicySource policySource) {
        this.m_mgr = policySource;
    }

    public void open() {
        m_defaultRepository = new ProfileRepositoryImpl(this.m_mgr, DEFAULT_REPOSITORY_ID);
        this.m_repositories = new Hashtable();
        this.m_repositories.put(DEFAULT_REPOSITORY_ID, m_defaultRepository);
        this.initializeSampleData();
    }

    public void close() {
        this.m_mgr = null;
        this.m_repositories = null;
        m_defaultRepository = null;
    }

    public ProfileRepository getDefaultProfileRepository() {
        return m_defaultRepository;
    }

    public ProfileRepository getProfileRepository(String string) {
        if (this.m_repositories.containsKey(string)) {
            return (ProfileRepository)this.m_repositories.get(string);
        }
        ProfileRepositoryImpl profileRepositoryImpl = new ProfileRepositoryImpl(this.m_mgr, string);
        this.m_repositories.put(string, profileRepositoryImpl);
        return profileRepositoryImpl;
    }

    public Iterator getProfileRepositories() {
        return this.m_repositories.values().iterator();
    }

    public Profile getProfile(String string) throws SPIException {
        int n = string.indexOf("/");
        if (n > 0) {
            String string2 = string.substring(n);
            ProfileRepository profileRepository = this.getProfileRepository(string2);
            return profileRepository.getProfile(string);
        }
        return null;
    }

    public Iterator getAllProfiles() throws SPIException {
        ArrayList<Profile> arrayList = new ArrayList<Profile>();
        Iterator iterator = this.getProfileRepositories();
        while (iterator.hasNext()) {
            ProfileRepository profileRepository = (ProfileRepository)iterator.next();
            Iterator iterator2 = profileRepository.getProfiles(Applicability.ALL);
            while (iterator2.hasNext()) {
                Profile profile = (Profile)iterator2.next();
                arrayList.add(profile);
            }
        }
        return arrayList.iterator();
    }

    public Iterator getAllProfiles(Entity entity) throws SPIException {
        throw new UnsupportedOperationException();
    }

    private void initializeSampleData() {
        try {
            Profile profile = m_defaultRepository.createProfile("StarOffice Novice", Applicability.ALL);
            profile.storePolicy(new Policy("com.sun.apoc.test", profile.getId(), "Just some dummy data"));
            profile.storePolicy(new Policy("com.sun.apoc.test2", profile.getId(), "and some more data"));
            Profile profile2 = m_defaultRepository.createProfile("APOC Agent Settings", Applicability.ALL);
            profile2.storePolicy(new Policy("com.sun.apoc.apocd", profile2.getId(), "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><oor:component-data xmlns:oor=\"http://openoffice.org/2001/registry\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" oor:name=\"apocd\" oor:package=\"com.sun.apoc\"><prop oor:name=\"DaemonChangeDetectionInterval\" oor:finalized=\"true\" oor:type=\"xs:int\"><value>10</value></prop></oor:component-data>"));
            Profile profile3 = m_defaultRepository.createProfile("Desktop Appearance", Applicability.ALL);
            profile3.storePolicy(new Policy("org.gnome.desktop.gnome", profile2.getId(), "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><oor:component-data xmlns:oor=\"http://openoffice.org/2001/registry\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" oor:name=\"gnome\" oor:package=\"org.gnome.desktop\"><node oor:name=\"background\"><prop oor:name=\"primary_color\" oor:type=\"xs:string\"><value>#c06600</value></prop></node></oor:component-data>"));
        }
        catch (SPIException sPIException) {
            sPIException.printStackTrace();
        }
    }
}

