/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.profiles;

import com.sun.apoc.spi.PolicySource;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.profiles.Applicability;
import com.sun.apoc.spi.profiles.InvalidDisplayNameException;
import com.sun.apoc.spi.profiles.InvalidProfileException;
import com.sun.apoc.spi.profiles.NullProfileException;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileRepository;
import com.sun.apoc.spi.profiles.ProfileStreamException;
import com.sun.apoc.spi.profiles.UnknownApplicabilityException;
import com.sun.apoc.spi.util.ZipImporterExporter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.TreeSet;

public abstract class ProfileRepositoryImpl
implements ProfileRepository {
    protected String mEntityId;
    protected String mId;
    protected PolicySource mPolicySource;

    public PolicySource getPolicySource() {
        return this.mPolicySource;
    }

    public int getMaxPriority(Applicability applicability) throws SPIException {
        int n = 0;
        Iterator iterator = this.getProfiles(applicability);
        while (iterator.hasNext()) {
            Profile profile = (Profile)iterator.next();
            int n2 = profile.getPriority();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public abstract Profile findProfile(String var1) throws SPIException;

    public Profile createProfile(String string, Applicability applicability) throws SPIException {
        if (string == null || string.length() == 0) {
            throw new InvalidDisplayNameException();
        }
        if (applicability.equals(Applicability.UNKNOWN)) {
            throw new UnknownApplicabilityException();
        }
        int n = this.getMaxPriority(applicability) + 1;
        return this.createTheProfile(string, applicability, n);
    }

    protected abstract Profile createTheProfile(String var1, Applicability var2, int var3) throws SPIException;

    public void destroyProfile(Profile profile) throws SPIException {
        if (profile.hasAssignedEntities()) {
            throw new InvalidProfileException("error.spi.profile.invalid.assigned");
        }
        this.deleteProfile(profile);
    }

    public void exportProfile(Profile profile, OutputStream outputStream) throws SPIException {
        if (profile == null) {
            throw new NullProfileException();
        }
        if (outputStream == null) {
            throw new ProfileStreamException("error.spi.profile.stream.null");
        }
        ZipImporterExporter zipImporterExporter = new ZipImporterExporter();
        zipImporterExporter.exportProfile(profile, outputStream);
    }

    public void importProfile(String string, Applicability applicability, InputStream inputStream) throws SPIException {
        if (string == null || string.length() == 0) {
            throw new InvalidDisplayNameException();
        }
        if (applicability != null && applicability.equals(Applicability.UNKNOWN)) {
            throw new UnknownApplicabilityException();
        }
        if (inputStream == null) {
            throw new ProfileStreamException("error.spi.profile.stream.null");
        }
        ZipImporterExporter zipImporterExporter = new ZipImporterExporter();
        zipImporterExporter.importProfile(this, string, applicability, inputStream);
    }

    public abstract Profile getProfile(String var1) throws SPIException;

    public Iterator getProfiles(Applicability applicability) throws SPIException {
        if (applicability.equals(Applicability.UNKNOWN)) {
            throw new UnknownApplicabilityException();
        }
        return this.getTheProfiles(applicability).iterator();
    }

    protected abstract TreeSet getTheProfiles(Applicability var1) throws SPIException;

    public abstract boolean isReadOnly() throws SPIException;

    public String getId() {
        return this.mId;
    }

    public abstract Entity getEntity() throws SPIException;

    protected abstract void deleteProfile(Profile var1) throws SPIException;
}

