/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.util;

import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.policies.Policy;
import com.sun.apoc.spi.profiles.Applicability;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileRepository;
import com.sun.apoc.spi.profiles.ProfileStreamException;
import com.sun.apoc.spi.profiles.ProfileZipException;
import com.sun.apoc.spi.profiles.ZipProfileReadWrite;
import com.sun.apoc.spi.util.ImporterExporter;
import com.sun.apoc.spi.util.StringRangeEnum;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipImporterExporter
implements ImporterExporter {
    public void exportProfile(Profile profile, OutputStream outputStream) throws SPIException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        try {
            ZipProfileReadWrite.writeMetaData(profile, zipOutputStream);
            ZipProfileReadWrite.writePolicies(profile, zipOutputStream);
            zipOutputStream.close();
        }
        catch (ZipException zipException) {
            try {
                zipOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProfileZipException(zipException);
        }
        catch (IOException iOException) {
            try {
                zipOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProfileStreamException("error.spi.profile.stream.error", iOException);
        }
    }

    public void importProfile(ProfileRepository profileRepository, String string, Applicability applicability, InputStream inputStream) throws SPIException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            Object object;
            Object object2;
            Profile profile;
            Object object3;
            Properties properties = ZipProfileReadWrite.readMetaData(zipInputStream);
            Iterator iterator = null;
            if (properties != null) {
                object3 = Applicability.getApplicability(properties.getProperty("Applicability"));
                if (!applicability.equals(object3)) {
                    Object[] objectArray = new Object[]{((StringRangeEnum)object3).getStringValue(), applicability.getStringValue()};
                    throw new SPIException("error.spi.profile.import", objectArray);
                }
                iterator = ZipProfileReadWrite.readPolicies(zipInputStream);
            } else {
                applicability = Applicability.USER;
                iterator = ZipProfileReadWrite.readOldPoliciesFormat(zipInputStream);
                if (!iterator.hasNext()) {
                    zipInputStream.close();
                    throw new ProfileStreamException("error.spi.profile.stream.empty");
                }
            }
            zipInputStream.close();
            object3 = profileRepository.getProfiles(applicability);
            ArrayList<Entity> arrayList = new ArrayList<Entity>();
            while (object3.hasNext()) {
                profile = (Profile)object3.next();
                if (profile == null || !profile.getDisplayName().equals(string) || !((Applicability)(object2 = profile.getApplicability())).equals(applicability)) continue;
                object = profile.getAssignedEntities();
                while (object.hasNext()) {
                    Entity entity = (Entity)object.next();
                    arrayList.add(entity);
                    entity.unassignProfile(profile);
                }
                profileRepository.destroyProfile(profile);
            }
            profile = profileRepository.createProfile(string, applicability);
            while (iterator.hasNext()) {
                profile.storePolicy((Policy)iterator.next());
            }
            if (properties != null) {
                profile.setComment(properties.getProperty("Comment"));
            }
            if (arrayList.size() != 0 && (object2 = arrayList.iterator()) != null) {
                while (object2.hasNext()) {
                    object = (Entity)object2.next();
                    object.assignProfile(profile);
                }
            }
        }
        catch (ZipException zipException) {
            try {
                zipInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProfileZipException(zipException);
        }
        catch (IOException iOException) {
            try {
                zipInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProfileStreamException("error.spi.profile.stream.error", iOException);
        }
    }
}

