/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.registration.servlet;

import com.sun.management.services.common.Debug;
import com.sun.management.services.logging.ConsoleLogService;
import com.sun.management.services.registration.MgmtAppRegistrationService;
import com.sun.management.services.registration.MgmtAppRegistrationServiceFactory;
import com.sun.management.services.registration.RegistrationException;
import com.sun.management.services.registration.RegistrationInfo;
import com.sun.management.services.registration.RegistrationUtil;
import com.sun.management.services.registration.UrlDesc;
import com.sun.management.services.registration.WebXmlParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xml.sax.InputSource;

public class WebConsoleRegistrarServlet
extends HttpServlet {
    private MgmtAppRegistrationService registrationSvc = null;
    private Logger logger;
    private static final String SERVLET_NAME = "WebConsoleRegistrarServlet";
    private static final String DTD_START = "<!DOCTYPE";
    private static final String DTD_END_DQ = "web-app_2_3.dtd\">";
    private static final String DTD_END_SQ = "web-app_2_3.dtd'>";
    private static final String RESOURCE_PKG = "com.sun.management.services.registration.servlet.resources.Resources";
    private static final String FILTER_TAG = "<filter>";
    private static final String FILTER_TAG_END = "</filter>";
    private static final String FILTER_CLASS_TAG = "<filter-class>";
    private static final String FILTER_CLASS_TAG_END = "</filter-class>";
    private static final String APP_FILTER_CLASS = "com.sun.management.services.session.AppSessionManagerFilter";
    private static final String CONSOLE_FILTER_CLASS = "com.sun.management.services.session.WebConsoleSMFilter";
    private static final String CONSOLE_PLUGIN_NAME = "com.sun.web.console";
    private static final String COMMON_PLUGIN_NAME = "com.sun.web.ui";
    private static final String PLUGIN_NAME = "com_sun_web_console_plugin_name";
    private static final String CONF_DIR_NAME = "conf";
    private static final String WEB_XML_FILE = "web.xml";

    public void init(ServletConfig config) throws ServletException {
        block14: {
            super.init(config);
            try {
                String dfltFlag;
                String temp;
                String path;
                int i;
                this.logger = ConsoleLogService.getConsoleLogger();
                ServletContext context = this.getServletContext();
                if (context == null) {
                    Debug.trace1((String)"Servlet context is null");
                    this.writeLogRecord(Level.SEVERE, "init", "log_context_null", null);
                    return;
                }
                String resource = "/WEB-INF/lib/registrationservlet.jar";
                String dpn = null;
                URL su = context.getResource(resource);
                if (su != null && (i = (path = su.getPath()).indexOf(resource)) > 0 && (i = (path = path.substring(0, i)).lastIndexOf(47)) >= 0) {
                    dpn = path.substring(i + 1);
                }
                MgmtAppRegistrationService registrationSvc = MgmtAppRegistrationServiceFactory.getRegistrationService();
                InputStream is = context.getResourceAsStream("/WEB-INF/app.xml");
                if (is == null && (is = context.getResourceAsStream("/app.xml")) == null) {
                    Debug.trace1((String)"no app.xml found for this app");
                    this.writeLogRecord(Level.SEVERE, "init", "log_no_app_xml", null);
                    return;
                }
                InputStreamReader isr = new InputStreamReader(is);
                RegistrationInfo regInfo = null;
                try {
                    regInfo = registrationSvc.parseDescriptor((Reader)isr);
                }
                catch (RegistrationException rex) {
                    dpn = dpn != null ? dpn : "unknown";
                    StringBuffer buf = new StringBuffer("Problem parsing application descriptor file for ").append(dpn).append(".\n").append(rex.getLocalizedMessage());
                    throw new RegistrationException(buf.toString());
                }
                String name = regInfo.getManagementApp().getPluginName();
                String cpn = "**CPN-NA**";
                UrlDesc ud = regInfo.getUrlDesc();
                if (ud != null && (temp = ud.getUrl()) != null) {
                    int i2;
                    if ((temp = temp.trim()).charAt(0) == '/') {
                        temp = temp.substring(1);
                    }
                    if ((i2 = temp.indexOf("/")) >= 0) {
                        temp = temp.substring(0, i2);
                    }
                    if (temp.length() > 0) {
                        cpn = temp;
                    }
                }
                if ((dfltFlag = context.getInitParameter("com.sun.web.console.defaultcontext")) != null && dfltFlag.equalsIgnoreCase("true") && registrationSvc.isAppRegistered(name)) {
                    Debug.trace3((String)("Default context app already registered: " + name));
                    return;
                }
                if (!this.checkFilterStatus(context, name)) break block14;
                registrationSvc.registerApp(regInfo, cpn);
                context.setAttribute(PLUGIN_NAME, (Object)name);
                try {
                    ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
                    RegistrationUtil.setAppLoader((String)name, (ClassLoader)loader);
                }
                catch (Exception e) {
                    Debug.trace1((String)("Exception getting classloader for " + name), (Throwable)e);
                }
                Debug.trace1((String)(name + " was registered successfully!"));
                this.writeLogRecord(Level.INFO, "init", "log_app_success", name);
                isr.close();
                is.close();
            }
            catch (Exception ex) {
                this.writeLogRecord(Level.SEVERE, "init", "log_cannot_register", ex.getMessage());
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(404);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(404);
    }

    public void destroy() {
        this.logger = ConsoleLogService.getConsoleLogger();
        String pluginName = null;
        ServletContext context = this.getServletContext();
        if (context != null) {
            pluginName = (String)context.getAttribute(PLUGIN_NAME);
        }
        if (pluginName == null) {
            Debug.trace1((String)"Servlet context is null in destroy...");
            ServletConfig config = this.getServletConfig();
            if (config != null) {
                pluginName = config.getInitParameter("pluginName") + "_" + config.getInitParameter("version");
            } else {
                Debug.trace1((String)"Servlet config is null in destroy...");
            }
        }
        if (pluginName != null) {
            Debug.trace3((String)("begin unregistering " + pluginName));
            try {
                MgmtAppRegistrationService registrationSvc = MgmtAppRegistrationServiceFactory.getRegistrationService();
                if (registrationSvc.isAppRegistered(pluginName)) {
                    registrationSvc.unregisterApp(pluginName);
                    Debug.trace1((String)(pluginName + " unregistered successfully"));
                    this.writeLogRecord(Level.INFO, "destroy", "log_app_unreg", pluginName);
                }
            }
            catch (Exception e) {
                Debug.trace1((String)"exception during destroy ", (Throwable)e);
            }
        }
    }

    private boolean checkFilterStatus(ServletContext context, String pluginName) throws Exception {
        if (pluginName.indexOf("com.sun.web.ui_") != -1) {
            return true;
        }
        Debug.trace3((String)("checking web.xml for filter: " + pluginName));
        InputStream is = context.getResourceAsStream("/WEB-INF/web.xml");
        if (is == null) {
            Debug.trace1((String)("unable to read web.xml for " + pluginName));
            this.writeLogRecord(Level.SEVERE, "checkFilterStatus", "log_cannot_check_filter", null);
            return false;
        }
        String sxml = WebXmlParser.neuterWebXml((String)WebXmlParser.trimWebXml((InputStream)is));
        if (sxml == null) {
            Debug.trace1((String)("unable to trim web.xml for " + pluginName));
            this.writeLogRecord(Level.SEVERE, "checkFilterStatus", "log_cannot_check_filter", null);
            return false;
        }
        StringReader reader = new StringReader(sxml);
        InputSource source = new InputSource(reader);
        WebXmlParser parser = new WebXmlParser();
        try {
            parser.parse(source);
        }
        catch (Exception ex) {
            Debug.trace1((String)("Error parsing web.xml for " + pluginName + ": " + ex.getMessage()));
            this.writeLogRecord(Level.SEVERE, "checkFilterStatus", "log_cannot_check_filter", null);
            return false;
        }
        if (!parser.isFilterSet()) {
            Debug.trace1((String)"Filter has not been set properly");
            this.writeLogRecord(Level.SEVERE, "checkFilterStatus", "log_no_filter", pluginName);
            return false;
        }
        String filterClassName = parser.getFilterImplClassName();
        if (pluginName.indexOf(CONSOLE_PLUGIN_NAME) != -1) {
            if (!filterClassName.equals(CONSOLE_FILTER_CLASS)) {
                this.writeLogRecord(Level.SEVERE, "checkFilterStatus", "log_improper_filter", pluginName);
                return false;
            }
        } else if (!filterClassName.equals(APP_FILTER_CLASS)) {
            this.writeLogRecord(Level.SEVERE, "checkFilterStatus", "log_improper_filter", pluginName);
            return false;
        }
        try {
            reader.close();
        }
        catch (Exception ex) {
            Debug.trace1((String)("error closing web.xml of " + pluginName), (Throwable)ex);
        }
        return true;
    }

    private void writeLogRecord(Level logLevel, String method, String resource_key, String data) {
        try {
            if (data == null) {
                this.logger.logrb(logLevel, SERVLET_NAME, method, RESOURCE_PKG, resource_key);
            } else {
                this.logger.logrb(logLevel, SERVLET_NAME, method, RESOURCE_PKG, resource_key, (Object)data);
            }
        }
        catch (Exception e) {
            Debug.trace1((String)("Error while logging: " + e.getLocalizedMessage()));
        }
    }
}

