/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.templates.parsing;

import com.sun.apoc.templates.parsing.LocalizedElement;

public abstract class TemplateElement
implements LocalizedElement {
    public static final String GLOBAL = "global";
    public static final String USER = "user";
    public static final String HOST = "host";
    public static final byte USER_SCOPE = 1;
    public static final byte HOST_SCOPE = 2;
    public static final byte GLOBAL_SCOPE = 3;
    private String m_defaultName = null;
    private String m_resourceBundle = null;
    private String m_resourceId = null;
    private byte m_scope = (byte)3;

    public TemplateElement(String string, String string2, String string3, String string4) {
        this.m_defaultName = string;
        this.m_resourceId = string3 != null ? string3 : string;
        this.m_resourceBundle = string4;
        this.setScope(string2);
    }

    protected void setScope(String string) {
        if (string != null) {
            if (string.indexOf(USER) != -1) {
                this.m_scope = 1;
            } else if (string.indexOf(HOST) != -1) {
                this.m_scope = (byte)2;
            }
        }
    }

    public final String getDefaultName() {
        return this.m_defaultName;
    }

    public final String getResourceBundle() {
        return this.m_resourceBundle;
    }

    public final String getResourceId() {
        return this.m_resourceId;
    }

    public final boolean hasUserScope() {
        return (this.m_scope & 1) != 0;
    }

    public final boolean hasHostScope() {
        return (this.m_scope & 2) != 0;
    }

    public final boolean hasGlobalScope() {
        return (this.m_scope & 3) != 0;
    }

    public final boolean isInScope(byte by) {
        return (this.m_scope & by) != 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" - ");
        stringBuffer.append(this.getDefaultName());
        stringBuffer.append(" (");
        stringBuffer.append(this.getResourceId());
        stringBuffer.append(", ");
        stringBuffer.append(this.getResourceBundle());
        stringBuffer.append(") ");
        return stringBuffer.toString();
    }
}

