/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.cli.util;

import com.sun.apoc.cli.util.CLIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.environment.PasswordCodec;
import com.sun.apoc.spi.ldap.environment.LdapEnvironmentMgr;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class FileCredentials {
    private static char KEY_SEPARATOR = (char)58;
    private static char USER_ENTRY_KEY_PREFIX = (char)49;
    private static char USER_PASSWORD_KEY_PREFIX = (char)50;
    public static final String CREDENTIALS_FILENAME = ".apocpass";
    private static final String CREDENTIALS_PERMISSIONS = "-rw------";

    public static void storeUserCredentials(File file, Hashtable hashtable, Entity entity) throws CLIException {
        if (file == null) {
            file = FileCredentials.createCredentialsFile();
        }
        Properties properties = new Properties();
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            properties.load(bufferedInputStream);
            bufferedInputStream.close();
            properties.setProperty(FileCredentials.createKey(hashtable, USER_ENTRY_KEY_PREFIX), entity.getId());
            char[] cArray = (char[])hashtable.get("SECURITY_CREDENTIALS");
            String string = (String)hashtable.get("SECURITY_CREDENTIALS_ENCODING");
            if (string == null || !string.equals("scramble")) {
                cArray = PasswordCodec.encode((char[])cArray);
            }
            properties.setProperty(FileCredentials.createKey(hashtable, USER_PASSWORD_KEY_PREFIX), new String(cArray));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            properties.store(bufferedOutputStream, "Credentials File");
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            throw new CLIException("pgtool: unable to write to user's .apocpass file.", CLIException.COMMAND_FAILURE);
        }
    }

    public static Properties getCredentialsFileProperties(File file) throws CLIException {
        if (file == null || !file.exists()) {
            return null;
        }
        Properties properties = null;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            properties = new Properties();
            properties.load(bufferedInputStream);
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            throw new CLIException("pgtool: unable to read user's .apocpass file.", CLIException.COMMAND_FAILURE);
        }
        return properties;
    }

    public static String getUserNameFromKey(String string) {
        String string2 = null;
        int n = string.lastIndexOf(KEY_SEPARATOR);
        if (n > 0) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public static String getStoredUserEntry(Properties properties, Hashtable hashtable) {
        String string = FileCredentials.createKey(hashtable, USER_ENTRY_KEY_PREFIX);
        return properties.getProperty(string);
    }

    public static String getStoredUserEntry(Properties properties, String string) {
        return properties.getProperty(string);
    }

    public static ArrayList getStoredUserEntryKeys(Properties properties, Hashtable hashtable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = FileCredentials.createPartialKey(hashtable, USER_ENTRY_KEY_PREFIX).toString();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static char[] getStoredUserPassword(Properties properties, Hashtable hashtable) {
        char[] cArray = null;
        String string = FileCredentials.createKey(hashtable, USER_PASSWORD_KEY_PREFIX);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(properties.getProperty(string));
        if (stringBuffer.length() != 0) {
            cArray = new char[stringBuffer.length()];
            for (int i = 0; i < stringBuffer.length(); ++i) {
                cArray[i] = stringBuffer.charAt(i);
            }
        }
        return cArray;
    }

    public static char[] getStoredUserPassword(Properties properties, String string) {
        char[] cArray = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(USER_PASSWORD_KEY_PREFIX);
        stringBuffer.append(string.substring(1));
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(properties.getProperty(stringBuffer.toString()));
        if (stringBuffer2.length() != 0) {
            cArray = new char[stringBuffer2.length()];
            for (int i = 0; i < stringBuffer2.length(); ++i) {
                cArray[i] = stringBuffer2.charAt(i);
            }
        }
        return cArray;
    }

    private static StringBuffer createPartialKey(Hashtable hashtable, char c) {
        String string = (String)hashtable.get("PROVIDER_URL");
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(c);
        stringBuffer.append(KEY_SEPARATOR);
        int n = FileCredentials.escapeKeySeparator(stringBuffer, 2);
        String string2 = LdapEnvironmentMgr.getProtocolFromURL((String)string);
        stringBuffer.append(string2);
        n = FileCredentials.escapeKeySeparator(stringBuffer, n);
        stringBuffer.append(KEY_SEPARATOR);
        String string3 = LdapEnvironmentMgr.getHostFromURL((String)string);
        stringBuffer.append(string3);
        n = FileCredentials.escapeKeySeparator(stringBuffer, n + 1);
        stringBuffer.append(KEY_SEPARATOR);
        String string4 = String.valueOf(LdapEnvironmentMgr.getPortFromURL((String)string));
        stringBuffer.append(string4);
        n = FileCredentials.escapeKeySeparator(stringBuffer, n + 1);
        stringBuffer.append(KEY_SEPARATOR);
        String string5 = LdapEnvironmentMgr.getBaseEntryFromURL((String)string);
        stringBuffer.append(string5);
        n = FileCredentials.escapeKeySeparator(stringBuffer, n + 1);
        stringBuffer.append(KEY_SEPARATOR);
        return stringBuffer;
    }

    private static String createKey(Hashtable hashtable, char c) {
        StringBuffer stringBuffer = FileCredentials.createPartialKey(hashtable, c);
        int n = stringBuffer.length();
        stringBuffer.append((String)hashtable.get("SECURITY_PRINCIPAL"));
        FileCredentials.escapeKeySeparator(stringBuffer, n + 1);
        return stringBuffer.toString();
    }

    private static int escapeKeySeparator(StringBuffer stringBuffer, int n) {
        for (int i = n; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != KEY_SEPARATOR) continue;
            stringBuffer.insert(i, KEY_SEPARATOR);
            ++i;
        }
        return stringBuffer.length();
    }

    public static File getExistingCredentialsFile() throws CLIException {
        File file = FileCredentials.getCredentialsFileObject();
        if (file.exists()) {
            FileCredentials.checkCredentialsFilePermissions(file);
            return file;
        }
        return null;
    }

    private static File createCredentialsFile() throws CLIException {
        File file = FileCredentials.getCredentialsFileObject();
        if (file.exists()) {
            FileCredentials.checkCredentialsFilePermissions(file);
        } else {
            try {
                file.createNewFile();
                FileCredentials.setCredentialsFilePermissions(file);
            }
            catch (Exception exception) {
                throw new CLIException("pgtool: cannot create .apocpass file in the user's home directory.", CLIException.COMMAND_FAILURE);
            }
        }
        return file;
    }

    private static File getCredentialsFileObject() throws CLIException {
        String string = null;
        Object var1_1 = null;
        string = System.getProperty("user.home");
        File file = new File(string);
        if (!file.isDirectory() || !file.canWrite()) {
            throw new CLIException("pgtool: cannot access the user's home directory: " + string, CLIException.COMMAND_FAILURE);
        }
        return new File(file, CREDENTIALS_FILENAME);
    }

    private static void checkCredentialsFilePermissions(File file) throws CLIException {
        String string = null;
        try {
            String[] stringArray = new String[]{"ls", "-l", file.getAbsolutePath()};
            Process process = Runtime.getRuntime().exec(stringArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            throw new CLIException("pgtool: cannot access the user's .apocpass file.", CLIException.COMMAND_FAILURE);
        }
        if (!string.startsWith(CREDENTIALS_PERMISSIONS)) {
            throw new CLIException("pgtool: permissions should be 600 on user's .apocpass file.", CLIException.COMMAND_FAILURE);
        }
    }

    private static void setCredentialsFilePermissions(File file) throws CLIException {
        try {
            String[] stringArray = new String[]{"chmod", "600", file.getAbsolutePath()};
            Runtime.getRuntime().exec(stringArray);
        }
        catch (Exception exception) {
            throw new CLIException("pgtool: cannot create .apocpass file in the user's home directory.", CLIException.COMMAND_FAILURE);
        }
    }
}

