/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.policy.cfgtree;

import com.sun.apoc.policy.cfgtree.ConfigNode;
import com.sun.apoc.policy.cfgtree.ConfigNodeImpl;
import com.sun.apoc.policy.cfgtree.HierarchyNodeImpl;
import com.sun.apoc.policy.cfgtree.NodeParsing;
import com.sun.apoc.policy.cfgtree.NodeType;
import com.sun.apoc.policy.common.EntityId;
import com.sun.apoc.policy.common.NodeKey;
import com.sun.apoc.policy.common.PolicyGroupIdImpl;
import com.sun.apoc.policy.common.PolicyId;
import com.sun.apoc.policy.common.RegistryException;
import com.sun.apoc.policy.datastore.DataStore;
import com.sun.apoc.policy.organization.Organization;
import com.sun.apoc.policy.pmgr.ClientContext;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ConfigDataManager {
    private Organization mOrganization;
    private DataStore mDataStore;
    private String mConfigDataLocaleName;
    private String mApplicationLocaleName;
    private NodeParsing mParser = new NodeParsing();
    private XMLReader mReader;
    protected MergedNodeCache mMergedCache;
    private int mMaximumCacheEntries = 20;
    private static final String MODULE = "ConfigDataManager";
    private static final String SAX_NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static final String SAX_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    public static final int BUFFER_SIZE = 200;
    private static final SAXParserFactory sSAXParserFactory = SAXParserFactory.newInstance();

    public ConfigDataManager(DataStore dataStore, Organization organization) throws RegistryException {
        this.mOrganization = organization;
        this.mDataStore = dataStore;
        if (this.mOrganization == null || this.mDataStore == null) {
            throw new RegistryException("Cannot instantiate ConfigDataManager.", "error.application.initialize", MODULE, 0);
        }
        try {
            this.mParser.setConfigDataManager(this);
            this.mReader = sSAXParserFactory.newSAXParser().getXMLReader();
            this.mReader.setContentHandler(this.mParser);
            this.mReader.setFeature(SAX_NAMESPACES, true);
            this.mReader.setFeature(SAX_NAMESPACE_PREFIXES, true);
            this.mReader.setErrorHandler(this.mParser);
        }
        catch (Exception exception) {
            throw new RegistryException("The parser cannot be created. " + exception, "error.create.parser", MODULE, 0);
        }
    }

    public void setMaximumCacheEntries(int n) {
        if (n != this.mMaximumCacheEntries) {
            this.mMaximumCacheEntries = n;
            if (this.mMergedCache == null) {
                this.mMergedCache = new MergedNodeCache(n);
            } else {
                this.mMergedCache.setMaxEntries(n);
            }
        }
    }

    public void flushNodeCache() {
        if (this.mMergedCache != null) {
            this.mMergedCache.flush();
        }
    }

    public void setConfigDataLocaleName(String string) {
        this.mConfigDataLocaleName = string;
    }

    private void checkUpdateNodeValidity(ConfigNodeImpl configNodeImpl, String string) throws RegistryException {
        if (configNodeImpl.getName() == null) {
            throw new RegistryException("The policy data is invalid.", "error.policy.data.invalid", MODULE, 0);
        }
        String string2 = configNodeImpl.getPackage();
        String string3 = configNodeImpl.getName();
        if (string2 == null || string3 == null || !string.equalsIgnoreCase(string2 + "." + string3)) {
            throw new RegistryException("The package or component name is invalid in the update data for the component " + configNodeImpl.getName() + ".", "error.policy.data.invalid", MODULE, 0);
        }
    }

    private void readMergeUpdateLayer(ConfigNodeImpl configNodeImpl, ConfigNodeImpl configNodeImpl2, NodeKey nodeKey, boolean bl, ClientContext clientContext) throws RegistryException {
        Vector vector;
        String string = configNodeImpl2.getPackage() + "." + configNodeImpl.getName();
        if (configNodeImpl2.isFinalized()) {
            configNodeImpl.setFinalized(true, configNodeImpl.getPath(), (PolicyGroupIdImpl)configNodeImpl2.getOriginOfFinalized());
            if (bl) {
                configNodeImpl.setReadOnly();
            }
        }
        if ((vector = configNodeImpl2.getChildrenVector()) != null) {
            string = string + "/";
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ConfigNodeImpl configNodeImpl3 = (ConfigNodeImpl)vector.get(i);
                if (configNodeImpl3 == null || configNodeImpl3.getName() == null) continue;
                String string2 = string + configNodeImpl3.getName();
                configNodeImpl3.processReadOperation(configNodeImpl, nodeKey, string2, bl);
            }
        }
    }

    private ConfigNode createChildNode(ConfigNode configNode, StringTokenizer stringTokenizer, NodeType nodeType, boolean bl, PolicyGroupIdImpl policyGroupIdImpl) throws RegistryException {
        int n = stringTokenizer.countTokens();
        ConfigNodeImpl configNodeImpl = null;
        ConfigNodeImpl configNodeImpl2 = null;
        String string = null;
        if (n != 0) {
            for (int i = 1; i < n; ++i) {
                string = stringTokenizer.nextToken();
                configNodeImpl2 = (ConfigNodeImpl)configNode.getChild(string);
                if (configNodeImpl2 == null) {
                    ((HierarchyNodeImpl)configNode).addNode(string, policyGroupIdImpl);
                }
                configNode = configNode.getChild(string);
            }
            string = stringTokenizer.nextToken();
            ConfigNode configNode2 = configNode.getChild(string);
            if (configNode2 != null && ((ConfigNodeImpl)configNode2).getOperationType() != 2) {
                return configNode2;
            }
            configNodeImpl = nodeType == NodeType.PROPERTY ? ((HierarchyNodeImpl)configNode).addProperty(string, policyGroupIdImpl) : ((HierarchyNodeImpl)configNode).addNode(string, policyGroupIdImpl);
            if (bl) {
                configNodeImpl.setDynamic();
                configNodeImpl.setOperationType(1);
            }
        }
        return string == null ? configNode : configNodeImpl;
    }

    private HierarchyNodeImpl createComponentNode(String string, PolicyGroupIdImpl policyGroupIdImpl) throws RegistryException {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            throw new RegistryException("Invalid path name specified.", "error.path.invalid", MODULE, 0);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        HierarchyNodeImpl hierarchyNodeImpl = new HierarchyNodeImpl();
        hierarchyNodeImpl.setName(string3);
        hierarchyNodeImpl.setPackage(string2);
        hierarchyNodeImpl.setPath(string);
        hierarchyNodeImpl.setConfigDataManager(this);
        EntityId entityId = policyGroupIdImpl.getContainerId();
        if (entityId != null) {
            if (this.mMergedCache == null) {
                this.mMergedCache = new MergedNodeCache(this.mMaximumCacheEntries);
            }
            this.mMergedCache.put(string, hierarchyNodeImpl, policyGroupIdImpl, this.mConfigDataLocaleName);
        }
        return hierarchyNodeImpl;
    }

    private ConfigNodeImpl parseData(String string, NodeKey nodeKey) throws RegistryException {
        if (string == null) {
            return null;
        }
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        try {
            this.mParser.setSourceLayer(nodeKey.mGroupLayer);
            this.mParser.setLocale(nodeKey.mLocale);
            this.mParser.setComponentName(nodeKey.mComponentName);
            this.mReader.parse(inputSource);
            return (ConfigNodeImpl)this.mParser.mRoot;
        }
        catch (Exception exception) {
            throw new RegistryException("The policy data cannot be read: " + exception, "error.policy.read", MODULE, 0);
        }
    }

    private Hashtable getUniqueComponentNodes(ConfigNode[] configNodeArray) throws RegistryException {
        int n = configNodeArray.length;
        Hashtable<String, ConfigNode> hashtable = new Hashtable<String, ConfigNode>();
        StringTokenizer stringTokenizer = null;
        for (int i = 0; i < n; ++i) {
            ConfigNode configNode;
            if (configNodeArray[i] == null || configNodeArray[i].getName() == null || configNodeArray[i].getPath() == null) {
                throw new RegistryException("The policy data is invalid.", "error.policy.data.invalid", MODULE, 0);
            }
            String string = configNodeArray[i].getPath();
            stringTokenizer = new StringTokenizer(string, "/");
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
            if (string != null) {
                configNode = configNodeArray[i];
                while (configNode.getParent() != null) {
                    configNode = configNode.getParent();
                }
            } else {
                throw new RegistryException("The policy data is invalid.", "error.policy.data.invalid", MODULE, 0);
            }
            hashtable.put(string, configNode);
        }
        return hashtable;
    }

    private ConfigNodeImpl createUpdateNode(ConfigNodeImpl configNodeImpl, PolicyGroupIdImpl policyGroupIdImpl) throws RegistryException {
        String string;
        ConfigNodeImpl configNodeImpl2 = configNodeImpl.shallowCopy();
        boolean bl = configNodeImpl.processUpdateNodeChildren(configNodeImpl2, policyGroupIdImpl, string = configNodeImpl.getPackage() + "." + configNodeImpl.getName() + "/");
        if (!bl) {
            configNodeImpl2 = configNodeImpl.isFinalized() ? configNodeImpl.shallowCopy() : null;
        }
        return configNodeImpl2;
    }

    public ConfigNode createNode(String string, NodeType nodeType, PolicyGroupIdImpl policyGroupIdImpl, boolean bl, ClientContext clientContext) throws RegistryException {
        if (string == null || nodeType == null || nodeType == NodeType.UNKNOWN || policyGroupIdImpl == null) {
            throw new RegistryException("Cannot create node as parameters are invalid.", "error.occurred", MODULE, 0);
        }
        EntityId entityId = policyGroupIdImpl.getContainerId();
        ConfigNodeImpl configNodeImpl = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        String string2 = stringTokenizer.nextToken();
        if (entityId != null) {
            configNodeImpl = this.readComponent(string2, policyGroupIdImpl, clientContext);
            if (configNodeImpl == null) {
                configNodeImpl = this.createComponentNode(string2, policyGroupIdImpl);
                configNodeImpl.setOrigin(policyGroupIdImpl);
            }
            return this.createChildNode(configNodeImpl, stringTokenizer, nodeType, bl, policyGroupIdImpl);
        }
        configNodeImpl = this.readPolicyGroupComponent(string2, policyGroupIdImpl, clientContext);
        if (configNodeImpl == null) {
            configNodeImpl = this.createComponentNode(string2, policyGroupIdImpl);
            configNodeImpl.setOrigin(policyGroupIdImpl);
        }
        return this.createChildNode(configNodeImpl, stringTokenizer, nodeType, bl, policyGroupIdImpl);
    }

    private ConfigNodeImpl readPolicyGroupComponent(String string, PolicyGroupIdImpl policyGroupIdImpl, ClientContext clientContext) throws RegistryException {
        ConfigNodeImpl configNodeImpl = null;
        if (string == null) {
            throw new RegistryException("The name of the configuration policy is null.", "error.policy.invalid", MODULE, 0);
        }
        PolicyId policyId = this.mOrganization.getPolicyId(string, policyGroupIdImpl, false, clientContext);
        if (policyId != null) {
            NodeKey nodeKey = new NodeKey();
            nodeKey.mComponentName = string;
            nodeKey.mLocale = this.mConfigDataLocaleName;
            nodeKey.mGroupLayer = policyGroupIdImpl;
            configNodeImpl = this.parseData(policyId.getData(), nodeKey);
            if (configNodeImpl != null) {
                configNodeImpl.setSettingsForAddedNode(configNodeImpl.getPackage() + "." + configNodeImpl.getName(), policyGroupIdImpl, true);
            }
        }
        return configNodeImpl;
    }

    private ConfigNodeImpl readComponent(String string, PolicyGroupIdImpl policyGroupIdImpl, ClientContext clientContext) throws RegistryException {
        ConfigNodeImpl configNodeImpl;
        if (string == null) {
            throw new RegistryException("The name of the configuration policy is null.", "error.policy.invalid", MODULE, 0);
        }
        EntityId entityId = policyGroupIdImpl.getContainerId();
        if (this.mMergedCache == null) {
            this.mMergedCache = new MergedNodeCache(this.mMaximumCacheEntries);
        } else {
            configNodeImpl = this.mMergedCache.find(string, policyGroupIdImpl, this.mConfigDataLocaleName);
            if (configNodeImpl != null || this.mMergedCache.containsKey(string, policyGroupIdImpl, this.mConfigDataLocaleName)) {
                return configNodeImpl;
            }
        }
        configNodeImpl = null;
        String[] stringArray = new String[]{string};
        PolicyId[][] policyIdArray = this.mOrganization.getLayeredPolicies(entityId, stringArray, false, clientContext);
        int n = policyIdArray[0].length;
        if (n == 0) {
            this.mMergedCache.put(string, configNodeImpl, policyGroupIdImpl, this.mConfigDataLocaleName);
            return configNodeImpl;
        }
        NodeKey nodeKey = new NodeKey();
        nodeKey.mComponentName = string;
        nodeKey.mLocale = this.mConfigDataLocaleName;
        ConfigNodeImpl configNodeImpl2 = null;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            nodeKey.mGroupLayer = (PolicyGroupIdImpl)policyIdArray[0][i].getPolicySetId();
            configNodeImpl2 = this.parseData(policyIdArray[0][i].getData(), nodeKey);
            if (configNodeImpl2 == null) continue;
            this.checkUpdateNodeValidity(configNodeImpl2, string);
            if (bl && i == n - 1 && nodeKey.mGroupLayer.getContainerId() != null && nodeKey.mGroupLayer.getContainerId().equals(entityId)) {
                bl = false;
                if (configNodeImpl != null) {
                    configNodeImpl.addNodeDefaults();
                }
            }
            if (configNodeImpl == null) {
                configNodeImpl = configNodeImpl2;
                if (n == 1) {
                    configNodeImpl.setSettingsForAddedNode(configNodeImpl.getPackage() + "." + configNodeImpl.getName(), nodeKey.mGroupLayer, bl);
                    if (bl) {
                        configNodeImpl.setReadOnly();
                    }
                } else {
                    configNodeImpl.expand(configNodeImpl.getPackage() + "." + configNodeImpl.getName(), bl);
                }
            } else {
                this.readMergeUpdateLayer(configNodeImpl, configNodeImpl2, nodeKey, bl, clientContext);
            }
            if (configNodeImpl.isReadOnly()) break;
        }
        if (bl) {
            configNodeImpl.addNodeDefaults();
        }
        this.mMergedCache.put(string, configNodeImpl, policyGroupIdImpl, this.mConfigDataLocaleName);
        return configNodeImpl;
    }

    public void updateNodes(ConfigNode[] configNodeArray, PolicyGroupIdImpl policyGroupIdImpl, ClientContext clientContext) throws RegistryException {
        if (configNodeArray == null) {
            throw new RegistryException("Invalid parameter for method that updates data.", "error.occurred", MODULE, 0);
        }
        EntityId entityId = policyGroupIdImpl.getContainerId();
        if (entityId == null) {
            this.processGlobalPolicyGroupUpdate(configNodeArray, policyGroupIdImpl, clientContext);
            this.flushNodeCache();
        } else {
            this.processEntityPolicyGroupUpdate(configNodeArray, policyGroupIdImpl, clientContext);
        }
    }

    private void processGlobalPolicyGroupUpdate(ConfigNode[] configNodeArray, PolicyGroupIdImpl policyGroupIdImpl, ClientContext clientContext) throws RegistryException {
        Object object;
        Object object2;
        NodeKey nodeKey = new NodeKey();
        nodeKey.mGroupLayer = policyGroupIdImpl;
        Hashtable<Object, Vector<ConfigNode>> hashtable = new Hashtable<Object, Vector<ConfigNode>>();
        for (int i = 0; i < configNodeArray.length; ++i) {
            if (configNodeArray[i] == null || configNodeArray[i].getName() == null || configNodeArray[i].getPath() == null) {
                throw new RegistryException("The policy data is invalid.", "error.policy.data.invalid", MODULE, 0);
            }
            object2 = new StringTokenizer(configNodeArray[i].getPath(), "/");
            object = null;
            if (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
            }
            if (object == null) break;
            Vector<ConfigNode> vector = (Vector<ConfigNode>)hashtable.get(object);
            if (vector == null) {
                vector = new Vector<ConfigNode>();
                hashtable.put(object, vector);
            }
            vector.add(configNodeArray[i]);
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object object3;
            ConfigNodeImpl configNodeImpl;
            nodeKey.mComponentName = (String)enumeration.nextElement();
            object2 = (Vector)hashtable.get(nodeKey.mComponentName);
            if (object2 == null || ((Vector)object2).isEmpty()) break;
            object = this.readPolicyGroupComponent(nodeKey.mComponentName, policyGroupIdImpl, clientContext);
            int n = -1;
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                int n2;
                configNodeImpl = (ConfigNodeImpl)((Vector)object2).get(i);
                n = configNodeImpl.getOperationType();
                if (object == null) {
                    if (n == 2) continue;
                    object = configNodeImpl;
                    while (((ConfigNodeImpl)object).getParent() != null) {
                        object = (ConfigNodeImpl)((ConfigNodeImpl)object).getParent();
                    }
                    continue;
                }
                object3 = new Vector<ConfigNodeImpl>();
                while (configNodeImpl.getParent() != null) {
                    ((Vector)object3).add(configNodeImpl);
                    configNodeImpl = (ConfigNodeImpl)configNodeImpl.getParent();
                }
                int n3 = ((Vector)object3).size();
                ConfigNodeImpl configNodeImpl2 = null;
                if (n == 2) {
                    if (n3 > 1) {
                        for (n2 = n3 - 1; n2 > 0 && (object = (ConfigNodeImpl)((ConfigNodeImpl)object).getChild((configNodeImpl2 = (ConfigNodeImpl)((Vector)object3).get(n2)).getName())) != null; --n2) {
                        }
                    }
                    if (object == null) continue;
                    configNodeImpl2 = (ConfigNodeImpl)((Vector)object3).get(0);
                    if (configNodeImpl2 != null) {
                        ((HierarchyNodeImpl)object).deleteChild(configNodeImpl2.getName());
                    }
                    while (((ConfigNodeImpl)object).getParent() != null) {
                        object = (ConfigNodeImpl)((ConfigNodeImpl)object).getParent();
                    }
                    continue;
                }
                if (n3 > 1) {
                    for (n2 = n3 - 1; n2 > 0; --n2) {
                        configNodeImpl2 = (ConfigNodeImpl)((Vector)object3).get(n2);
                        String string = configNodeImpl2.getName();
                        if (((ConfigNodeImpl)object).getChild(string) == null) {
                            ((HierarchyNodeImpl)object).addHierarchyNode(string);
                        }
                        object = (ConfigNodeImpl)((ConfigNodeImpl)object).getChild(string);
                    }
                }
                if ((configNodeImpl2 = (ConfigNodeImpl)((Vector)object3).get(0)) != null) {
                    ((ConfigNodeImpl)object).addChild(configNodeImpl2);
                }
                while (((ConfigNodeImpl)object).getParent() != null) {
                    object = (ConfigNodeImpl)((ConfigNodeImpl)object).getParent();
                }
            }
            String string = null;
            if (object != null && ((ConfigNodeImpl)object).hasChildren() && (configNodeImpl = this.createUpdateNode((ConfigNodeImpl)object, null)) != null) {
                object3 = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream((OutputStream)object3);
                configNodeImpl.printToStream("", printStream, 0);
                string = ((ByteArrayOutputStream)object3).toString();
            }
            this.mDataStore.writeComponent(nodeKey, string, clientContext);
        }
    }

    private void processEntityPolicyGroupUpdate(ConfigNode[] configNodeArray, PolicyGroupIdImpl policyGroupIdImpl, ClientContext clientContext) throws RegistryException {
        NodeKey nodeKey = new NodeKey();
        nodeKey.mGroupLayer = policyGroupIdImpl;
        EntityId entityId = policyGroupIdImpl.getContainerId();
        Hashtable hashtable = this.getUniqueComponentNodes(configNodeArray);
        Enumeration enumeration = hashtable.keys();
        ConfigNodeImpl configNodeImpl = null;
        ConfigNodeImpl configNodeImpl2 = null;
        Object var10_10 = null;
        while (enumeration.hasMoreElements()) {
            nodeKey.mComponentName = (String)enumeration.nextElement();
            configNodeImpl = (ConfigNodeImpl)hashtable.get(nodeKey.mComponentName);
            configNodeImpl2 = this.createUpdateNode(configNodeImpl, policyGroupIdImpl);
            String string = null;
            if (configNodeImpl2 != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(byteArrayOutputStream);
                configNodeImpl2.printToStream("", printStream, 1);
                string = byteArrayOutputStream.toString();
            }
            this.mDataStore.writeComponent(nodeKey, string, clientContext);
        }
    }

    public ConfigNode getNode(String string, PolicyGroupIdImpl policyGroupIdImpl, PolicyGroupIdImpl policyGroupIdImpl2, ClientContext clientContext) throws RegistryException {
        ConfigNodeImpl configNodeImpl = (ConfigNodeImpl)this.getNode(string, policyGroupIdImpl, clientContext);
        ConfigNodeImpl configNodeImpl2 = (ConfigNodeImpl)this.getNode(string, policyGroupIdImpl2, clientContext);
        if (configNodeImpl == null) {
            return configNodeImpl2;
        }
        if (configNodeImpl2 == null) {
            return configNodeImpl;
        }
        NodeKey nodeKey = new NodeKey();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        nodeKey.mComponentName = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : string;
        nodeKey.mLocale = this.mConfigDataLocaleName;
        ConfigNodeImpl configNodeImpl3 = (ConfigNodeImpl)configNodeImpl.getParent();
        if (configNodeImpl3 == null) {
            configNodeImpl3 = configNodeImpl;
        } else {
            while (configNodeImpl3.getParent() != null) {
                configNodeImpl3 = (ConfigNodeImpl)configNodeImpl3.getParent();
            }
        }
        ConfigNodeImpl configNodeImpl4 = (ConfigNodeImpl)configNodeImpl2.getParent();
        if (configNodeImpl4 == null) {
            configNodeImpl4 = configNodeImpl2;
        } else {
            while (configNodeImpl4.getParent() != null) {
                configNodeImpl4 = (ConfigNodeImpl)configNodeImpl4.getParent();
            }
        }
        this.readMergeUpdateLayer(configNodeImpl4, configNodeImpl3, nodeKey, false, clientContext);
        while (configNodeImpl4 != null && stringTokenizer.hasMoreTokens()) {
            configNodeImpl4 = (ConfigNodeImpl)configNodeImpl4.getChild(stringTokenizer.nextToken());
        }
        return configNodeImpl4;
    }

    public ConfigNode getNode(String string, PolicyGroupIdImpl policyGroupIdImpl, ClientContext clientContext) throws RegistryException {
        if (string == null) {
            throw new RegistryException("The name of the configuration policy is null.", "error.policy.invalid", MODULE, 0);
        }
        if (policyGroupIdImpl == null) {
            throw new RegistryException("The policy group is null.", "error.occurred", MODULE, 0);
        }
        EntityId entityId = policyGroupIdImpl.getContainerId();
        ConfigNodeImpl configNodeImpl = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            for (configNodeImpl = entityId != null ? this.readComponent(string2, policyGroupIdImpl, clientContext) : this.readPolicyGroupComponent(string2, policyGroupIdImpl, clientContext); configNodeImpl != null && stringTokenizer.hasMoreTokens(); configNodeImpl = (ConfigNodeImpl)configNodeImpl.getChild(stringTokenizer.nextToken())) {
            }
        }
        return configNodeImpl;
    }

    static class MergedNodeCache
    extends ConfigCache {
        PolicyGroupIdImpl mPolicyGroupId = null;
        String mConfigLocale = null;

        MergedNodeCache() {
        }

        MergedNodeCache(int n) {
            super(n);
        }

        MergedNodeCache(PolicyGroupIdImpl policyGroupIdImpl, String string) {
            this.mPolicyGroupId = policyGroupIdImpl;
            this.mConfigLocale = string;
        }

        MergedNodeCache(PolicyGroupIdImpl policyGroupIdImpl, String string, int n) {
            super(n);
            this.mPolicyGroupId = policyGroupIdImpl;
            this.mConfigLocale = string;
        }

        PolicyGroupIdImpl getPolicyGroupId() {
            return this.mPolicyGroupId;
        }

        ConfigNodeImpl find(String string, PolicyGroupIdImpl policyGroupIdImpl, String string2) {
            if (policyGroupIdImpl == null || string2 == null) {
                return null;
            }
            if (this.mConfigLocale == null || this.mPolicyGroupId == null || !this.mConfigLocale.equals(string2) || !this.mPolicyGroupId.equals(policyGroupIdImpl)) {
                this.flush();
                this.mConfigLocale = string2;
                this.mPolicyGroupId = policyGroupIdImpl;
                return null;
            }
            return this.find(string);
        }

        boolean containsKey(String string, PolicyGroupIdImpl policyGroupIdImpl, String string2) {
            if (policyGroupIdImpl == null || string2 == null) {
                return false;
            }
            if (this.mConfigLocale == null || this.mPolicyGroupId == null || !this.mConfigLocale.equals(string2) || !this.mPolicyGroupId.equals(policyGroupIdImpl)) {
                this.flush();
                this.mConfigLocale = string2;
                this.mPolicyGroupId = policyGroupIdImpl;
                return false;
            }
            return this.containsKey(string);
        }

        void put(String string, ConfigNodeImpl configNodeImpl, PolicyGroupIdImpl policyGroupIdImpl, String string2) {
            if (policyGroupIdImpl == null || string2 == null) {
                return;
            }
            if (this.mConfigLocale == null || this.mPolicyGroupId == null || !this.mConfigLocale.equals(string2) || !this.mPolicyGroupId.equals(policyGroupIdImpl)) {
                this.flush();
                this.mConfigLocale = string2;
                this.mPolicyGroupId = policyGroupIdImpl;
            }
            this.put(string, configNodeImpl);
        }
    }

    private static abstract class ConfigCache {
        int mMaxEntries = 20;
        float mLoadFactor = 0.75f;
        Map mCacheMap = null;

        ConfigCache() {
            this.createCacheMap();
        }

        ConfigCache(int n) {
            this.mMaxEntries = n;
            this.createCacheMap();
        }

        void createCacheMap() {
            int n = this.mMaxEntries * 2;
            this.mCacheMap = new LinkedHashMap(this, n, this.mLoadFactor, true){
                private final /* synthetic */ ConfigCache this$0;
                {
                    this.this$0 = configCache;
                }

                protected boolean removeEldestEntry(Map.Entry entry) {
                    return this.size() > this.this$0.mMaxEntries;
                }
            };
        }

        void setMaxEntries(int n) {
            this.mMaxEntries = n;
            this.createCacheMap();
        }

        ConfigNodeImpl find(String string) {
            if (this.mCacheMap == null || string == null) {
                return null;
            }
            return (ConfigNodeImpl)this.mCacheMap.get(string);
        }

        boolean containsKey(String string) {
            if (this.mCacheMap == null || string == null) {
                return false;
            }
            return this.mCacheMap.containsKey(string);
        }

        void put(String string, ConfigNodeImpl configNodeImpl) {
            if (string == null) {
                return;
            }
            this.mCacheMap.put(string, configNodeImpl);
        }

        void remove(String string) {
            if (string == null) {
                return;
            }
            this.mCacheMap.remove(string);
        }

        void flush() {
            this.mCacheMap.clear();
        }
    }
}

