/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.policy.datastore;

import com.sun.apoc.policy.cfgtree.ConfigDataManager;
import com.sun.apoc.policy.common.EntityId;
import com.sun.apoc.policy.common.NodeKey;
import com.sun.apoc.policy.common.PolicyGroupIdImpl;
import com.sun.apoc.policy.common.PolicyGroupUse;
import com.sun.apoc.policy.common.PolicyId;
import com.sun.apoc.policy.common.PolicySetId;
import com.sun.apoc.policy.common.RegistryException;
import com.sun.apoc.policy.datastore.DataStoreType;
import com.sun.apoc.policy.datastore.ldap.LdapDataStore;
import com.sun.apoc.policy.pmgr.ClientContext;
import com.sun.apoc.policy.util.BootstrapData;
import java.util.Hashtable;
import java.util.Vector;

public abstract class DataStore {
    private static int mDataStoreType = -1;
    private ConfigDataManager mConfigDataManager;
    public static final int BUFFER_LENGTH = 200;
    public static final boolean RECURSIVE_SEARCH = true;
    public static final boolean NON_RECURSIVE_SEARCH = false;
    private static final String MODULE = "DataStore";

    public static DataStore getDataStore(BootstrapData bootstrapData, ClientContext clientContext) throws RegistryException {
        LdapDataStore ldapDataStore = null;
        mDataStoreType = DataStoreType.getInt(bootstrapData.getDataStoreType());
        switch (mDataStoreType) {
            case 0: {
                ldapDataStore = new LdapDataStore(bootstrapData, clientContext);
                break;
            }
            default: {
                throw new RegistryException("The datastore type specified in the bootstrapping information is not supported.", "error.unsupported.datastore", MODULE, 0);
            }
        }
        return ldapDataStore;
    }

    public void setConfigDataManager(ConfigDataManager configDataManager) {
        this.mConfigDataManager = configDataManager;
    }

    public ConfigDataManager getConfigDataManager() {
        return this.mConfigDataManager;
    }

    public abstract void writeComponent(NodeKey var1, String var2, ClientContext var3) throws RegistryException;

    public static int getDataStoreType() {
        return mDataStoreType;
    }

    public abstract String[] getComponentList(PolicySetId[] var1, ClientContext var2) throws RegistryException;

    public String[] listComponents(PolicySetId policySetId, ClientContext clientContext) throws RegistryException {
        PolicySetId[] policySetIdArray = new PolicySetId[]{policySetId};
        return this.getComponentList(policySetIdArray, clientContext);
    }

    public abstract PolicyId[] getPolicyIds(PolicySetId var1, String[] var2, boolean var3, ClientContext var4) throws RegistryException;

    public abstract String[] getPolicies(PolicySetId var1, String[] var2, ClientContext var3) throws RegistryException;

    public abstract PolicySetId getPolicyGroupId(String var1, ClientContext var2) throws RegistryException;

    public abstract PolicySetId getPolicyGroupId(EntityId var1, PolicyGroupUse var2, ClientContext var3) throws RegistryException;

    public abstract PolicySetId getPolicyGroupId(String var1, EntityId var2, PolicyGroupUse var3, int var4, ClientContext var5) throws RegistryException;

    public abstract void storePolicy(PolicySetId var1, String var2, String var3, ClientContext var4) throws RegistryException;

    public abstract boolean isEntityWritable(EntityId var1, ClientContext var2) throws RegistryException;

    public abstract PolicySetId[] getPolicyGroups(PolicyGroupUse var1, ClientContext var2) throws RegistryException;

    public PolicySetId createPolicyGroup(String string, PolicyGroupUse policyGroupUse, int n, ClientContext clientContext) throws RegistryException {
        return this.createPolicyGroup(null, string, policyGroupUse, n, clientContext);
    }

    public abstract PolicySetId createPolicyGroup(EntityId var1, String var2, PolicyGroupUse var3, int var4, ClientContext var5) throws RegistryException;

    public abstract void deletePolicyGroups(PolicySetId[] var1, ClientContext var2) throws RegistryException;

    public abstract void renamePolicyGroup(PolicyGroupIdImpl var1, String var2, ClientContext var3) throws RegistryException;

    public abstract PolicySetId[] getPolicyGroupsAssignedToEntity(EntityId var1, PolicyGroupUse var2, ClientContext var3) throws RegistryException;

    public abstract void assignPolicyGroupsToEntity(EntityId var1, PolicySetId[] var2, ClientContext var3) throws RegistryException;

    public abstract void unassignPolicyGroupsFromEntity(EntityId var1, PolicySetId[] var2, ClientContext var3) throws RegistryException;

    public abstract Vector getListOfEntitiesForPolicyGroup(PolicyGroupIdImpl var1, ClientContext var2) throws RegistryException;

    public abstract void setPolicyGroupPriorities(PolicySetId[] var1, boolean var2, ClientContext var3) throws RegistryException;

    public abstract Vector getPolicyGroupPriorities(EntityId var1, PolicyGroupUse var2, ClientContext var3) throws RegistryException;

    public abstract void checkForPriorityConflict(PolicySetId var1, ClientContext var2) throws RegistryException;

    public abstract PolicySetId findPolicyGroup(String var1, EntityId var2, PolicyGroupUse var3, ClientContext var4) throws RegistryException;

    public class ComponentNameParser {
        Hashtable componentNames = new Hashtable();
        StringBuffer compBuf = new StringBuffer(200);
        char ESCAPE_CHAR = (char)47;

        public String getStoredFormat(String string) {
            if (string == null) {
                return null;
            }
            String string2 = (String)this.componentNames.get(string);
            if (string2 != null) {
                return string2;
            }
            this.compBuf.delete(0, this.compBuf.length());
            String string3 = string.toLowerCase();
            char[] cArray = string.toCharArray();
            char[] cArray2 = string3.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == this.ESCAPE_CHAR || cArray[i] != cArray2[i]) {
                    this.compBuf.append(this.ESCAPE_CHAR);
                }
                this.compBuf.append(cArray[i]);
            }
            string2 = this.compBuf.toString();
            this.componentNames.put(string, string2);
            return string2;
        }

        public String getOutputFormat(String string) {
            if (string == null) {
                return null;
            }
            this.compBuf.delete(0, this.compBuf.length());
            char[] cArray = string.toCharArray();
            String string2 = string.toUpperCase();
            char[] cArray2 = string2.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == this.ESCAPE_CHAR) {
                    this.compBuf.append(cArray2[++i]);
                    continue;
                }
                this.compBuf.append(cArray[i]);
            }
            String string3 = this.compBuf.toString();
            this.componentNames.put(string3, string);
            return string3;
        }
    }
}

