/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.policy.pmgr;

import com.sun.apoc.policy.common.RegistryException;
import com.sun.apoc.policy.datastore.DataStore;
import com.sun.apoc.policy.organization.Organization;
import com.sun.apoc.policy.pmgr.ClientContext;
import com.sun.apoc.policy.pmgr.PolicyMgr;
import com.sun.apoc.policy.util.BootstrapData;
import com.sun.apoc.policy.util.MetaConfiguration;

public class PolicyMgrFactory {
    private Organization mOrganization;
    private DataStore mDataStore;
    private BootstrapData mBootstrapData;
    private static final String MODULE = "PolicyMgrFactory";

    public PolicyMgrFactory(MetaConfiguration metaConfiguration) throws RegistryException {
        if (metaConfiguration == null) {
            throw new RegistryException("The bootstrapping information is unavailable.", "error.bootstrap.unavailable", MODULE, 0);
        }
        this.mBootstrapData = new BootstrapData(metaConfiguration);
        ClientContext clientContext = ClientContext.getContext(this.mBootstrapData, null);
        if (clientContext == null) {
            throw new RegistryException("The application cannot be initialized.", "error.application.initialize", MODULE, 0);
        }
        try {
            this.mDataStore = DataStore.getDataStore(this.mBootstrapData, clientContext);
            this.mOrganization = Organization.getOrganization(this.mBootstrapData, this.mDataStore);
        }
        catch (RegistryException registryException) {
            clientContext.close();
            throw registryException;
        }
        catch (Exception exception) {
            clientContext.close();
            throw new RegistryException("The application cannot be initialized.", "error.application.initialize", MODULE, 0);
        }
        clientContext.close();
        if (this.mDataStore == null || this.mOrganization == null) {
            throw new RegistryException("The application cannot be initialized.", "error.application.initialize", MODULE, 0);
        }
    }

    public PolicyMgr createPolicyMgr(String string, String string2) throws RegistryException {
        return new PolicyMgr(this.mBootstrapData, this.mDataStore, this.mOrganization, string, string2);
    }
}

