/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.policy.util;

import com.sun.apoc.policy.common.PolicySetId;
import com.sun.apoc.policy.common.RegistryException;
import com.sun.apoc.policy.datastore.DataStore;
import com.sun.apoc.policy.pmgr.ClientContext;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public abstract class ImporterExporter {
    private static final String MODULE = "ImporterExporter";
    private DataStore mStorage = null;

    public ImporterExporter(DataStore dataStore) {
        this.mStorage = dataStore;
    }

    public void exportPolicyGroup(PolicySetId policySetId, OutputStream outputStream, ClientContext clientContext) throws RegistryException {
        if (policySetId == null || outputStream == null || clientContext == null) {
            throw new RegistryException("Invalid parameters for method that exports a policy group.", "error.occurred", MODULE, 0);
        }
        String[] stringArray = this.mStorage.listComponents(policySetId, clientContext);
        if (stringArray.length == 0) {
            throw new RegistryException("There is no policy group data available for export.", "error.export.policygroup_data", MODULE, 0);
        }
        String[] stringArray2 = this.mStorage.getPolicies(policySetId, stringArray, clientContext);
        this.writePolicies(stringArray, stringArray2, outputStream);
    }

    public void importPolicyGroup(PolicySetId policySetId, InputStream inputStream, ClientContext clientContext) throws RegistryException {
        int n;
        Vector vector;
        PolicySetId[] policySetIdArray;
        if (policySetId == null || inputStream == null || clientContext == null) {
            throw new RegistryException("Invalid parameters for method that imports a policy group.", "error.occurred", MODULE, 0);
        }
        PolicySetId policySetId2 = this.mStorage.findPolicyGroup(policySetId.getDisplayName(), policySetId.getContainerId(), policySetId.getPolicyGroupUse(), clientContext);
        if (policySetId2 != null) {
            policySetIdArray = new PolicySetId[]{policySetId2};
            this.mStorage.deletePolicyGroups(policySetIdArray, clientContext);
        }
        if ((policySetId2 == null || policySetId2.getPriority() != policySetId.getPriority()) && policySetId.getContainerId() == null) {
            if (policySetId.getPriority() <= 0) {
                int n2 = 1;
                vector = this.mStorage.getPolicyGroupPriorities(null, policySetId.getPolicyGroupUse(), clientContext);
                if (vector != null && !vector.isEmpty()) {
                    for (n = 0; n < vector.size(); ++n) {
                        Integer n3 = (Integer)vector.get(n);
                        if (n3 < n2) continue;
                        n2 = n3 + 1;
                    }
                }
                policySetId.setPriority(n2);
            } else {
                this.mStorage.checkForPriorityConflict(policySetId, clientContext);
            }
        }
        policySetIdArray = new Vector();
        vector = new Vector();
        this.readPolicies(inputStream, (Vector)policySetIdArray, vector);
        if (policySetIdArray.size() == 0) {
            throw new RegistryException("There is no policy group data available for import.", "error.import.policygroup_data", MODULE, 0);
        }
        for (n = 0; n < policySetIdArray.size(); ++n) {
            this.mStorage.storePolicy(policySetId, (String)policySetIdArray.get(n), (String)vector.get(n), clientContext);
        }
    }

    protected abstract void writePolicies(String[] var1, String[] var2, OutputStream var3) throws RegistryException;

    protected abstract void readPolicies(InputStream var1, Vector var2, Vector var3) throws RegistryException;
}

