/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.manager.entities;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.sun.apoc.manager.Toolbox2;
import com.sun.apoc.manager.contexts.ManagerTableModel;
import com.sun.apoc.spi.PolicyManager;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.Leaf;
import com.sun.apoc.spi.entities.Node;
import com.sun.apoc.spi.entities.Role;
import com.sun.apoc.spi.entities.User;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.model.CCNavNode;
import com.sun.web.ui.model.CCNavNodeInterface;
import com.sun.web.ui.model.CCTreeModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.TreeSet;

public class NavigationModel
extends CCTreeModel {
    public static final int NODE_ROOT = 0;
    public static final int NODE_ROOT_ORG = 1;
    public static final int NODE_ROOT_DOMAIN = 2;
    public static final int NODE_SUBTREE_ROOT = 3;
    public static final String DISPLAY_THRESHOLD_KEY = "DisplayThreshold";
    public static final String DISPLAY_GRACE_KEY = "DisplayGrace";
    public static final String DISPLAY_SHOW_ASSIGNED = "ShowAssignedProfiles";
    public static final String DISPLAY_SMART_TURNER = "SmartTurner";
    private PolicyManager m_policyManager;
    private boolean m_bFilterLeaves = false;
    private boolean m_bSparseBrowsing = true;
    private HashSet m_syncedNodesDirs = new HashSet();
    private HashSet m_syncedNodesLeaves = new HashSet();
    private int m_nIdCounter = 10;
    private int m_nDisplayThreshold = 10;
    private int m_nDisplayGrace = 15;
    private boolean m_bShowAssigned = false;
    private boolean m_bSmartTurner = false;
    private String m_SelectedEntityConstant = null;
    private Entity m_rootEntity = null;
    private LinkedList m_dirtyNodeIds = new LinkedList();

    public NavigationModel() throws ModelControlException {
        this.m_SelectedEntityConstant = "SelectedEntity";
        this.setUpVariables();
    }

    public NavigationModel(String string) throws ModelControlException {
        this.m_SelectedEntityConstant = string;
        this.setUpVariables();
    }

    private void setUpVariables() throws ModelControlException {
        this.initTree(null, null, null);
        PolicyManager policyManager = Toolbox2.getPolicyManager();
        if (policyManager != null) {
            try {
                String string = (String)policyManager.getEnvironment().get("PolicyManagerName");
                File file = new File(ManagerTableModel.CONFIG_FILE_LOCATION);
                if (file.exists()) {
                    FilenameFilter filenameFilter = new FilenameFilter(){

                        public boolean accept(File file, String string) {
                            return string.endsWith(".properties");
                        }
                    };
                    File[] fileArray = file.listFiles(filenameFilter);
                    for (int i = 0; i < fileArray.length; ++i) {
                        String string2;
                        File file2 = fileArray[i];
                        if (!file2.canRead()) continue;
                        FileInputStream fileInputStream = new FileInputStream(file2);
                        Properties properties = new Properties();
                        properties.load(fileInputStream);
                        fileInputStream.close();
                        if (properties.getProperty("Backend") == null || !(string2 = properties.getProperty("Backend")).equals(string)) continue;
                        try {
                            if (properties.containsKey(DISPLAY_THRESHOLD_KEY)) {
                                this.m_nDisplayThreshold = Integer.parseInt(properties.getProperty(DISPLAY_THRESHOLD_KEY));
                            }
                            if (properties.containsKey(DISPLAY_GRACE_KEY)) {
                                this.m_nDisplayGrace = Integer.parseInt(properties.getProperty(DISPLAY_GRACE_KEY));
                            }
                            if (properties.containsKey(DISPLAY_SHOW_ASSIGNED)) {
                                this.m_bShowAssigned = Boolean.valueOf(properties.getProperty(DISPLAY_SHOW_ASSIGNED));
                            }
                            if (!properties.containsKey(DISPLAY_SMART_TURNER)) continue;
                            this.m_bSmartTurner = Boolean.valueOf(properties.getProperty(DISPLAY_SMART_TURNER));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            CCDebug.trace3((String)numberFormatException.toString());
                        }
                    }
                }
            }
            catch (Exception exception) {
                throw new ModelControlException((Throwable)exception);
            }
        }
    }

    public void initTree(String string, String string2, String string3) throws ModelControlException {
        try {
            HashMap hashMap = (HashMap)RequestManager.getSession().getAttribute("SyncEnvironment");
            String string4 = hashMap == null ? null : (String)hashMap.get("LeftContextName");
            String string5 = hashMap == null ? null : (String)hashMap.get("RightContextName");
            PolicyManager policyManager = (PolicyManager)RequestManager.getRequest().getSession(false).getAttribute("TargetPolicyManager");
            String string6 = null;
            if (policyManager != null) {
                string6 = (String)policyManager.getEnvironment().get("PolicyManagerName");
            }
            this.m_policyManager = string != null && string.equals(string4) ? (PolicyManager)hashMap.get("LeftContext") : (string != null && string.equals(string5) ? (PolicyManager)hashMap.get("RightContext") : (string != null && string.equals(string6) ? policyManager : Toolbox2.getPolicyManager()));
            if (this.m_policyManager == null) {
                return;
            }
            this.m_syncedNodesDirs.clear();
            this.m_syncedNodesLeaves.clear();
            this.removeAllNodes();
            this.setType("1");
            CCNavNode cCNavNode = null;
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.m_policyManager.getSources()));
            boolean bl = false;
            if (string3 == null || string3.length() == 0) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string7 = arrayList.get(i);
                    String[] stringArray = this.getRootLabelAttributes(string7);
                    int n = this.getRootId(string7);
                    this.addNode(this.m_policyManager.getRootEntity(string7).getId(), n, stringArray[0], stringArray[1], stringArray[2], string7);
                    if (bl) continue;
                    this.setSelectedNode(n);
                    bl = true;
                    RequestManager.getSession().setAttribute(this.m_SelectedEntityConstant, (Object)this.m_policyManager.getRootEntity(string7));
                }
            } else {
                boolean bl2 = true;
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string8 = arrayList.get(i);
                    String[] stringArray = this.getRootLabelAttributes(string8);
                    int n = this.getRootId(string8);
                    if (!this.m_policyManager.getRootEntity(string8).getId().equals(string3)) continue;
                    bl2 = false;
                    this.m_rootEntity = this.m_policyManager.getRootEntity(string8);
                    this.addNode(string3, n, stringArray[0], stringArray[1], stringArray[2], string8);
                    this.setSelectedNode(n);
                    RequestManager.getSession().setAttribute(this.m_SelectedEntityConstant, (Object)this.m_policyManager.getRootEntity(string8));
                }
                if (bl2) {
                    cCNavNode = new CCNavNode(3);
                    cCNavNode.setLabel(this.m_policyManager.getEntity(string2, string3).getDisplayName(Toolbox2.getLocale()));
                    cCNavNode.setValue(this.m_policyManager.getEntity(string2, string3).getId());
                    cCNavNode.setValue("ENTITY", (Object)this.m_policyManager.getEntity(string2, string3));
                    cCNavNode.setValue(string3);
                    this.addNode((CCNavNodeInterface)cCNavNode);
                    this.setSelectedNode(3);
                    this.m_rootEntity = this.m_policyManager.getEntity(string2, string3);
                }
            }
        }
        catch (SPIException sPIException) {
            throw new ModelControlException((Throwable)sPIException);
        }
    }

    public boolean isRootEntity(String string) throws SPIException {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.m_policyManager.getSources()));
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i);
            if (!this.m_policyManager.getRootEntity(string2).getId().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void addNode(String string, int n, String string2, String string3, String string4, String string5) throws SPIException {
        CCNavNode cCNavNode = null;
        cCNavNode = new CCNavNode(n);
        cCNavNode.setLabel(Toolbox2.getI18n(string2));
        cCNavNode.setStatus(Toolbox2.getI18n(string3));
        cCNavNode.setTooltip(Toolbox2.getI18n(string4));
        cCNavNode.setValue("ENTITY", (Object)this.m_policyManager.getRootEntity(string5));
        cCNavNode.setValue(string);
        cCNavNode.setExpanded(true);
        this.addNode((CCNavNodeInterface)cCNavNode);
    }

    public void expandRoot() throws ModelControlException, SPIException {
        String[] stringArray = new String[]{"HOST", "USER"};
        if (this.m_policyManager != null) {
            stringArray = this.m_policyManager.getSources();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("USER")) {
                this.retrieve(1);
                continue;
            }
            if (!stringArray[i].equals("HOST")) continue;
            this.retrieve(2);
        }
    }

    public void setSparseBrowsing(boolean bl) {
        this.m_bSparseBrowsing = bl;
    }

    public void setAssignedState(Entity entity, boolean bl) {
        String string = entity.getPolicySourceName();
        CCNavNodeInterface cCNavNodeInterface = null;
        if (string.equals("USER")) {
            cCNavNodeInterface = this.getNodeById(1);
        } else if (string.equals("HOST")) {
            cCNavNodeInterface = this.getNodeById(2);
        }
        CCNavNodeInterface cCNavNodeInterface2 = this.findChildByValue(cCNavNodeInterface, entity.getId(), true);
        if (cCNavNodeInterface2 != null && (Boolean)cCNavNodeInterface2.getValue("ASSIGNED") != bl) {
            this.setTypeSpecifics(cCNavNodeInterface2, entity, bl && this.m_bShowAssigned);
            if (cCNavNodeInterface2.getVisible()) {
                this.m_dirtyNodeIds.add(new Integer(cCNavNodeInterface2.getId()));
            }
        }
    }

    public boolean getAssignedState(int n) {
        return this.m_bShowAssigned ? (Boolean)this.getNodeById(n).getValue("ASSIGNED") : false;
    }

    public Iterator getDirtyNodeIds() {
        return this.m_dirtyNodeIds.iterator();
    }

    public void clearDirtyNodeIds() {
        this.m_dirtyNodeIds.clear();
    }

    public boolean isLeavesFiltered() {
        return this.m_bFilterLeaves;
    }

    public void filterLeaves(boolean bl) {
        this.m_bFilterLeaves = bl;
    }

    public String getViewedNode() {
        return this.getSelectedNode().getValue();
    }

    public Object getStoredValue(int n) {
        return this.getNodeById(n).getValue("ENTITY");
    }

    public String getStoredEntityId(int n) {
        Entity entity = (Entity)this.getNodeById(n).getValue("ENTITY");
        return entity.getId();
    }

    public String getStoredEntityType(int n) {
        Entity entity = (Entity)this.getNodeById(n).getValue("ENTITY");
        return entity.getPolicySourceName();
    }

    public String getNodeType(CCNavNodeInterface cCNavNodeInterface) {
        String string = "";
        Entity entity = (Entity)cCNavNodeInterface.getValue("ENTITY");
        if (entity != null) {
            string = entity.getPolicySourceName();
        }
        return string;
    }

    public Entity getRootEntity() {
        return this.m_rootEntity;
    }

    public void setTypeSpecifics(CCNavNodeInterface cCNavNodeInterface, Entity entity, boolean bl) {
        if (cCNavNodeInterface.getVisible()) {
            String string = "";
            String string2 = "";
            String string3 = entity.getPolicySourceName();
            if (entity instanceof Role) {
                if (bl) {
                    string = "../images/roleAssigned.png";
                    string2 = Toolbox2.getI18n("APOC.navigation.role.with");
                } else {
                    string = "../images/role.png";
                    string2 = Toolbox2.getI18n("APOC.navigation.role");
                }
            } else if (string3.equals("USER")) {
                if (entity instanceof Node) {
                    if (bl) {
                        string = "../images/orgAssigned.png";
                        string2 = Toolbox2.getI18n("APOC.navigation.organization.with");
                    } else {
                        string = "../images/org.png";
                        string2 = Toolbox2.getI18n("APOC.navigation.organization");
                    }
                } else if (entity instanceof Leaf) {
                    if (bl) {
                        string = "../images/userAssigned.png";
                        string2 = Toolbox2.getI18n("APOC.navigation.user.with");
                    } else {
                        string = "../images/user.png";
                        string2 = Toolbox2.getI18n("APOC.navigation.user");
                    }
                }
            } else if (string3.equals("HOST")) {
                if (entity instanceof Node) {
                    if (bl) {
                        string = "../images/domainAssigned.png";
                        string2 = Toolbox2.getI18n("APOC.navigation.domain.with");
                    } else {
                        string = "../images/domain.png";
                        string2 = Toolbox2.getI18n("APOC.navigation.domain");
                    }
                } else if (entity instanceof Leaf) {
                    if (bl) {
                        string = "../images/hostAssigned.png";
                        string2 = Toolbox2.getI18n("APOC.navigation.host.with");
                    } else {
                        string = "../images/host.png";
                        string2 = Toolbox2.getI18n("APOC.navigation.host");
                    }
                }
            }
            cCNavNodeInterface.setValue("ASSIGNED", (Object)new Boolean(bl));
            cCNavNodeInterface.setImage(string);
            cCNavNodeInterface.setTooltip(string2);
        }
    }

    public int retrieve(boolean bl) throws ModelControlException {
        try {
            if (bl != this.m_bFilterLeaves) {
                this.m_bFilterLeaves = bl;
                Iterator iterator = this.getNodes().iterator();
                while (iterator.hasNext()) {
                    CCNavNodeInterface cCNavNodeInterface = (CCNavNodeInterface)iterator.next();
                    if (!this.m_bFilterLeaves) {
                        this.addLeaves(cCNavNodeInterface);
                        continue;
                    }
                    this.removeLeaves(cCNavNodeInterface);
                }
            }
        }
        catch (SPIException sPIException) {
            throw new ModelControlException((Throwable)sPIException);
        }
        return this.getSelectedNode().getId();
    }

    public int retrieve(String string) throws ModelControlException {
        String string2 = "USER";
        if (string.indexOf("|") != -1) {
            string2 = string.substring(string.indexOf("|") + 1);
            string = string.substring(0, string.indexOf("|"));
        }
        CCNavNodeInterface cCNavNodeInterface = null;
        if (string2.equals("USER")) {
            cCNavNodeInterface = this.getNodeById(1);
        } else if (string2.equals("HOST")) {
            cCNavNodeInterface = this.getNodeById(2);
        }
        if (cCNavNodeInterface == null) {
            cCNavNodeInterface = this.getNodeById(3);
        }
        CCNavNodeInterface cCNavNodeInterface2 = null;
        try {
            ListIterator listIterator = Toolbox2.getParentPath(string2, string);
            Entity entity = null;
            if (listIterator.hasNext()) {
                entity = (Entity)listIterator.next();
            }
            while (listIterator.hasNext()) {
                entity = (Entity)listIterator.next();
                if (cCNavNodeInterface.getNumChildren() == 0) {
                    this.retrieve(cCNavNodeInterface.getId());
                }
                if ((cCNavNodeInterface2 = this.findChildByValue(cCNavNodeInterface, entity.getId(), false)) == null) {
                    cCNavNodeInterface = this.addChild(cCNavNodeInterface, entity);
                    continue;
                }
                cCNavNodeInterface = cCNavNodeInterface2;
            }
            if (cCNavNodeInterface.getNumChildren() == 0) {
                this.retrieve(cCNavNodeInterface.getId());
            }
            cCNavNodeInterface = (cCNavNodeInterface2 = this.findChildByValue(cCNavNodeInterface, string, false)) == null ? this.addChild(cCNavNodeInterface, this.m_policyManager.getEntity(string2, string)) : cCNavNodeInterface2;
        }
        catch (SPIException sPIException) {
            throw new ModelControlException((Throwable)sPIException);
        }
        return cCNavNodeInterface.getId();
    }

    public void retrieve(int n) throws ModelControlException {
        CCNavNodeInterface cCNavNodeInterface = this.getNodeById(n);
        if (cCNavNodeInterface == null) {
            return;
        }
        if (this.m_bFilterLeaves && this.m_syncedNodesDirs.contains(cCNavNodeInterface)) {
            return;
        }
        if (!this.m_bFilterLeaves && this.m_syncedNodesDirs.contains(cCNavNodeInterface) && this.m_syncedNodesLeaves.contains(cCNavNodeInterface)) {
            return;
        }
        try {
            Entity entity = null;
            entity = n == 1 ? this.m_policyManager.getRootEntity("USER") : (n == 2 ? this.m_policyManager.getRootEntity("HOST") : (Entity)cCNavNodeInterface.getValue("ENTITY"));
            if (entity instanceof Leaf) {
                return;
            }
            if (entity instanceof Node && !((Node)entity).hasChildren()) {
                return;
            }
            this.addChildren(cCNavNodeInterface, ((Node)entity).getChildren());
        }
        catch (SPIException sPIException) {
            throw new ModelControlException((Throwable)sPIException);
        }
        this.m_syncedNodesDirs.add(cCNavNodeInterface);
        if (!this.m_bFilterLeaves) {
            this.m_syncedNodesLeaves.add(cCNavNodeInterface);
        }
    }

    private void addLeaves(CCNavNodeInterface cCNavNodeInterface) throws SPIException {
        Iterator iterator = cCNavNodeInterface.getChildren().iterator();
        while (iterator.hasNext()) {
            this.addLeaves((CCNavNodeInterface)iterator.next());
        }
        if (!this.m_syncedNodesLeaves.contains(cCNavNodeInterface)) {
            Entity entity = (Entity)cCNavNodeInterface.getValue("ENTITY");
            this.addChildren(cCNavNodeInterface, ((Node)entity).getChildren());
            this.m_syncedNodesLeaves.add(cCNavNodeInterface);
        }
    }

    private void addChildren(CCNavNodeInterface cCNavNodeInterface, Iterator iterator) throws SPIException {
        CCNavNodeInterface cCNavNodeInterface2;
        TreeSet treeSet = new TreeSet(new EntityComparator());
        while (iterator.hasNext()) {
            treeSet.add(iterator.next());
        }
        boolean bl = false;
        int n = 0;
        LinkedList<Entity> linkedList = new LinkedList<Entity>();
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            if ((this.m_bFilterLeaves || this.m_syncedNodesLeaves.contains(cCNavNodeInterface)) && !(entity instanceof Node) || this.findChildByValue(cCNavNodeInterface, entity.getId(), false) != null) continue;
            linkedList.add(entity);
            if (!this.m_bSparseBrowsing || ++n + cCNavNodeInterface.getNumChildren() <= this.m_nDisplayGrace) continue;
            bl = true;
            n = this.m_nDisplayThreshold - cCNavNodeInterface.getNumChildren();
            break;
        }
        if (n > 0) {
            cCNavNodeInterface.setAcceptsChildren(true);
        }
        for (int i = 0; i < n; ++i) {
            cCNavNodeInterface2 = this.createChild((Entity)linkedList.get(i));
            cCNavNodeInterface2.setParent(cCNavNodeInterface);
        }
        if (bl) {
            String string = Toolbox2.getI18n("APOC.navigation.ellipsis");
            cCNavNodeInterface2 = new CCNavNode(this.m_nIdCounter++);
            cCNavNodeInterface2.setLabel(string);
            cCNavNodeInterface2.setStatus(string);
            cCNavNodeInterface2.setAcceptsChildren(false);
            cCNavNodeInterface2.setValue("ellipsis");
            cCNavNodeInterface2.setValue("ASSIGNED", (Object)new Boolean(false));
            cCNavNodeInterface2.setImage("../images/search.gif");
            cCNavNodeInterface2.setTooltip(Toolbox2.getI18n("APOC.navigation.openfind"));
            cCNavNodeInterface2.setParent(cCNavNodeInterface);
            cCNavNodeInterface2.setOnClick("var newWindow = window.open('/apoc/manager/EntitiesFindIndex?EntitiesFindIndex.FindHref=" + cCNavNodeInterface2.getId() + "&EntitiesFindIndex.FindModel=" + this.getName() + "', 'findWindow', 'height=800,width=500,top='+((screen.height-800)/2)+',left='+((screen.width-500)/2)+',scrollbars,resizable'); newWindow.focus(); return false;");
            this.m_syncedNodesLeaves.add(cCNavNodeInterface2);
        }
    }

    private CCNavNodeInterface addChild(CCNavNodeInterface cCNavNodeInterface, Entity entity) throws SPIException {
        CCNavNodeInterface cCNavNodeInterface2 = this.createChild(entity);
        List list = cCNavNodeInterface.getChildren();
        LinkedList linkedList = new LinkedList(list);
        Iterator iterator = linkedList.iterator();
        EntityComparator entityComparator = new EntityComparator();
        CCNavNodeInterface cCNavNodeInterface3 = null;
        Entity entity2 = null;
        cCNavNodeInterface.setAcceptsChildren(true);
        while (iterator.hasNext()) {
            cCNavNodeInterface3 = (CCNavNodeInterface)iterator.next();
            entity2 = (Entity)cCNavNodeInterface3.getValue("ENTITY");
            if (cCNavNodeInterface2.getParent() == null && (entity2 == null || entityComparator.compare(entity, entity2) < 0)) {
                cCNavNodeInterface2.setParent(cCNavNodeInterface);
            }
            cCNavNodeInterface3.setParent(cCNavNodeInterface);
        }
        return cCNavNodeInterface2;
    }

    private CCNavNodeInterface createChild(Entity entity) throws SPIException {
        Object object;
        Iterator iterator;
        boolean bl;
        String string = entity.getDisplayName(Toolbox2.getLocale());
        CCNavNode cCNavNode = new CCNavNode(this.m_nIdCounter++);
        boolean bl2 = bl = !this.m_bSmartTurner;
        if (entity instanceof Leaf) {
            bl = false;
        } else if (this.m_bSmartTurner && (iterator = ((Node)entity).getChildren()).hasNext()) {
            if (this.m_bFilterLeaves) {
                while (iterator.hasNext()) {
                    object = (Entity)iterator.next();
                    if (!(object instanceof Node)) continue;
                    bl = true;
                    break;
                }
            } else {
                bl = true;
            }
        }
        if (entity instanceof User) {
            string = string + " [" + ((User)entity).getUserId() + "]";
        }
        cCNavNode.setLabel(string);
        cCNavNode.setStatus(string);
        cCNavNode.setAcceptsChildren(bl);
        cCNavNode.setValue("ENTITY", (Object)entity);
        cCNavNode.setValue(entity.getId());
        boolean bl3 = false;
        if (this.m_bShowAssigned) {
            object = entity.getAssignedProfiles();
            bl3 = object.hasNext();
        }
        this.setTypeSpecifics((CCNavNodeInterface)cCNavNode, entity, bl3);
        return cCNavNode;
    }

    private void removeLeaves(CCNavNodeInterface cCNavNodeInterface) throws SPIException {
        Iterator iterator = cCNavNodeInterface.getChildren().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            CCNavNodeInterface cCNavNodeInterface2 = (CCNavNodeInterface)iterator.next();
            Entity entity = (Entity)cCNavNodeInterface2.getValue("ENTITY");
            if (entity instanceof Node) {
                this.removeLeaves(cCNavNodeInterface2);
                continue;
            }
            if (cCNavNodeInterface2.equals(this.getSelectedNode())) {
                this.setSelectedNode(cCNavNodeInterface);
                RequestManager.getSession().setAttribute(this.m_SelectedEntityConstant, (Object)entity);
            }
            iterator.remove();
            bl = true;
            if (cCNavNodeInterface.getNumChildren() != 0) continue;
            cCNavNodeInterface.setAcceptsChildren(false);
        }
        if (bl) {
            this.m_syncedNodesLeaves.remove(cCNavNodeInterface);
        }
    }

    private CCNavNodeInterface findChildByValue(CCNavNodeInterface cCNavNodeInterface, String string, boolean bl) {
        if (cCNavNodeInterface.getChildren() != null) {
            Iterator iterator = cCNavNodeInterface.getChildren().iterator();
            while (iterator.hasNext()) {
                CCNavNodeInterface cCNavNodeInterface2 = (CCNavNodeInterface)iterator.next();
                if (cCNavNodeInterface2.getValue().equals(string)) {
                    return cCNavNodeInterface2;
                }
                if (!bl || (cCNavNodeInterface2 = this.findChildByValue(cCNavNodeInterface2, string, bl)) == null) continue;
                return cCNavNodeInterface2;
            }
        }
        return null;
    }

    private int getPriority(Object object) {
        if (object instanceof Entity) {
            String string = ((Entity)object).getPolicySourceName();
            if (string.equals("HOST")) {
                // empty if block
            }
            if (object instanceof Node) {
                if (string.equals("HOST")) {
                    return 1;
                }
                if (string.equals("USER")) {
                    return 2;
                }
            }
            if (object instanceof Role) {
                return 3;
            }
            if (string.equals("HOST")) {
                return 4;
            }
            if (string.equals("USER")) {
                return 5;
            }
        }
        return 99;
    }

    private String[] getRootLabelAttributes(String string) {
        if (string.equals("HOST")) {
            String[] stringArray = new String[]{"APOC.navigation.domains", "APOC.navigation.domains.help", "APOC.navigation.domains.help"};
            return stringArray;
        }
        if (string.equals("USER")) {
            String[] stringArray = new String[]{"APOC.navigation.organizations", "APOC.navigation.organizations.help", "APOC.navigation.organizations.help"};
            return stringArray;
        }
        return null;
    }

    private int getRootId(String string) {
        if (string.equals("HOST")) {
            return 2;
        }
        return 1;
    }

    class EntityComparator
    implements Comparator {
        EntityComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2 = -1;
            int n3 = NavigationModel.this.getPriority(object);
            n2 = n3 < (n = NavigationModel.this.getPriority(object2)) ? -1 : (n3 == n ? ((Entity)object).getDisplayName(Toolbox2.getLocale()).compareTo(((Entity)object2).getDisplayName(Toolbox2.getLocale())) : 1);
            return n2;
        }
    }
}

