/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMessage;
import netscape.ldap.ber.stream.BERBoolean;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.JDAPBERTagDecoder;
import netscape.ldap.util.LDIF;

public class LDAPControl
implements Cloneable,
Serializable {
    static final long serialVersionUID = 5149887553272603753L;
    public static final String MANAGEDSAIT = "2.16.840.1.113730.3.4.2";
    public static final String PWEXPIRED = "2.16.840.1.113730.3.4.4";
    public static final String PWEXPIRING = "2.16.840.1.113730.3.4.5";
    private String m_oid;
    protected boolean m_critical = false;
    protected byte[] m_value = null;
    private static Hashtable m_controlClassHash = null;
    static /* synthetic */ Class class$netscape$ldap$controls$LDAPPasswordExpiringControl;
    static /* synthetic */ Class class$netscape$ldap$controls$LDAPPasswordExpiredControl;
    static /* synthetic */ Class class$netscape$ldap$controls$LDAPEntryChangeControl;
    static /* synthetic */ Class class$netscape$ldap$controls$LDAPSortControl;
    static /* synthetic */ Class class$netscape$ldap$controls$LDAPVirtualListResponse;
    static /* synthetic */ Class class$netscape$ldap$LDAPControl;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;

    static {
        try {
            LDAPControl.register(PWEXPIRING, class$netscape$ldap$controls$LDAPPasswordExpiringControl != null ? class$netscape$ldap$controls$LDAPPasswordExpiringControl : (class$netscape$ldap$controls$LDAPPasswordExpiringControl = LDAPControl.class$("netscape.ldap.controls.LDAPPasswordExpiringControl")));
            LDAPControl.register(PWEXPIRED, class$netscape$ldap$controls$LDAPPasswordExpiredControl != null ? class$netscape$ldap$controls$LDAPPasswordExpiredControl : (class$netscape$ldap$controls$LDAPPasswordExpiredControl = LDAPControl.class$("netscape.ldap.controls.LDAPPasswordExpiredControl")));
            LDAPControl.register("2.16.840.1.113730.3.4.7", class$netscape$ldap$controls$LDAPEntryChangeControl != null ? class$netscape$ldap$controls$LDAPEntryChangeControl : (class$netscape$ldap$controls$LDAPEntryChangeControl = LDAPControl.class$("netscape.ldap.controls.LDAPEntryChangeControl")));
            LDAPControl.register("1.2.840.113556.1.4.474", class$netscape$ldap$controls$LDAPSortControl != null ? class$netscape$ldap$controls$LDAPSortControl : (class$netscape$ldap$controls$LDAPSortControl = LDAPControl.class$("netscape.ldap.controls.LDAPSortControl")));
            LDAPControl.register("2.16.840.1.113730.3.4.10", class$netscape$ldap$controls$LDAPVirtualListResponse != null ? class$netscape$ldap$controls$LDAPVirtualListResponse : (class$netscape$ldap$controls$LDAPVirtualListResponse = LDAPControl.class$("netscape.ldap.controls.LDAPVirtualListResponse")));
        }
        catch (LDAPException lDAPException) {}
    }

    public LDAPControl() {
    }

    public LDAPControl(String id, boolean critical, byte[] vals) {
        this.m_oid = id;
        this.m_critical = critical;
        this.m_value = vals;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Object clone() {
        byte[] vals = null;
        if (this.m_value != null) {
            vals = new byte[this.m_value.length];
            int i = 0;
            while (i < this.m_value.length) {
                vals[i] = this.m_value[i];
                ++i;
            }
        }
        LDAPControl control = new LDAPControl(this.m_oid, this.m_critical, vals);
        return control;
    }

    protected static LDAPControl createControl(String oid, boolean critical, byte[] value) {
        Class controlClass = LDAPControl.lookupControlClass(oid);
        if (controlClass == null) {
            return new LDAPControl(oid, critical, value);
        }
        Class[] cparams = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = LDAPControl.class$("java.lang.String")), Boolean.TYPE, array$B != null ? array$B : (array$B = LDAPControl.class$("[B"))};
        Constructor creator = null;
        try {
            creator = controlClass.getConstructor(cparams);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("Caught java.lang.NoSuchMethodException while attempting to instantiate a control of type " + oid);
            return new LDAPControl(oid, critical, value);
        }
        Object[] oparams = new Object[]{oid, new Boolean(critical), value};
        LDAPControl returnControl = null;
        try {
            returnControl = (LDAPControl)creator.newInstance(oparams);
        }
        catch (Exception e) {
            String eString = null;
            eString = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException().toString() : e.toString();
            System.err.println("Caught " + eString + " while attempting to" + " instantiate a control of type " + oid);
            returnControl = new LDAPControl(oid, critical, value);
        }
        return returnControl;
    }

    protected byte[] flattenBER(BERSequence ber) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            ber.write(outStream);
        }
        catch (IOException iOException) {
            return null;
        }
        return outStream.toByteArray();
    }

    BERElement getBERElement() {
        BERSequence seq = new BERSequence();
        seq.addElement(new BEROctetString(this.m_oid));
        seq.addElement(new BERBoolean(this.m_critical));
        if (this.m_value == null || this.m_value.length < 1) {
            seq.addElement(new BEROctetString(null));
        } else {
            seq.addElement(new BEROctetString(this.m_value, 0, this.m_value.length));
        }
        return seq;
    }

    public String getID() {
        return this.m_oid;
    }

    public byte[] getValue() {
        return this.m_value;
    }

    public boolean isCritical() {
        return this.m_critical;
    }

    protected static Class lookupControlClass(String oid) {
        if (m_controlClassHash == null) {
            return null;
        }
        return (Class)m_controlClassHash.get(oid);
    }

    /*
     * Unable to fully structure code
     */
    public static LDAPControl[] newInstance(byte[] data) throws IOException {
        block3: {
            bread = new int[1];
            el = BERElement.getElement(new JDAPBERTagDecoder(), new ByteArrayInputStream(data), bread);
            jc = null;
            try {
                msg = LDAPMessage.parseMessage(el);
                return msg.getControls();
            }
            catch (IOException v0) {
                tag = (BERTag)el;
                if (tag.getTag() != 160) break block3;
                controls = (BERSequence)tag.getValue();
                jc = new LDAPControl[controls.size()];
                i = 0;
                ** while (i < controls.size())
            }
lbl-1000:
            // 1 sources

            {
                jc[i] = LDAPControl.parseControl(controls.elementAt(i));
                ++i;
                continue;
            }
        }
        return jc;
    }

    static LDAPControl parseControl(BERElement el) {
        BERSequence s = (BERSequence)el;
        String oid = null;
        boolean critical = false;
        byte[] value = null;
        try {
            oid = new String(((BEROctetString)s.elementAt(0)).getValue(), "UTF8");
        }
        catch (Throwable throwable) {}
        BERElement obj = s.elementAt(1);
        if (obj instanceof BERBoolean) {
            critical = ((BERBoolean)obj).getValue();
        } else {
            value = ((BEROctetString)obj).getValue();
        }
        if (s.size() >= 3) {
            value = ((BEROctetString)s.elementAt(2)).getValue();
        }
        return LDAPControl.createControl(oid, critical, value);
    }

    public static void register(String oid, Class controlClass) throws LDAPException {
        if (controlClass == null) {
            return;
        }
        Class superClass = controlClass;
        while (superClass != (class$netscape$ldap$LDAPControl != null ? class$netscape$ldap$LDAPControl : LDAPControl.class$("netscape.ldap.LDAPControl")) && superClass != null) {
            superClass = superClass.getSuperclass();
        }
        if (superClass == null) {
            throw new LDAPException("controlClass must be a subclass of LDAPControl", 89);
        }
        Class[] cparams = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = LDAPControl.class$("java.lang.String")), Boolean.TYPE, array$B != null ? array$B : (array$B = LDAPControl.class$("[B"))};
        try {
            controlClass.getConstructor(cparams);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new LDAPException("controlClass does not implement the correct contstructor", 89);
        }
        if (m_controlClassHash == null) {
            m_controlClassHash = new Hashtable();
        }
        m_controlClassHash.put(oid, controlClass);
    }

    public String toString() {
        String s = String.valueOf(this.getID()) + ' ' + this.isCritical();
        if (this.m_value != null) {
            s = String.valueOf(s) + ' ' + LDIF.toPrintableString(this.m_value);
        }
        return "LDAPControl {" + s + '}';
    }
}

