/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.util.Vector;
import netscape.ldap.LDAPConnThread;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPInterruptedException;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPResponse;

class LDAPMessageQueue
implements Serializable {
    static final long serialVersionUID = -7163312406176592277L;
    private Vector m_messageQueue = new Vector(1);
    private Vector m_requestList = new Vector(1);
    private LDAPException m_exception;
    private boolean m_asynchOp;
    private boolean m_timeConstrained;

    LDAPMessageQueue(boolean asynchOp) {
        this.m_asynchOp = asynchOp;
    }

    synchronized void addMessage(LDAPMessage msg) {
        this.m_messageQueue.addElement(msg);
        if (this.isAsynchOp() && msg.getType() == 1 && ((LDAPResponse)msg).getResultCode() == 0) {
            this.getConnection(msg.getMessageID()).markConnAsBound();
        }
        this.notifyAll();
    }

    synchronized void addRequest(int id, LDAPConnection connection, LDAPConnThread connThread, int timeLimit) {
        this.m_requestList.addElement(new RequestEntry(id, connection, connThread, timeLimit));
        if (timeLimit != 0) {
            this.m_timeConstrained = true;
        }
        this.notifyAll();
    }

    synchronized LDAPResponse completeRequest() throws LDAPException {
        while (true) {
            if (this.m_requestList.size() != 0 && this.m_exception == null && this.m_messageQueue.size() == 0) {
                this.waitForMessage();
                continue;
            }
            if (this.m_exception != null) {
                LDAPException ex = this.m_exception;
                this.m_exception = null;
                throw ex;
            }
            if (this.m_requestList.size() == 0) {
                return null;
            }
            int i = this.m_messageQueue.size() - 1;
            while (i >= 0) {
                LDAPMessage msg = (LDAPMessage)this.m_messageQueue.elementAt(i);
                if (msg instanceof LDAPResponse) {
                    this.m_messageQueue.removeElementAt(i);
                    return (LDAPResponse)msg;
                }
                --i;
            }
            this.waitForMessage();
        }
    }

    synchronized Vector getAllMessages() {
        Vector result = this.m_messageQueue;
        this.m_messageQueue = new Vector(1);
        return result;
    }

    synchronized LDAPConnThread getConnThread(int id) {
        int i = 0;
        while (i < this.m_requestList.size()) {
            RequestEntry entry = (RequestEntry)this.m_requestList.elementAt(i);
            if (id == entry.id) {
                return entry.connThread;
            }
            ++i;
        }
        return null;
    }

    synchronized LDAPConnection getConnection(int id) {
        int i = 0;
        while (i < this.m_requestList.size()) {
            RequestEntry entry = (RequestEntry)this.m_requestList.elementAt(i);
            if (id == entry.id) {
                return entry.connection;
            }
            ++i;
        }
        return null;
    }

    public int getMessageCount() {
        return this.m_messageQueue.size();
    }

    synchronized int getMessageID() {
        int reqCnt = this.m_requestList.size();
        if (reqCnt == 0) {
            return -1;
        }
        RequestEntry entry = (RequestEntry)this.m_requestList.elementAt(reqCnt - 1);
        return entry.id;
    }

    synchronized int[] getMessageIDs() {
        int[] ids = new int[this.m_requestList.size()];
        int i = 0;
        while (i < ids.length) {
            RequestEntry entry = (RequestEntry)this.m_requestList.elementAt(i);
            ids[i] = entry.id;
            ++i;
        }
        return ids;
    }

    public int getRequestCount() {
        return this.m_requestList.size();
    }

    boolean isAsynchOp() {
        return this.m_asynchOp;
    }

    boolean isMessageReceived() {
        return this.m_messageQueue.size() != 0;
    }

    void merge(LDAPMessageQueue mq2) {
        Thread.yield();
        LDAPMessageQueue lDAPMessageQueue = this;
        synchronized (lDAPMessageQueue) {
            LDAPMessageQueue lDAPMessageQueue2 = mq2;
            synchronized (lDAPMessageQueue2) {
                int i = 0;
                while (i < mq2.m_messageQueue.size()) {
                    this.m_messageQueue.addElement(mq2.m_messageQueue.elementAt(i));
                    ++i;
                }
                if (mq2.m_exception != null) {
                    this.m_exception = mq2.m_exception;
                }
                int i2 = 0;
                while (i2 < mq2.m_requestList.size()) {
                    RequestEntry entry = (RequestEntry)mq2.m_requestList.elementAt(i2);
                    this.m_requestList.addElement(entry);
                    entry.connThread.changeListener(entry.id, this);
                    ++i2;
                }
                mq2.reset();
                this.notifyAll();
            }
            this.notifyAll();
        }
    }

    synchronized LDAPMessage nextMessage() throws LDAPException {
        while (this.m_requestList.size() != 0 && this.m_exception == null && this.m_messageQueue.size() == 0) {
            this.waitForMessage();
        }
        if (this.m_exception != null) {
            LDAPException ex = this.m_exception;
            this.m_exception = null;
            throw ex;
        }
        if (this.m_requestList.size() == 0) {
            return null;
        }
        LDAPMessage msg = (LDAPMessage)this.m_messageQueue.elementAt(0);
        this.m_messageQueue.removeElementAt(0);
        if (msg instanceof LDAPResponse) {
            this.removeRequest(msg.getMessageID());
        }
        return msg;
    }

    private int removeAllMessages(int id) {
        int removeCount = 0;
        int i = this.m_messageQueue.size() - 1;
        while (i >= 0) {
            LDAPMessage msg = (LDAPMessage)this.m_messageQueue.elementAt(i);
            if (msg.getMessageID() == id) {
                this.m_messageQueue.removeElementAt(i);
                ++removeCount;
            }
            --i;
        }
        return removeCount;
    }

    synchronized int removeAllRequests(LDAPConnThread connThread) {
        int removeCount = 0;
        int i = this.m_requestList.size() - 1;
        while (i >= 0) {
            RequestEntry entry = (RequestEntry)this.m_requestList.elementAt(i);
            if (connThread == entry.connThread) {
                this.m_requestList.removeElementAt(i);
                ++removeCount;
                this.removeAllMessages(entry.id);
            }
            --i;
        }
        this.notifyAll();
        return removeCount;
    }

    synchronized boolean removeRequest(int id) {
        int i = 0;
        while (i < this.m_requestList.size()) {
            RequestEntry entry = (RequestEntry)this.m_requestList.elementAt(i);
            if (id == entry.id) {
                this.m_requestList.removeElementAt(i);
                this.removeAllMessages(id);
                this.notifyAll();
                return true;
            }
            ++i;
        }
        return false;
    }

    void reset() {
        this.m_exception = null;
        this.m_messageQueue.removeAllElements();
        this.m_requestList.removeAllElements();
        this.m_timeConstrained = false;
    }

    synchronized void setException(LDAPConnThread connThread, LDAPException e) {
        this.m_exception = e;
        this.removeAllRequests(connThread);
        this.notifyAll();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("LDAPMessageQueue:");
        sb.append(" requestIDs={");
        int i = 0;
        while (i < this.m_requestList.size()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(((RequestEntry)this.m_requestList.elementAt((int)i)).id);
            ++i;
        }
        sb.append("} messageCount=" + this.m_messageQueue.size());
        return sb.toString();
    }

    private synchronized void waitForMessage() throws LDAPException {
        if (!this.m_timeConstrained) {
            try {
                this.wait();
                return;
            }
            catch (InterruptedException interruptedException) {
                throw new LDAPInterruptedException("Interrupted LDAP operation");
            }
        }
        long minTimeToComplete = Long.MAX_VALUE;
        long now = System.currentTimeMillis();
        int i = 0;
        while (i < this.m_requestList.size()) {
            RequestEntry entry = (RequestEntry)this.m_requestList.elementAt(i);
            if (entry.timeToComplete <= now) {
                entry.connection.abandon(entry.id);
                throw new LDAPException("Time to complete operation exceeded", 85);
            }
            if (entry.timeToComplete < minTimeToComplete) {
                minTimeToComplete = entry.timeToComplete;
            }
            ++i;
        }
        long timeLimit = minTimeToComplete == Long.MAX_VALUE ? 0L : minTimeToComplete - now;
        try {
            this.m_timeConstrained = timeLimit != 0L;
            this.wait(timeLimit);
        }
        catch (InterruptedException interruptedException) {
            throw new LDAPInterruptedException("Interrupted LDAP operation");
        }
    }

    private static class RequestEntry {
        int id;
        LDAPConnection connection;
        LDAPConnThread connThread;
        long timeToComplete;

        RequestEntry(int id, LDAPConnection connection, LDAPConnThread connThread, int timeLimit) {
            this.id = id;
            this.connection = connection;
            this.connThread = connThread;
            this.timeToComplete = timeLimit == 0 ? Long.MAX_VALUE : System.currentTimeMillis() + (long)timeLimit;
        }
    }
}

