/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;
import netscape.ldap.LDAPException;

class LDAPSSLSocket
extends Socket {
    private final boolean m_debug = true;
    private Object m_socket;
    private Hashtable m_methodLookup = new Hashtable();
    private String m_packageName = null;

    public LDAPSSLSocket(String host, int port, String packageName) throws LDAPException {
        this.m_packageName = packageName;
        try {
            Class<?> c = Class.forName(this.m_packageName);
            Constructor<?>[] m = c.getConstructors();
            int i = 0;
            while (i < m.length) {
                Class<?>[] params = m[i].getParameterTypes();
                if (params.length == 2 && params[0].getName().equals("java.lang.String") && params[1].getName().equals("int")) {
                    Object[] args = new Object[]{host, new Integer(port)};
                    this.m_socket = m[i].newInstance(args);
                    return;
                }
                ++i;
            }
            throw new LDAPException("No appropriate constructor in " + this.m_packageName, 89);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new LDAPException("Class " + this.m_packageName + " not found", 80);
        }
        catch (Exception exception) {
            throw new LDAPException("Failed to create SSL socket", 91);
        }
    }

    public LDAPSSLSocket(String host, int port, String packageName, Object cipherSuites) throws LDAPException {
        this.m_packageName = packageName;
        String cipherClassName = null;
        if (cipherSuites != null) {
            cipherClassName = cipherSuites.getClass().getName();
        }
        try {
            Class<?> c = Class.forName(this.m_packageName);
            Constructor<?>[] m = c.getConstructors();
            int i = 0;
            while (i < m.length) {
                Class<?>[] params = m[i].getParameterTypes();
                if (cipherSuites == null) {
                    throw new LDAPException("Cipher Suites is required");
                }
                if (params.length == 3 && params[0].getName().equals("java.lang.String") && params[1].getName().equals("int") && params[2].getName().equals(cipherClassName)) {
                    Object[] args = new Object[]{host, new Integer(port), cipherSuites};
                    this.m_socket = m[i].newInstance(args);
                    return;
                }
                ++i;
            }
            throw new LDAPException("No appropriate constructor in " + this.m_packageName, 89);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new LDAPException("Class " + this.m_packageName + " not found", 80);
        }
        catch (Exception exception) {
            throw new LDAPException("Failed to create SSL socket", 91);
        }
    }

    public void close() throws IOException {
        try {
            this.invokeMethod(this.m_socket, "close", null);
        }
        catch (LDAPException e) {
            this.printDebug(e.toString());
        }
    }

    public void close(boolean wait) throws IOException {
        try {
            Object[] args = new Object[]{new Boolean(wait)};
            this.invokeMethod(this.m_socket, "close", args);
        }
        catch (LDAPException e) {
            this.printDebug(e.toString());
        }
    }

    public InetAddress getInetAddress() {
        try {
            Object obj = this.invokeMethod(this.m_socket, "getInetAddress", null);
            return (InetAddress)obj;
        }
        catch (LDAPException e) {
            this.printDebug(e.toString());
            return null;
        }
    }

    public InputStream getInputStream() {
        try {
            Object obj = this.invokeMethod(this.m_socket, "getInputStream", null);
            return (InputStream)obj;
        }
        catch (LDAPException e) {
            this.printDebug(e.toString());
            return null;
        }
    }

    public int getLocalPort() {
        try {
            Object obj = this.invokeMethod(this.m_socket, "getLocalPort", null);
            return (Integer)obj;
        }
        catch (LDAPException e) {
            this.printDebug(e.toString());
            return -1;
        }
    }

    private Method getMethod(String name) throws LDAPException {
        try {
            Method method = null;
            method = (Method)this.m_methodLookup.get(name);
            if (method != null) {
                return method;
            }
            Class<?> c = Class.forName(this.m_packageName);
            Method[] m = c.getMethods();
            int i = 0;
            while (i < m.length) {
                if (m[i].getName().equals(name)) {
                    this.m_methodLookup.put(name, m[i]);
                    return m[i];
                }
                ++i;
            }
            throw new LDAPException("Method " + name + " not found in " + this.m_packageName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new LDAPException("Class " + this.m_packageName + " not found");
        }
    }

    public OutputStream getOutputStream() {
        try {
            Object obj = this.invokeMethod(this.m_socket, "getOutputStream", null);
            return (OutputStream)obj;
        }
        catch (LDAPException e) {
            this.printDebug(e.toString());
            return null;
        }
    }

    public int getPort() {
        try {
            Object obj = this.invokeMethod(this.m_socket, "getPort", null);
            return (Integer)obj;
        }
        catch (LDAPException e) {
            this.printDebug(e.toString());
            return -1;
        }
    }

    private Object invokeMethod(Object obj, String name, Object[] args) throws LDAPException {
        try {
            Method m = this.getMethod(name);
            if (m != null) {
                return m.invoke(obj, args);
            }
        }
        catch (Exception e) {
            throw new LDAPException("Invoking " + name + ": " + e.toString(), 89);
        }
        return null;
    }

    private void printDebug(String msg) {
        System.out.println(msg);
    }
}

