/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.factory;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSocketFactory;

public class JSSESocketFactory
implements LDAPSocketFactory,
Serializable {
    static final long serialVersionUID = 6834205777733266609L;
    private String[] suites;
    private SSLSocketFactory factory;

    public JSSESocketFactory(String[] suites) {
        this(suites, null);
    }

    public JSSESocketFactory(String[] suites, SSLSocketFactory factory) {
        this.suites = suites;
        this.factory = factory != null ? factory : (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    public Socket makeSocket(String host, int port) throws LDAPException {
        SSLSocket sock = null;
        try {
            sock = (SSLSocket)this.factory.createSocket(host, port);
            if (this.suites != null) {
                sock.setEnabledCipherSuites(this.suites);
            }
            sock.startHandshake();
        }
        catch (UnknownHostException e) {
            throw new LDAPException("SSL connection to " + host + ":" + port + ", " + e.getMessage(), 91);
        }
        catch (IOException f) {
            throw new LDAPException("SSL connection to " + host + ":" + port + ", " + f.getMessage(), 91);
        }
        return sock;
    }
}

