/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.util.Date;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class ConnectionPool {
    private int poolSize;
    private int poolMax;
    private String host;
    private int port;
    private String authdn;
    private String authpw;
    private LDAPConnection ldc = null;
    private Vector pool;
    private boolean debugMode;

    public ConnectionPool(int min, int max, String host, int port) throws LDAPException {
        this(min, max, host, port, "", "");
    }

    public ConnectionPool(int min, int max, String host, int port, String authdn, String authpw) throws LDAPException {
        this(min, max, host, port, authdn, authpw, null);
    }

    private ConnectionPool(int min, int max, String host, int port, String authdn, String authpw, LDAPConnection ldc) throws LDAPException {
        this.poolSize = min;
        this.poolMax = max;
        this.host = host;
        this.port = port;
        this.authdn = authdn;
        this.authpw = authpw;
        this.ldc = ldc;
        this.debugMode = false;
        this.createPool();
    }

    public ConnectionPool(int min, int max, LDAPConnection ldc) throws LDAPException {
        this(min, max, ldc.getHost(), ldc.getPort(), ldc.getAuthenticationDN(), ldc.getAuthenticationPassword(), ldc);
    }

    public ConnectionPool(String host, int port) throws LDAPException {
        this(10, 20, host, port, "", "");
    }

    private int addConnection() {
        int index = -1;
        this.debug("adding a connection to pool...");
        try {
            int size = this.pool.size() + 1;
            this.setUpPool(size);
            if (size == this.pool.size()) {
                index = size - 1;
            }
        }
        catch (Exception ex) {
            this.debug("Adding a connection: " + ex.toString());
        }
        return index;
    }

    public synchronized void close(LDAPConnection ld) {
        int index = this.find(ld);
        if (index != -1) {
            LDAPConnectionObject co = (LDAPConnectionObject)this.pool.elementAt(index);
            co.setInUse(false);
            Vector vector = this.pool;
            synchronized (vector) {
                this.pool.notifyAll();
            }
        }
    }

    private void createPool() throws LDAPException {
        if (this.poolSize <= 0) {
            throw new LDAPException("ConnectionPoolSize invalid");
        }
        if (this.poolMax < this.poolSize) {
            this.debug("ConnectionPoolMax is invalid, set to " + this.poolSize);
            this.poolMax = this.poolSize;
        }
        this.debug("****Initializing LDAP Pool****");
        this.debug("LDAP host = " + this.host + " on port " + this.port);
        this.debug("Number of connections=" + this.poolSize);
        this.debug("Maximum number of connections=" + this.poolMax);
        this.debug("******");
        this.pool = new Vector();
        this.setUpPool(this.poolSize);
    }

    private void debug(String s) {
        if (this.debugMode) {
            System.out.println("ConnectionPool (" + new Date() + ") : " + s);
        }
    }

    private void debug(String s, boolean severe) {
        if (this.debugMode || severe) {
            System.out.println("ConnectionPool (" + new Date() + ") : " + s);
        }
    }

    public void destroy() {
        int i = 0;
        while (i < this.pool.size()) {
            this.disconnect((LDAPConnectionObject)this.pool.elementAt(i));
            ++i;
        }
        this.pool.removeAllElements();
    }

    private void disconnect(LDAPConnectionObject ldapconnObject) {
        if (ldapconnObject != null && ldapconnObject.isAvailable()) {
            LDAPConnection ld = ldapconnObject.getLDAPConn();
            if (ld != null && ld.isConnected()) {
                try {
                    ld.disconnect();
                }
                catch (LDAPException e) {
                    this.debug("disconnect: " + e.toString());
                }
            }
            ldapconnObject.setLDAPConn(null);
        }
    }

    private int find(LDAPConnection con) {
        if (con != null) {
            int i = 0;
            while (i < this.pool.size()) {
                LDAPConnectionObject co = (LDAPConnectionObject)this.pool.elementAt(i);
                if (co.getLDAPConn() == con) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected synchronized LDAPConnection getConnFromPool() {
        LDAPConnection con = null;
        LDAPConnectionObject ldapconnobj = null;
        int pSize = this.pool.size();
        int i = 0;
        while (i < pSize) {
            LDAPConnectionObject co = (LDAPConnectionObject)this.pool.elementAt(i);
            if (co.isAvailable()) {
                ldapconnobj = co;
                break;
            }
            ++i;
        }
        if (ldapconnobj == null) {
            if (this.poolMax < 0 || this.poolMax > 0 && pSize < this.poolMax) {
                int i2 = this.addConnection();
                if (i2 >= 0) {
                    ldapconnobj = (LDAPConnectionObject)this.pool.elementAt(i2);
                }
            } else {
                this.debug("All pool connections in use");
            }
        }
        if (ldapconnobj != null) {
            ldapconnobj.setInUse(true);
            con = ldapconnobj.getLDAPConn();
        }
        return con;
    }

    public LDAPConnection getConnection() {
        LDAPConnection con;
        while ((con = this.getConnFromPool()) == null) {
            Vector vector = this.pool;
            synchronized (vector) {
                try {
                    this.pool.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return con;
    }

    public LDAPConnection getConnection(int timeout) {
        LDAPConnection con;
        while ((con = this.getConnFromPool()) == null) {
            long t0 = System.currentTimeMillis();
            if (timeout <= 0) {
                return con;
            }
            Vector vector = this.pool;
            synchronized (vector) {
                try {
                    this.pool.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    LDAPConnection lDAPConnection = null;
                    Object var9_7 = null;
                    return lDAPConnection;
                }
            }
            long t1 = System.currentTimeMillis();
            timeout = (int)((long)timeout - (t1 - t0));
        }
        return con;
    }

    public boolean getDebug() {
        return this.debugMode;
    }

    public void printPool() {
        System.out.println("--ConnectionPool--");
        int i = 0;
        while (i < this.pool.size()) {
            LDAPConnectionObject co = (LDAPConnectionObject)this.pool.elementAt(i);
            System.out.println(i + "=" + co);
            ++i;
        }
    }

    public synchronized void setDebug(boolean mode) {
        this.debugMode = mode;
    }

    private synchronized void setUpPool(int size) throws LDAPException {
        while (this.pool.size() < size) {
            LDAPConnectionObject co = new LDAPConnectionObject();
            LDAPConnection newConn = this.ldc != null ? (LDAPConnection)this.ldc.clone() : new LDAPConnection();
            co.setLDAPConn(newConn);
            try {
                if (newConn.isConnected()) {
                    newConn.reconnect();
                } else {
                    newConn.connect(this.host, this.port, this.authdn, this.authpw);
                }
            }
            catch (LDAPException le) {
                this.debug("Creating pool:" + le.toString());
                this.debug("aborting....");
                throw le;
            }
            co.setInUse(false);
            this.pool.addElement(co);
        }
    }

    class LDAPConnectionObject {
        private LDAPConnection ld;
        private boolean inUse;

        LDAPConnectionObject() {
        }

        LDAPConnection getLDAPConn() {
            return this.ld;
        }

        boolean isAvailable() {
            return this.inUse ^ true;
        }

        void setInUse(boolean inUse) {
            this.inUse = inUse;
        }

        void setLDAPConn(LDAPConnection ld) {
            this.ld = ld;
        }

        public String toString() {
            return "LDAPConnection=" + this.ld + ",inUse=" + this.inUse;
        }
    }
}

