/*
 *******************************************************************************
 * $RCSfile: KeysWriter.hpp,v $
 *
 * Description: 
 *
 * Last change: $Date: 2005/11/14 10:20:13 $ $Revision: 1.5 $
 *
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved. Use of this 
 * product is subject to license terms. 
 *
 *******************************************************************************
 * Source Code Control System - Header
 *
 * $Header: /sgnome/cvsroots/misc/legacy/source/plugins/mime/KeysWriter.hpp,v 1.5 2005/11/14 10:20:13 rf96881 Exp $
 *******************************************************************************
 */
#ifndef KeysWriter_hpp
#define KeysWriter_hpp

#include <string>
#include <vector>
#include <stack>
#include <fstream>
#include <TreeInterfaces.hpp>

namespace apoc { namespace legacy { namespace plugins { namespace mimeplugin {
    
    class KeysWriter: public apoc::legacy::ITreeHandler
    {
    public:
	KeysWriter( bool aTruncate );
	virtual ~KeysWriter( void ){}
	
	virtual void startTree(void) ;
	virtual void endTree(void) ;
	virtual void modifyNode(const std::string& aName, int aAttributes) ;
	virtual void replaceNode(const std::string& aName, int aAttributes) ;
	virtual void removeNode(const std::string& aName) ;
	virtual void endNode(void) ;
	virtual void modifyProperty(const std::string& aName, 
				    apoc::legacy::PropertyType aType,
				    int aAttributes) ;
	virtual void replaceProperty(const std::string& aName, 
				     apoc::legacy::PropertyType aType,
				     int aAttributes) ;
	virtual void endProperty(void) ;
	virtual void setStringValue(const std::string& aValue,
				    const std::string& aLocale = kDefaultLocale ) ;
	virtual void setListValue(const std::vector<std::string>& aValue,
				  const std::string& aLocale = kDefaultLocale ) ;
        virtual void addListValues(const std::vector<std::string>& aValues,
                                   const std::string& aLocale = kDefaultLocale );
	
    protected:
    private:
	
	void composeList( const std::vector<std::string>& aValue,
			  std::string& buffer );
	std::stack<bool> mContext;
	std::string mKeysFile;
	std::string mMimeFile;
	std::string mPropKey;
	std::string mPropBuffer;
	std::ofstream mKeysStream;
	std::ofstream mMimeStream;
	std::ios::openmode mOpenMode;
	
	bool mInMimeFile;
	bool mInKeyFile;
	bool mInDelete;
	int mDepth;
    };
}}}} // apoc.legacy.plugins.mimeplugin

#endif
