<%@ page info="Navigation" language="java" %> 
<%@page contentType="text/html;charset=UTF-8"%>
<%--
 ******************************************************************************* 
 * $RCSfile: Navigation.jsp,v $
 *
 * Description: This file contains the left frame of the APOC Manager, the 
 *              navigation frame.
 *
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * Use of this product is subject to license terms.
 *
 *******************************************************************************
 --%>

<%@taglib uri="/WEB-INF/tld/com_iplanet_jato/jato.tld" prefix="jato"%> 
<%@taglib uri="/WEB-INF/tld/com_sun_web_ui/cc.tld" prefix="cc"%>

    <jato:useViewBean className="com.sun.apoc.manager.EntitiesNavigationViewBean">

    <cc:header  pageTitle="APOC.navigation.area" copyrightYear="2003"
                baseName="com.sun.apoc.manager.resource.apoc_manager"
                bundleID="apocBundle"
                styleClass="TreWhtBdy"
                preserveScroll="true"
                onLoad="javascript:view()">

        <script type="text/javascript" src="/apoc/js/MainWindow.js"></script>   

        <script type="text/javascript">
        <!--

            domain          = new Image();
            host            = new Image();
            org             = new Image();
            role            = new Image();
            user            = new Image();
            domainAssigned  = new Image();
            hostAssigned    = new Image();
            orgAssigned     = new Image();
            roleAssigned    = new Image();
            userAssigned    = new Image();
            domain.src          = "../images/domain.png";
            host.src            = "../images/host.png";
            org.src             = "../images/org.png";
            role.src            = "../images/role.png";
            user.src            = "../images/user.png";
            domainAssigned.src  = "../images/domainAssigned.png";
            hostAssigned.src    = "../images/hostAssigned.png";
            orgAssigned.src     = "../images/orgAssigned.png";
            roleAssigned.src    = "../images/roleAssigned.png";
            userAssigned.src    = "../images/userAssigned.png";

            function switchImage(nodeId,isAssigned) {
                var imageNode;

                if (nodeId<0) {
                    // change image of currently highlighted node
                    var imgNodes = document.getElementsByName("EntitiesNavigation.Tree.ChildImage");
                    var imgNode  = null;

                    for(nodeRunner = 0; nodeRunner < imgNodes.length; nodeRunner++) { 
                        imgNode     = imgNodes[nodeRunner];
                        srcAttribute= imgNode.getAttribute("src");
                        if ( (srcAttribute.indexOf("com_sun_web_ui")<0) && (imgNode.parentNode.parentNode.className=="TreSelRow") ) {
                            imageNode = imgNode;
                            break;
                        }
                    }
                } else {
                    // change image of any other node
                    var hrefNodes = document.getElementsByName("EntitiesNavigation.Tree.NodeHref");
                    var hrefNode  = null;

                    for(nodeRunner = 0; nodeRunner < hrefNodes.length; nodeRunner++) { 
                        hrefNode     = hrefNodes[nodeRunner];
                        hrefAttribute= hrefNode.getAttribute("href");

                        if (hrefAttribute.indexOf("EntitiesNavigation.Tree.NodeHref="+nodeId)>-1) {
                            imageNode = hrefNode.firstChild;
                            break;
                        }
                    }
                }

                if (imageNode!=null) {
                    var assignedPos = imageNode.src.indexOf("Assigned");
                    var newSrc;
                    if ((assignedPos>0) && (isAssigned!=true)) {
                        newSrc = imageNode.src.substring(0,assignedPos);
                        newSrc = newSrc+imageNode.src.substring(assignedPos+8,imageNode.src.length);
                        imageNode.src = newSrc;
                    } else if ((assignedPos<0) && (isAssigned==true)) {
                        dotPos = imageNode.src.lastIndexOf(".");
                        newSrc = imageNode.src.substring(0,dotPos)+"Assigned";
                        newSrc = newSrc+imageNode.src.substring(dotPos,imageNode.src.length);
                        imageNode.src = newSrc;
                    }
                }
            }

            function view() {
                <cc:text name="ContentConditionalReload" defaultValue="" />
            }
            
            function entitySearchCallback(sHref) {
                submitNavigationArea(sHref);
            }

            function submitNavigationArea(sHref) {
                var form        = document.EntitiesNavigationForm;
                var sEntityId   = extractByDelimiters("=", "&", sHref);
                form.action="/apoc/manager/EntitiesNavigation?EntitiesNavigation.DefaultHref="+sEntityId; 
                form.submit(); 
            }
            
            function handleKeys() {
                if  (window.event && window.event.keyCode == 13) {
                    handleSearchButton();
                    return false;
                }
                return true;
            }

            function handleSearchButton() {
                openSearchWindow('<cc:text name="JSContext" defaultValue=""/>', document.forms[0]['EntitiesNavigation.SearchText'].value, '', '');
                document.forms[0]['EntitiesNavigation.SearchText'].value="";
            }

        // -->
        </script> 

        <cc:form name="EntitiesNavigationForm" method="post">

            <jato:content name="DisplayAlert">
                <div class="content-layout">
                    <BR>
                    <cc:alertinline name="Alert" bundleID="apocBundle"/>
                    <BR>
                    <!-- 
                        <cc:text name="StackTrace"/>
                    -->
                </div>
            </jato:content> 

            <table width="100%" border="0" cellspacing="0" cellpadding="15" bgcolor="#FFFFFF">
                <tr><td align="left">
                    <cc:textfield  name="SearchText"
                        bundleID="apocBundle"
                        title="APOC.navigation.edit.help"
                        dynamic="false" 
                        onKeyPress="return handleKeys()"/>
                    <cc:button name="SearchButton"
                        bundleID="apocBundle" 
                        defaultValue="APOC.search.search"
                        type="secondary"
                        title="APOC.navigation.search.help"
                        onClick="javascript: handleSearchButton(); return false;"/>
                </td></tr>
            </table>

            <cc:dtree name="Tree" bundleID="apocBundle" />

        </cc:form>

    </cc:header>

</jato:useViewBean> 
