#ifndef Launcher_hpp
#define Launcher_hpp

#include <string>
#include <map>

#include <libgnome/gnome-desktop-item.h>


namespace apoc { namespace legacy { namespace plugins { namespace launchers {
    
class Launcher 
{
    private:
        typedef std::map<std::string, std::string> StrMap;
        static const char* kAppType;
        static const char* kLinkType;

        std::string mId;
        std::string mDir;
        std::string mFileName;
        StrMap mNames;
        StrMap mGenericNames;
        StrMap mComments;
	
        std::string mIconPath;
        std::string mDocPath;
        std::string mTryExec;
        std::string mType;
        std::string mExec;
        bool mRunInTerm;
        bool mFromFile;
			
        GnomeDesktopItem *mDtItem;

    public:
        static const char* kExtension;
        static const char* kIcon;
        static const char* kDocPath;
        static const char* kTryExec;
        static const char* kType;
        static const char* kExec;
        static const char* kRunInTerminal;
        static const char* kName;
        static const char* kGenericName;
        static const char* kComment;
        static const char* kDefLocale;

    public:
        Launcher(const std::string& aDir, const std::string& aFileName);
        ~Launcher();

        const std::string& getId() const { return mId; }
        const std::string& getDir() const { return mDir; }
        const std::string& getFileName() const { return mFileName; }
        const std::string& getName() const;
        const std::string& getName(const std::string& aLocale) const;
        const StrMap& getLocalizedNames() const;
        const std::string& getGenericName() const;
        const std::string& getGenericName(const std::string& aLocale) const;
        const StrMap& getLocalizedGenericNames() const;
        const std::string& getComment() const;
        const std::string& getComment(const std::string& aLocale) const;
        const StrMap& getLocalizedComments() const;
        const std::string& getIcon() const { return mIconPath; }
        const std::string& getDocPath() const { return mDocPath; }
        const std::string& getTryExec() const { return mTryExec; }
        const std::string& getType() const { return mType; }
        const std::string& getExec() const { return mExec ; }
        const bool getRunInTerm() const { return mRunInTerm; }

        bool copyTo(const std::string& aDir);
        bool copyTo(const std::string& aDir, const std::string& aFileName);

        bool write();
        void remove();

    private:
        void readStringValue(std::string &aValue, const char *aAttr);
        void readLocalizedValues(StrMap &aMap, const char *aAttr);
        bool writeTo(const std::string& aPathFile);
        void setStringItem(const char *aAttr, const std::string& aValue);
        void setLocalizedStringItem(const char *aAttr, const StrMap& aMap);
        void appendPath(const std::string& c1, const std::string& c2, 
                        std::string& result) const;
};

} } } }; //apoc.legacy.plugins.launchers
#endif
