#ifndef LAUNCHER_PLUGIN_HPP
#define LAUNCHER_PLUGIN_HPP

#include <set>

#include <TreeElements.hpp>
#include <IComponentListener.hpp>


namespace apoc { namespace legacy { namespace plugins { namespace launchers {


    class LauncherPlugin: public IComponentListener 
    { 
        public: 
            LauncherPlugin(); 
            virtual ~LauncherPlugin(); 
            void execute(); 
            
            virtual void onComponentChange(const std::string& aComponent); 
        
        private: 
            // methods 
            void renameLauncher(const std::string& aFile, 
                                const std::string& aName) const; 
            void copyFile(const std::string& aSource, 
                          const std::string& aTarget) const; 
            void backupNewUserLaunchers(
                                    const std::set<std::string>& aSet) const; 
            void createDirs() const; 
            void setDefaultBaseDir(); 
            void updateLaunchersState(); 
            void removeLaunchers(const std::set<std::string>& aSet, 
                                 const std::string& aBaseDir) const; 
            void listLaunchers(const std::string& aPath, 
                               std::set<std::string>& aFiles ) const; 
            void onChange(void); 
            void addListener(); 
            void removeListener(); 
        private: 
            // variables 
            static const char *kDeleted; 
            static const char *kUser; 
            static const char *kPrefix; 
            static const char *kDesktopDir; 
            static const char *kLauncherNode; 
            static const char *kLauncherComponent ;
            std::string mBaseDir; 
            std::string mDeletedDir; 
            std::string mUserDir; 
    };

} } } }; // launchers.plugins.legacy.apoc

#endif
