/*
 *******************************************************************************
 * $RCSfile: MimesWriter.hpp,v $
 *
 * Description: 
 *
 * Last change: $Date: 2005/11/09 13:37:11 $ $Revision: 1.4 $
 *
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved. Use of this 
 * product is subject to license terms. 
 *
 *******************************************************************************
 * Source Code Control System - Header
 *
 * $Header: /sgnome/cvsroots/misc/legacy/source/plugins/mime/MimesWriter.hpp,v 1.4 2005/11/09 13:37:11 rf96881 Exp $
 *******************************************************************************
 */
#ifndef MimesWriter_hpp
#define MimesWriter_hpp

#include <string>
#include <vector>
#include <stack>
#include <TreeInterfaces.hpp>

#include <libxml/xmlwriter.h>

namespace apoc{ namespace legacy { namespace plugins { namespace mimeplugin {

    class MimesWriter: public apoc::legacy::ITreeHandler
    {
    public:
	MimesWriter( );
	virtual ~MimesWriter( void ){};
	
	virtual void startTree(void) ;
	virtual void endTree(void) ;
	virtual void modifyNode(const std::string &aName, int aAttributes) ;
	virtual void replaceNode(const std::string &aName, int aAttributes) ;
	virtual void removeNode(const std::string &aName) ;
	virtual void endNode(void) ;
	virtual void modifyProperty(const std::string &aName, 
				    apoc::legacy::PropertyType aType,
				    int aAttributes) ;
	virtual void replaceProperty(const std::string &aName, 
				     apoc::legacy::PropertyType aType,
				     int aAttributes) ;
	virtual void endProperty(void) ;
	virtual void setStringValue(const std::string &aValue,
				    const std::string &aLocale = kDefaultLocale ) ;
	virtual void setListValue(const std::vector<std::string>& aValue,
				  const std::string &aLocale = kDefaultLocale) ;
	
        virtual void addListValues(const std::vector<std::string>& aValues,
                                   const std::string &aLocale = kDefaultLocale);
	
    protected:
    private:
	void writeProperty( const std::string &aName, const std::string &aAttrName,
			    const std::string &aAttrValue, const std::string &aText );
	std::stack<bool> mContext;
	std::string mMimeFile;
	std::string mPropName;
	//	bool mIgnore;
	bool mIgnoreProperty;
	int mDepth;
	xmlTextWriterPtr  mWriter;
    };
}}}} // apoc.legacy.plugins.mimeplugin
#endif
    
