#ifndef NodePath_hpp
#define NodePath_hpp

#include <string>
#include <vector>

namespace apoc { namespace legacy {

class NodePath
{
    public :
        NodePath(const std::string& aPath) { setPath(aPath) ; }
        NodePath(const std::string& aComponent, 
                 const std::vector<std::string>& aPathElements);
        ~NodePath(void) {}

        void setPath(const std::string& aPath) ;
        const std::string& getComponent(void) const { return mComponent ; }
        const std::string& getPath(void) const { return mPath ; }
        const std::vector<std::string>& getPathElements(void) const
        {
            return mPathElements ;
        }
        enum CompareResult
        {
            NotRelated = -1,
            Equal,
            Deeper,
            Shallower
        } ;
        CompareResult compare(const NodePath& aNodePath) const ;
        CompareResult compare(
                        const std::vector<std::string>& aPathElements) const ;
    protected :
    private :
        std::string mComponent ;
        std::string mPath;
        std::vector<std::string> mPathElements ;
} ;

} } // apoc.legacy

#endif // NodePath_hpp
