#ifndef SessionManagement_hpp
#define SessionManagement_hpp

#include <string>

namespace apoc { namespace session {
    
enum SessionType 
{
    SessionType_Undefined,
    SessionType_Command,
    SessionType_CDE,
    SessionType_JDS,
    SessionType_RDP,
    SessionType_Virtual,
    SessionType_SGD
} ;

struct RDPData
{
    std::string mHost ;
} ;

struct SGDData
{
    std::string mHost ;
} ;

struct VirtualData 
{
    bool mIsTemplate ;
    std::string mName ;

    VirtualData(void) : mIsTemplate(false) {}
} ;

class SessionManagement
{
    public :
        explicit SessionManagement(const std::string& aEntity) ;
        SessionManagement(const SessionManagement& aData) ;
        ~SessionManagement(void) ;

        SessionType getSessionType(void) const { return mType ; }
        bool isProtected(void) const { return mIsProtected ; }
        const RDPData& getRDPData(void) const ;
        const VirtualData& getVirtualData(void) const ;
        const SGDData& getSGDData(void) const ;
        const char *getCommand(void) const ;
    protected :
    private :
        SessionType mType ;
        bool mIsProtected ;
        union
        {
            RDPData *asRDPData ;
            SGDData *asSGDData ;
            VirtualData *asVirtualData ;
            char *asCommand ;
        } mComplement ;
} ;

} } // apoc.session

#endif // SessionManagement_hpp

