#ifndef TreeInterfaces_hpp
#define TreeInterfaces_hpp

#include <string>
#include <vector>

namespace apoc { namespace legacy {

enum PropertyType
{
    UnknownProperty = -1,
    BooleanProperty,
    ShortProperty,
    IntProperty,
    LongProperty,
    DoubleProperty,
    StringProperty,
    BinaryProperty,
    BooleanListProperty,
    ShortListProperty,
    IntListProperty,
    LongListProperty,
    DoubleListProperty,
    StringListProperty,
    BinaryListProperty
} ;

enum TreeFlags
{
    FinalisedFlag   = 0x01,
    UnfinalisedFlag = 0x02,
    ReadOnlyFlag    = 0x04,
    LocalisedFlag   = 0x08
} ;

#define kDefaultLocale "default"

/** 
  Interface for tree handling classes.
  */
class ITreeHandler 
{
    public:
        virtual void startTree(void) = 0 ;
        virtual void endTree(void) = 0 ;
        virtual void modifyNode(const std::string& aName, int aAttributes) = 0 ;
        virtual void replaceNode(const std::string& aName, 
                                 int aAttributes) = 0 ;
        virtual void removeNode(const std::string& aName) = 0 ;
        virtual void endNode(void) = 0 ;
        virtual void modifyProperty(const std::string& aName, 
                                    PropertyType aType,
                                    int aAttributes) = 0 ;
        virtual void replaceProperty(const std::string& aName, 
                                     PropertyType aType,
                                     int aAttributes) = 0 ;
        virtual void endProperty(void) = 0 ;
        virtual void setStringValue(
                            const std::string& aValue, 
                            const std::string& aLocale = kDefaultLocale) = 0 ;
        virtual void setListValue(
                            const std::vector<std::string>& aValue,
                            const std::string& aLocale = kDefaultLocale) = 0 ;
        virtual void addListValues(
                            const std::vector<std::string>& aValues,
                            const std::string& aLocale = kDefaultLocale) = 0 ;
    protected: 
    private:
} ;

/**
  Interface for update layers.
  */
class IUpdateLayer
{
    public :
        virtual void read(ITreeHandler& aHandler) const = 0 ;
    protected :
    private :
} ;

} } ; // apoc.legacy

#endif // TreeInterfaces_hpp

