/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.server;

import com.sun.opencard.common.OCFConstants;
import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.server.OCFClientHandle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.Slot;

public class OCFCardHandle
implements Serializable {
    private final long handle;
    private final CardTerminalEvent event;
    private final Slot slot;
    private CardID cardID;
    private CardServiceFactory cardServiceFactory;
    private String pin = null;
    private long uid = -1L;
    private long timePinLastValidated;
    private long resetCount = 0L;
    private final Hashtable properties;
    private final Object lockNotifier;
    private final Object resetNotifier;
    private Object lockOwner = null;
    private boolean closed = false;

    public OCFCardHandle(long l, CardTerminalEvent cardTerminalEvent, Slot slot, CardID cardID) {
        this.handle = l;
        this.event = cardTerminalEvent;
        this.slot = slot;
        this.cardID = cardID;
        this.properties = new Hashtable();
        this.lockNotifier = new Object();
        this.resetNotifier = new Object();
    }

    void close() {
        this.debug("close", "");
        Object object = this.lockNotifier;
        synchronized (object) {
            if (this.lockOwner != null) {
                ((OCFClientHandle)this.lockOwner).removeLockedCard(this);
            }
            this.closed = true;
            this.lockNotifier.notifyAll();
        }
        object = this.resetNotifier;
        synchronized (object) {
            this.resetNotifier.notifyAll();
        }
    }

    private void debug(String string, String string2) {
        try {
            OCFDebug.debugln("OCFCardHandle::" + string + " " + string2);
        }
        catch (Exception exception) {}
    }

    public Object deleteProperty(String string) {
        if (this.properties.size() == 0) {
            return null;
        }
        return this.properties.remove(string);
    }

    public byte[] getATR() {
        return this.getCardID().getATR();
    }

    public CardID getCardID() {
        return this.cardID;
    }

    public String getCardName() {
        return this.cardServiceFactory.getName();
    }

    public long getHandle() {
        return this.handle;
    }

    public String getPin() {
        return this.pin;
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public String getReaderName() {
        return this.slot.getCardTerminal().getName();
    }

    public int getSlotID() {
        return this.slot.getSlotID();
    }

    public SmartCard getSmartCard() throws CardTerminalException {
        return SmartCard.getSmartCard(this.event);
    }

    public long getTimeSinceLastValidation() {
        if (this.timePinLastValidated == 0L) {
            return 0L;
        }
        Date date = new Date();
        return date.getTime() - this.timePinLastValidated + 1L;
    }

    public long getUID() {
        return this.uid;
    }

    public boolean isAccessGranted(OCFClientHandle oCFClientHandle) {
        Object object = this.lockNotifier;
        synchronized (object) {
            boolean bl = this.lockOwner == null || this.lockOwner == oCFClientHandle;
            Object var4_4 = null;
            return bl;
        }
    }

    public boolean knows(String string) {
        return this.cardServiceFactory.knows(string);
    }

    public Enumeration listProperties() {
        return this.properties.keys();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String lock(OCFClientHandle oCFClientHandle, long l) {
        this.debug("lock", "");
        long l2 = l * 1000L;
        Object object = this.lockNotifier;
        synchronized (object) {
            if (this.lockOwner == oCFClientHandle) {
                return OCFConstants.OCF_DOUBLELOCK;
            }
            do {
                if (this.lockOwner == null) {
                    if (oCFClientHandle.isRegistered()) {
                        this.lockOwner = oCFClientHandle;
                        oCFClientHandle.addLockedCard(this);
                        return OCFConstants.OCF_SUCCESS;
                    }
                    this.lockNotifier.notify();
                    return OCFConstants.OCF_INVALID_CLIENT;
                }
                this.debug("lock", "lock held by another object");
                if (l2 <= 0L) {
                    this.debug("lock", "timed out");
                    return OCFConstants.OCF_TIMEOUT;
                }
                this.debug("lock", "Timed wait");
                long l3 = System.currentTimeMillis();
                try {
                    this.lockNotifier.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    return OCFConstants.OCF_EXCEPTION;
                }
                l2 += (l3 -= System.currentTimeMillis());
            } while (!this.closed);
            return OCFConstants.OCF_INVALID_CARD;
        }
    }

    public void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void reset() throws CardTerminalException {
        try {
            this.cardID = this.getSmartCard().reset();
            Object object = this.resetNotifier;
            synchronized (object) {
                ++this.resetCount;
                this.resetNotifier.notifyAll();
            }
        }
        catch (CardTerminalException cardTerminalException) {
            this.debug("reset", cardTerminalException.getMessage());
            throw cardTerminalException;
        }
    }

    void setCardServiceFactory(CardServiceFactory cardServiceFactory) {
        this.cardServiceFactory = cardServiceFactory;
    }

    public void setPin(String string) {
        this.pin = string;
        Date date = new Date();
        this.timePinLastValidated = date.getTime();
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public void setUID(long l) {
        this.uid = l;
    }

    public String toString() {
        return "CardHandle=" + this.handle + " CardName=" + this.getCardName() + " ReaderName=" + this.getReaderName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String unlock(OCFClientHandle oCFClientHandle) {
        this.debug("unlock", "");
        Object object = this.lockNotifier;
        synchronized (object) {
            if (this.lockOwner == null) {
                return OCFConstants.OCF_SUCCESS;
            }
            if (oCFClientHandle != this.lockOwner) {
                return OCFConstants.OCF_CARD_LOCKED;
            }
            this.lockOwner = null;
            oCFClientHandle.removeLockedCard(this);
            this.lockNotifier.notify();
            return OCFConstants.OCF_SUCCESS;
        }
    }

    public String waitForCardReset() {
        String string = OCFConstants.OCF_SUCCESS;
        Object object = this.resetNotifier;
        synchronized (object) {
            long l = this.resetCount;
            if (!this.closed) {
                try {
                    this.resetNotifier.wait(OCFConstants.MAX_BLOCKING_TIME);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (l == this.resetCount) {
                string = OCFConstants.OCF_TIMEOUT;
            }
        }
        if (this.closed) {
            string = OCFConstants.OCF_INVALID_CARD;
        }
        return string;
    }

    public void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }
}

