/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.terminal.common;

import com.sun.opencard.terminal.common.ATR;
import com.sun.opencard.terminal.common.T0Protocol;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.comm.CommPort;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardNotPresentException;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.CommunicationErrorException;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.TerminalInitException;

public abstract class SimpleCardTerminal
extends CardTerminal {
    public int OPEN_TIMEOUT = 5;
    public SerialPort port;
    public CommInputStream in;
    public CommOutputStream out;
    public int baud;
    public boolean inverseConvention = true;
    public int readTimeout;
    public int extraGuardtime;
    public CardID cardId;
    public T0Protocol protocol;
    static final byte[] flip;
    private static long busy_reps;
    private static long busy_usec;

    static {
        int n;
        flip = new byte[256];
        int n2 = 0;
        while (n2 < 256) {
            byte by = (byte)(~n2);
            n = 0;
            n = (byte)(n | by >> 7 & 1);
            n = (byte)(n | by >> 5 & 2);
            n = (byte)(n | by >> 3 & 4);
            n = (byte)(n | by >> 1 & 8);
            n = (byte)(n | by << 1 & 0x10);
            n = (byte)(n | by << 3 & 0x20);
            n = (byte)(n | by << 5 & 0x40);
            SimpleCardTerminal.flip[n2] = n = (int)((byte)(n | by << 7 & 0x80));
            ++n2;
        }
        busy_reps = 1000000L;
        long l = System.currentTimeMillis();
        n = (int)busy_reps;
        while (--n >= 0) {
        }
        long l2 = System.currentTimeMillis();
        busy_usec = (l2 - l) * 1000L;
        busy_reps = 11L * busy_reps / 10L;
    }

    public SimpleCardTerminal(String string, String string2, String string3) throws CardTerminalException {
        super(string, string2, string3);
        this.addSlots(1);
    }

    public static void busywait(int n) {
        int n2 = (int)((long)n * busy_reps / busy_usec);
        while (--n2 >= 0) {
        }
    }

    public void close() throws CardTerminalException {
        this.cardId = null;
        this.in = null;
        this.out = null;
        if (this.port != null) {
            this.port.close();
            this.port = null;
        }
    }

    public int etusToMicros(int n) {
        return (int)(((long)n * 1000000L + (long)this.baud - 1L) / (long)this.baud);
    }

    public CardID getCardID(int n) throws CardTerminalException {
        return this.getCardID(n, -1);
    }

    public CardID getCardID(int n, int n2) throws CardTerminalException {
        if (this.cardId == null) {
            this.cardId = this.internalReset(n, n2);
        }
        return this.cardId;
    }

    public abstract int getInitialBaud();

    public synchronized CardID internalReset(int n, int n2) throws CardTerminalException {
        if (!this.isCardPresent(n)) {
            throw new CardNotPresentException(null, this, null);
        }
        try {
            byte[] byArray = this.resetCard(n, n2);
            if (byArray == null) {
                this.setInverseConvention(this.inverseConvention ^ true);
                byArray = this.resetCard(n, n2);
            }
            if (byArray != null) {
                return new CardID(this.getSlot(n), byArray);
            }
        }
        catch (IOException iOException) {}
        throw new CommunicationErrorException("card could not be reset");
    }

    protected ResponseAPDU internalSendAPDU(int n, CommandAPDU commandAPDU, int n2) throws CardTerminalException {
        if (n != 0) {
            throw new CardTerminalException("invalid slot");
        }
        byte[] byArray = null;
        try {
            while (this.in.available() > 0) {
                this.in.skip(this.in.available());
            }
        }
        catch (IOException iOException) {}
        byArray = this.protocol.exchangeData(commandAPDU.getBuffer(), commandAPDU.getLength());
        return new ResponseAPDU(byArray);
    }

    public void open() throws CardTerminalException {
        if (this.port != null) {
            return;
        }
        try {
            CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)this.address);
            CommPort commPort = commPortIdentifier.open(this.name, this.OPEN_TIMEOUT);
            this.port = (SerialPort)commPort;
            this.port.setFlowControlMode(0);
            this.port.enableReceiveThreshold(100000);
            this.in = new CommInputStream(this.port.getInputStream());
            this.out = new CommOutputStream(this.port.getInputStream(), this.port.getOutputStream());
            this.protocol = new T0Protocol(this.in, this.out);
            this.setResetLine(true);
        }
        catch (NoSuchPortException noSuchPortException) {
            throw new TerminalInitException("No such port: " + this.address);
        }
        catch (PortInUseException portInUseException) {
            throw new TerminalInitException("Port " + this.address + " currently owned by " + portInUseException.currentOwner);
        }
        catch (ClassCastException classCastException) {
            throw new TerminalInitException("Port " + this.address + " is not a serial port");
        }
        catch (Exception exception) {
            throw new TerminalInitException("Cannot configure serial port " + this.address);
        }
    }

    private byte[] resetCard(int n, int n2) throws IOException {
        try {
            while (this.in.available() > 0) {
                this.in.skip(this.in.available());
            }
        }
        catch (IOException iOException) {}
        this.setBaud(this.getInitialBaud());
        this.setReadTimeout(9600);
        int n3 = 372 * this.baud;
        try {
            int n4 = 500000000 / n3;
            this.setResetLine(false);
            Thread.sleep(n4);
            this.setResetLine(true);
            Thread.sleep(n4);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        ATR aTR = ATR.read(this.in);
        if (aTR == null) {
            return null;
        }
        byte[] byArray = aTR.buf;
        this.setReadTimeout(aTR.W);
        this.setExtraGuardtime(aTR.N);
        return byArray;
    }

    public boolean setBaud(int n) {
        try {
            int n2 = this.inverseConvention ? 1 : 2;
            this.port.setSerialPortParams(n, 8, 2, n2);
            this.baud = n;
            return true;
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            return false;
        }
    }

    public void setExtraGuardtime(int n) {
        if (n != 255) {
            this.extraGuardtime = this.etusToMicros(n);
        }
    }

    public void setInverseConvention(boolean bl) throws CardTerminalException {
        this.inverseConvention = bl;
        this.setBaud(this.baud);
    }

    public int setReadTimeout(int n) {
        this.readTimeout = (this.etusToMicros(n) + 999) / 1000;
        try {
            this.port.enableReceiveTimeout(this.readTimeout);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {}
        return this.readTimeout;
    }

    public abstract void setResetLine(boolean var1);

    public final class CommInputStream
    extends FilterInputStream {
        public CommInputStream(InputStream inputStream) {
            super(inputStream);
        }

        public int read() throws IOException {
            int n = this.readbyte();
            if (n < 0) {
                return n;
            }
            if (SimpleCardTerminal.this.inverseConvention) {
                n = flip[n] & 0xFF;
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.readbyte();
                if (n4 < 0) break;
                byArray[n] = SimpleCardTerminal.this.inverseConvention ? flip[n4] : (byte)n4;
                ++n;
                ++n3;
            }
            return n3;
        }

        private int readbyte() throws IOException {
            int n;
            long l = System.currentTimeMillis();
            do {
                int n2;
                if ((n2 = this.in.read()) < 0) continue;
                return n2;
            } while ((n = (int)(System.currentTimeMillis() - l)) < SimpleCardTerminal.this.readTimeout);
            return -1;
        }
    }

    public final class CommOutputStream
    extends FilterOutputStream {
        public InputStream in;

        public CommOutputStream(InputStream inputStream, OutputStream outputStream) {
            super(outputStream);
            this.in = inputStream;
        }

        public void write(int n) throws IOException {
            if (SimpleCardTerminal.this.inverseConvention) {
                n = flip[n];
            }
            this.out.write(n);
            if (SimpleCardTerminal.this.extraGuardtime != 0) {
                SimpleCardTerminal.busywait(SimpleCardTerminal.this.extraGuardtime);
            }
            this.in.read();
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (SimpleCardTerminal.this.inverseConvention) {
                byte[] byArray2 = new byte[n2];
                int n3 = 0;
                while (n3 < n2) {
                    byArray2[n3] = flip[byArray[n++] & 0xFF];
                    ++n3;
                }
                byArray = byArray2;
                n = 0;
            }
            if (SimpleCardTerminal.this.extraGuardtime == 0) {
                this.out.write(byArray, n, n2);
            } else {
                int n4 = 0;
                while (n4 < n2) {
                    this.out.write(byArray[n++]);
                    SimpleCardTerminal.busywait(SimpleCardTerminal.this.extraGuardtime);
                    ++n4;
                }
            }
            this.in.skip(n2);
        }
    }
}

