/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.terminal.sm;

import com.sun.opencard.terminal.common.SimpleCardTerminal;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TooManyListenersException;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import opencard.core.terminal.CardTerminalException;

public class SM1CardTerminal
extends SimpleCardTerminal
implements SerialPortEventListener {
    public static final int INITIAL_BAUD = 9600;
    private static final String[] features = new String[]{"display", "false", "keyboard", "false", "leds", "1", "led.0", "green", "removable", "no"};

    public SM1CardTerminal(String string, String string2, String string3) throws CardTerminalException {
        super(string, string2, string3);
    }

    public int getInitialBaud() {
        return 9600;
    }

    public Properties internalFeatures(Properties properties) {
        int n = 0;
        while (n < features.length) {
            ((Hashtable)properties).put(features[n], features[n + 1]);
            n += 2;
        }
        return properties;
    }

    public boolean isCardPresent(int n) throws CardTerminalException {
        if (n != 0 || this.port == null) {
            return false;
        }
        return !this.port.isCTS();
    }

    public void open() throws CardTerminalException {
        if (this.port != null) {
            return;
        }
        super.open();
        try {
            this.port.notifyOnCTS(true);
            this.port.addEventListener((SerialPortEventListener)this);
        }
        catch (TooManyListenersException tooManyListenersException) {}
        this.port.setDTR(true);
        this.port.setRTS(true);
    }

    public void serialEvent(SerialPortEvent serialPortEvent) {
        switch (serialPortEvent.getEventType()) {
            case 3: {
                if (!serialPortEvent.getNewValue()) {
                    this.cardInserted(0);
                    break;
                }
                this.cardId = null;
                this.cardRemoved(0);
                break;
            }
        }
    }

    public void setResetLine(boolean bl) {
        this.port.setRTS(bl);
    }
}

