/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.sdk.Log;
import auth.utauthd.DeadlockException;
import java.util.Hashtable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Mutex {
    private Thread locker = null;
    private int busycount;
    private static Hashtable waitingForLock = new Hashtable(10);

    public boolean assert() {
        Log.debug((String)("Mutex.assert.. locker = " + this.locker + ", current = " + Thread.currentThread()));
        return this.locker != null && this.locker == Thread.currentThread();
    }

    private void detectDeadlock() throws DeadlockException {
        Mutex mutex = this;
        Mutex mutex2 = this;
        if (this.locker != null && this.locker != Thread.currentThread()) {
            Log.debug((String)("Mutex :: startMutex = " + mutex2));
            do {
                Thread thread;
                if ((thread = mutex.locker) == null) {
                    return;
                }
                mutex = (Mutex)waitingForLock.get(thread);
                Log.debug((String)"Mutex :: checking for potential deadlock..");
                Log.debug((String)("Mutex :: curMutex = " + mutex));
                Log.debug((String)("Mutex :: curOwner = " + thread));
                if (mutex == null || mutex != mutex2) continue;
                throw new DeadlockException("Deadlock alert !! " + mutex + " : already in queue with : " + thread);
            } while (mutex != null);
            Log.debug((String)"Mutex :: no deadlocks anticipated");
        }
    }

    public void lock() throws DeadlockException {
        Log.debug((String)("Mutex :: Trying to lock by : " + Thread.currentThread() + " on: " + this));
        waitingForLock.put(Thread.currentThread(), this);
        Mutex mutex = this;
        synchronized (mutex) {
            this.detectDeadlock();
            while (!this.trytolock()) {
                try {
                    Log.debug((String)("Mutex :: Waiting for lock : " + Thread.currentThread() + " on: " + this));
                    this.wait();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            waitingForLock.remove(Thread.currentThread());
        }
        Log.debug((String)("Mutex :: Got lock by : " + Thread.currentThread() + " on: " + this));
    }

    private boolean trytolock() {
        if (this.locker == null) {
            this.locker = Thread.currentThread();
            this.busycount = 1;
            Log.debug((String)("Mutex :: Inc: Busy count for : " + this + " is now : " + this.busycount));
            return true;
        }
        if (this.locker == Thread.currentThread()) {
            ++this.busycount;
            Log.debug((String)("Mutex :: Inc: Busy count for : " + this + " is now : " + this.busycount));
            return true;
        }
        return false;
    }

    public void unlock() {
        Mutex mutex = this;
        synchronized (mutex) {
            if (this.locker == Thread.currentThread()) {
                --this.busycount;
                Log.debug((String)("Mutex :: Dec: Busy count for : " + this + " is now : " + this.busycount));
                if (this.busycount == 0) {
                    Log.debug((String)("Mutex :: Releasing Lock by : " + Thread.currentThread() + " on: " + this));
                    this.locker = null;
                    this.notifyAll();
                }
            } else {
                Log.unexpectedError((String)("Trying to release lock which is not owned by thread : " + Thread.currentThread()));
            }
        }
    }

    public String whoHasLock() {
        String string = this.locker != null ? "Lock owned by : " + this.locker : "Object not locked";
        return string;
    }
}

