/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.sdk.Log;
import auth.utauthd.SmartCardIDException;
import auth.utauthd.SmartCardWordException;
import auth.utauthd.SmartCardWordsImpl;
import auth.utauthd.Terminal;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class SmartCardID {
    private static final String SCCS_ID = "@(#)SmartCardID.java\t1.21 02/12/14 SMI";
    private Terminal term;
    private int tagCtr = 0;
    private String msgTag;
    private String expectedMsgTag = null;
    private boolean needMsgTags = false;
    private Hashtable tokenInfo;
    private Vector terminalTokens;
    private int state;
    private static final int STATE_DEBUG = 0;
    private static final int STATE_INIT = 1;
    private static final int STATE_ERROR = 2;
    private static final int STATE_TIMEOUT = 3;
    private static final int STATE_SEND_APDU = 10;
    private static final int STATE_XCHANGE_APDU = 11;
    private static final int STATE_RECEIVE_APDU = 20;
    private static final int STATE_RECEIVE_APDU_NO_DATA = 21;
    private static final int STATE_PROCESS = 40;
    private static final int STATE_FINISHED = 41;
    private static final int STATE_TOKEN_REMOVED = 42;
    private static final int STATE_WAITFOR_TOKEN = 43;
    private static final int STATE_CARD_RESET = 100;
    private static final int STATE_CARD_RESET_DONE = 101;
    private int mStime = 0;
    private int mSticks = 0;
    private String ti_INFO_REQ = "infoReq";
    private String ir_EVENT_MSG = "event";
    private String ir_INSERT_EVENT = "insert";
    private String ir_REMOVE_EVENT = "remove";
    private String ir_TOKEN_TYPE = "type";
    private String ir_TOKEN_ID = "id";
    private String ir_TOKEN_ATR = "atr";
    private String ir_TOKEN_ATR_HIST_START = "atr.hs";
    private String ir_UNKNOWN_TOKEN = "unknown";
    private String ir_UNKNOWN_ID = "unknown";
    public static final String ir_PSEUDO_TOKEN = "pseudo";
    private String tc_SMARTCARD = "controlSmartCard";
    private String ai_APDU_INF = "apduInf";
    private String ai_HEAD = "head";
    private String ai_RLEN = "rlen";
    private String ai_TDATA = "tdata";
    private String ai_HASH_BITMASK = "hash_bitmask";
    private String ai_SYNC = "sync";
    private String ai_NORETRY = "noretry";
    private String ai_LED = "led";
    private String ai_CARD_RESET_INF = "cardReset";
    private String ti_INFO_SMARTCARD = "infoSmartCard";
    private String isc_APDU_RESULT = "apdu_result";
    private String isc_APDU_RESULT_ERROR = "0";
    private String isc_APDU_RESULT_OK = "1";
    private String isc_REC_LEN = "rec_len";
    private String isc_REC_DATA = "rec_data";
    private String isc_HASH_RESULT = "hash_result";
    private String isc_PROC_BYTE = "proc_byte";
    private String isc_STATUS = "status";
    private String isc_RESET_RESULT = "reset_result";
    private String isc_RESET_RESULT_ERROR = "0";
    private String isc_RESET_RESULT_OK = "1";
    private String isc_RESET_ATR = this.ir_TOKEN_ATR;
    private String isc_RESET_ATR_HIST_START = this.ir_TOKEN_ATR_HIST_START;
    private Vector configFiles;
    private int configFileIndex;
    private int configFileTokenIndex;
    private int labelsIndex = 0;
    private int firstConfigFileTokenIndex = 1;
    private static final int noExceptionHandlerIndex = -1;
    private int exceptionHandlerIndex = -1;
    private static final int noLabelIndex = -1;
    private Hashtable labels;
    private String configTokensSource = null;
    private SmartCardWordsImpl scwi;
    static final String WIpropPrefix = "_WI_";
    static final String TokenID = "_WI_TokenID.ID";
    static final String TokenType = "_WI_TokenID.name";
    static final String Xchange_APDU = "_WI_Xchange_APDU.APDU";
    static final String Xchange_APDU_rlen = "_WI_Xchange_APDU.rlen";
    static final String Xchange_APDU_bitmask = "_WI_Xchange_APDU.bitmask";
    static final String Display_Message = "_WI_Display_Message";
    static final String Debug_Set = "_WI_Debug_Set";
    static final String Jump_Label = "_WI_Jump_Label";
    Properties ATRprops;
    static final String ATR_prop_prefix = "atr.";
    static final String ATR_data_prop = "atr.atr";
    static final String ATR_history_prop = "atr.history";
    static final String DEBUG_prop_prefix = "debug.";
    static final String DEBUG_words = "debug.words";
    static final String DEBUG_msg = "debug.msg";
    static final String DTU_prop_prefix = "dtu.";

    public SmartCardID(Terminal terminal, Vector vector, Vector vector2, String string) {
        this.term = terminal;
        this.state = 43;
        this.ATRprops = new Properties();
        this.labels = new Hashtable();
        this.tokenInfo = new Hashtable();
        this.configFiles = vector;
        this.configFileIndex = 0;
        this.configFileTokenIndex = this.firstConfigFileTokenIndex;
        this.terminalTokens = vector2;
        this.msgTag = string;
        this.scwi = new SmartCardWordsImpl(this);
    }

    private int adjustConfigTokenIndex(int n, StringBuffer stringBuffer) {
        int n2 = n;
        if (this.exceptionHandlerIndex != -1) {
            n2 = this.exceptionHandlerIndex;
            stringBuffer.append(" (caught)");
            this.exceptionHandlerIndex = -1;
        }
        return n2;
    }

    private synchronized String getUniqueTag() {
        this.expectedMsgTag = String.valueOf(this.msgTag) + ":" + Integer.toHexString(this.tagCtr++);
        return this.expectedMsgTag;
    }

    private int labelIndex(String string, int n) {
        int n2 = -1;
        String string2 = (String)this.labels.get(string);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
                if (n2 > n) {
                    Log.configError((String)("SmartCardID:processMsg: label: [" + string + "] " + "has invalid offset: " + n2));
                    n2 = -1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Log.configError((String)("SmartCardID:processMsg: label: [" + string + "] " + "is not a valid label"));
                n2 = -1;
            }
        } else {
            Log.configError((String)("SmartCardID:processMsg: unknown label: [" + string + "]"));
            n2 = -1;
        }
        return n2;
    }

    private void loadLabels(int n) {
        this.configTokensSource = null;
        if (this.configFiles.isEmpty()) {
            return;
        }
        if (this.configFileIndex >= this.configFiles.size()) {
            return;
        }
        Hashtable hashtable = (Hashtable)((Vector)this.configFiles.get(n)).get(this.labelsIndex);
        this.labels.clear();
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.labels.put(string, (String)hashtable.get(string));
        }
        this.configTokensSource = (String)this.labels.get("ConfigTokensSourceKey");
    }

    /*
     * Unable to fully structure code
     */
    public boolean process(String var1_1, Hashtable var2_2) throws SmartCardIDException {
        if (!var1_1.equals(this.ti_INFO_REQ)) ** GOTO lbl25
        var3_3 = (String)var2_2.get(this.ir_EVENT_MSG);
        if (var3_3.equals(this.ir_INSERT_EVENT)) {
            var4_5 = (String)var2_2.get(this.ir_TOKEN_TYPE);
            if (var4_5 == null) {
                throw new SmartCardIDException("No token type received for message: [" + var1_1 + "] " + "event: [" + var3_3 + "]");
            }
            if (this.terminalTokens.contains(var4_5.toLowerCase())) {
                this.state = 1;
                return true;
            }
            this.tokenInfo.clear();
            var5_7 = var2_2.keys();
            while (var5_7.hasMoreElements()) {
                var6_8 = (String)var5_7.nextElement();
                this.tokenInfo.put(var6_8, var2_2.get(var6_8));
            }
            this.setupATRprops(var1_1, var3_3, var2_2);
            this.state = 1;
        } else if (var3_3.equals(this.ir_REMOVE_EVENT)) {
            this.state = 42;
        } else {
            this.state = 43;
            throw new SmartCardIDException("Unknown event: [" + var3_3 + "] " + "for message: [" + var1_1 + "] " + "from terminal");
lbl25:
            // 1 sources

            if (var1_1.equals(this.ti_INFO_SMARTCARD)) {
                var4_5 = this.expectedMsgTag;
                this.expectedMsgTag = null;
                var3_3 = (String)var2_2.get("tag");
                if (var4_5 == null) {
                    if (var3_3 == null) {
                        var3_3 = "(no message tag received)";
                    }
                    throw new SmartCardIDException("Message: [" + this.ti_INFO_SMARTCARD + "] " + "message tag: [" + var3_3 + "] " + "not expected");
                }
                if (var3_3 != null) {
                    if (!var3_3.equals(var4_5)) {
                        throw new SmartCardIDException("Message: [" + this.ti_INFO_SMARTCARD + "] " + "has wrong message tag. " + "Expected: [" + var4_5 + "] " + "Received: [" + var3_3 + "] ");
                    }
                } else if (this.needMsgTags) {
                    throw new SmartCardIDException("Message: [" + this.ti_INFO_SMARTCARD + "] " + "does not have a message tag");
                }
            } else {
                throw new SmartCardIDException("Unknown message: [" + var1_1 + "] " + "from terminal");
            }
        }
        var3_4 = false;
        block17: do {
            var4_6 = false;
            switch (this.state) {
                case 1: {
                    this.configFileIndex = 0;
                    this.configFileTokenIndex = this.firstConfigFileTokenIndex;
                    this.scwi.clear();
                    this.exceptionHandlerIndex = -1;
                    this.loadLabels(this.configFileIndex);
                    this.state = 40;
                    break;
                }
                case 40: {
                    var3_4 = this.processMsg(var2_2);
                    if (!var3_4) continue block17;
                    this.state = 41;
                    break;
                }
                case 20: 
                case 21: {
                    var5_7 = (String)var2_2.get(this.isc_APDU_RESULT);
                    if (var5_7 == null) {
                        throw new SmartCardIDException("Missing APDU operation result");
                    }
                    var6_8 = (String)var2_2.get(this.isc_PROC_BYTE);
                    if (var6_8 == null) {
                        throw new SmartCardIDException("Missing APDU Procedure Byte");
                    }
                    var7_9 = (String)var2_2.get(this.isc_STATUS);
                    if (var7_9 == null) {
                        throw new SmartCardIDException("Missing APDU Status");
                    }
                    var8_11 = (String)var2_2.get(this.isc_REC_LEN);
                    if (var8_11 == null) {
                        throw new SmartCardIDException("Missing APDU Receive Length");
                    }
                    var9_12 = false;
                    try {
                        if (Integer.parseInt(var8_11, 16) > 0) {
                            var9_12 = true;
                        }
                    }
                    catch (NumberFormatException v0) {
                        throw new SmartCardIDException("APDU Receive Length format error: [" + var8_11 + "]");
                    }
                    var10_14 = false;
                    if (var5_7.equals(this.isc_APDU_RESULT_OK)) {
                        var11_15 = false;
                        var10_14 = true;
                        if (var9_12) {
                            var12_16 = (String)var2_2.get(this.isc_REC_DATA);
                            var13_17 = (String)var2_2.get(this.isc_HASH_RESULT);
                            if (var12_16 == null) {
                                throw new SmartCardIDException("Missing APDU data");
                            }
                            var11_15 = true;
                            this.scwi.pushHex(var12_16);
                            if (var13_17 != null) {
                                this.scwi.pushHex(var13_17);
                                var2_2.remove(var13_17);
                            }
                        }
                        if (this.state != 21) {
                            this.scwi.push(var11_15);
                        }
                    }
                    this.scwi.pushHex((String)var6_8);
                    this.scwi.pushHex(var7_9);
                    this.scwi.push(var10_14);
                    this.state = 40;
                    break;
                }
                case 11: {
                    var5_7 = new Hashtable<K, V>();
                    this.stuffAPDU((Hashtable)var5_7, var2_2);
                    var6_8 = (String)var2_2.get("_WI_Xchange_APDU.bitmask");
                    if (var6_8 != null) {
                        var5_7.put(this.ai_HASH_BITMASK, var6_8);
                        var2_2.remove("_WI_Xchange_APDU.bitmask");
                    }
                    var5_7.put("command", this.ai_APDU_INF);
                    if (!this.write(this.tc_SMARTCARD, (Hashtable)var5_7, this.getUniqueTag())) {
                        this.state = 2;
                        throw new SmartCardIDException("Error sending message to terminal");
                    }
                    this.state = 20;
                    var4_6 = true;
                    break;
                }
                case 10: {
                    var5_7 = new Hashtable<K, V>();
                    this.stuffAPDU((Hashtable)var5_7, var2_2);
                    var5_7.put("command", this.ai_APDU_INF);
                    if (!this.write(this.tc_SMARTCARD, (Hashtable)var5_7, this.getUniqueTag())) {
                        throw new SmartCardIDException("Error sending message to terminal");
                    }
                    this.state = 21;
                    var4_6 = true;
                    break;
                }
                case 2: {
                    this.state = 1;
                    throw new SmartCardIDException("Error while communicating with terminal");
                }
                case 3: {
                    this.state = 1;
                    throw new SmartCardIDException("Timeout while waiting for terminal response");
                }
                case 41: {
                    var5_7 = this.tokenInfo.keys();
                    while (var5_7.hasMoreElements()) {
                        var6_8 = (String)var5_7.nextElement();
                        var2_2.put(var6_8, this.tokenInfo.get(var6_8));
                    }
                    var2_2.put(this.ir_TOKEN_TYPE, var2_2.get("_WI_TokenID.name"));
                    var2_2.put(this.ir_TOKEN_ID, var2_2.get("_WI_TokenID.ID"));
                    var3_4 = true;
                    var4_6 = true;
                    break;
                }
                case 42: {
                    this.state = 43;
                    var3_4 = true;
                    break;
                }
                case 43: {
                    var3_4 = true;
                    var4_6 = true;
                    break;
                }
                case 100: {
                    var6_8 = new Hashtable<String, String>();
                    var6_8.put("command", this.ai_CARD_RESET_INF);
                    if (!this.write(this.tc_SMARTCARD, (Hashtable)var6_8, this.getUniqueTag())) {
                        this.state = 2;
                        throw new SmartCardIDException("Error sending message to terminal");
                    }
                    this.state = 101;
                    var4_6 = true;
                    break;
                }
                case 101: {
                    var6_8 = (String)var2_2.get(this.isc_RESET_RESULT);
                    if (var6_8 == null) {
                        throw new SmartCardIDException("Missing cardReset operation result");
                    }
                    var7_10 = false;
                    if (var6_8.equals(this.isc_RESET_RESULT_OK)) {
                        var8_11 = (String)var2_2.get(this.isc_RESET_ATR);
                        if (var6_8 == null) {
                            throw new SmartCardIDException("Missing ATR from cardReset");
                        }
                        var9_13 = (String)var2_2.get(this.isc_RESET_ATR_HIST_START);
                        if (var6_8 == null) {
                            throw new SmartCardIDException("Missing ATR history start from cardReset");
                        }
                        var7_10 = true;
                        this.scwi.pushHex(var8_11);
                        this.setupATRprops(this.ti_INFO_SMARTCARD, this.ai_CARD_RESET_INF, var2_2);
                    }
                    this.scwi.push(var7_10);
                    this.state = 40;
                    break;
                }
                default: {
                    this.state = 1;
                    throw new SmartCardIDException("Invalid state: " + this.state);
                }
            }
        } while (!var4_6);
        return var3_4;
    }

    public boolean processMsg(Hashtable hashtable) {
        while (this.configFileIndex < this.configFiles.size()) {
            Vector vector = (Vector)this.configFiles.get(this.configFileIndex);
            int n = vector.size();
            block16: while (this.configFileTokenIndex < n) {
                block17: while (true) {
                    String string;
                    String string2;
                    String string3;
                    String string4 = (String)vector.get(this.configFileTokenIndex++);
                    try {
                        int n2 = this.scwi.wordImpl(string4, hashtable);
                        switch (n2) {
                            case 10: {
                                this.state = 10;
                                return false;
                            }
                            case 11: {
                                this.state = 11;
                                return false;
                            }
                            case 20: {
                                this.state = 41;
                                return true;
                            }
                            case 21: {
                                this.configFileTokenIndex = n;
                                continue block16;
                            }
                            case 30: {
                                System.out.print((String)hashtable.get(Display_Message));
                                continue block16;
                            }
                            case 31: {
                                Log.notice((String)((String)hashtable.get(Display_Message)));
                                continue block16;
                            }
                            case 40: 
                            case 50: {
                                int n3 = this.labelIndex((String)hashtable.get(Jump_Label), n);
                                if (n3 == -1) {
                                    n3 = n;
                                }
                                if (n2 == 40) {
                                    this.configFileTokenIndex = n3;
                                    continue block16;
                                }
                                this.exceptionHandlerIndex = n3;
                                continue block16;
                            }
                            case 100: {
                                this.state = 100;
                                return false;
                            }
                            default: {
                                Log.configError((String)("SmartCardID:processMsg: wordImpl unknown return code: " + n2));
                                this.configFileTokenIndex = n;
                                continue block16;
                            }
                            case 0: 
                            case 32: {
                                if (this.configFileTokenIndex < n) continue block17;
                            }
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        StringBuffer stringBuffer = new StringBuffer("");
                        this.configFileTokenIndex = this.adjustConfigTokenIndex(n, stringBuffer);
                        string3 = "SmartCardID:processMsg: EmptyStackException";
                        string2 = emptyStackException.getMessage();
                        if (string2 != null) {
                            string3 = String.valueOf(string3) + ": " + string2;
                        }
                        string = String.valueOf(string3) + stringBuffer.toString();
                        Log.configError((String)string);
                        this.scwi.push(string3);
                        this.scwi.push("EmptyStackException");
                        System.out.println(string);
                        continue block16;
                    }
                    catch (NumberFormatException numberFormatException) {
                        StringBuffer stringBuffer = new StringBuffer("");
                        this.configFileTokenIndex = this.adjustConfigTokenIndex(n, stringBuffer);
                        string3 = "SmartCardID:processMsg: NumberFormatException";
                        string2 = numberFormatException.getMessage();
                        if (string2 != null) {
                            string3 = String.valueOf(string3) + ": " + string2;
                        }
                        string = String.valueOf(string3) + stringBuffer.toString();
                        Log.configError((String)string);
                        this.scwi.push(string3);
                        this.scwi.push("NumberFormatException");
                        System.out.println(string);
                        continue block16;
                    }
                    catch (SmartCardWordException smartCardWordException) {
                        StringBuffer stringBuffer = new StringBuffer("");
                        this.configFileTokenIndex = this.adjustConfigTokenIndex(n, stringBuffer);
                        string3 = String.valueOf(smartCardWordException.getMessage()) + stringBuffer.toString();
                        Log.configError((String)string3);
                        this.scwi.push(smartCardWordException.getMessage());
                        this.scwi.push("SmartCardWordException");
                        System.out.println(string3);
                    }
                    break;
                }
            }
            this.loadLabels(++this.configFileIndex);
            this.configFileTokenIndex = this.firstConfigFileTokenIndex;
            this.scwi.clear();
            this.exceptionHandlerIndex = -1;
        }
        hashtable.put(TokenType, this.ir_UNKNOWN_TOKEN);
        hashtable.put(TokenID, this.ir_UNKNOWN_ID);
        this.state = 41;
        return true;
    }

    public void setTickTime(int n) {
        this.mSticks = n;
    }

    private void setupATRprops(String string, String string2, Hashtable hashtable) throws SmartCardIDException {
        block4: {
            ((Hashtable)this.ATRprops).clear();
            String string3 = (String)hashtable.get(this.ir_TOKEN_ATR);
            if (string3 == null) {
                throw new SmartCardIDException("No ATR received for message: [" + string + "] " + "event: [" + string2 + "]");
            }
            this.ATRprops.setProperty(ATR_data_prop, this.scwi.getHexFromString(string3));
            String string4 = (String)hashtable.get(this.ir_TOKEN_ATR_HIST_START);
            if (string4 == null) break block4;
            try {
                int n = Integer.parseInt(string4, 16) * 2;
                if (n < string3.length()) {
                    this.ATRprops.setProperty(ATR_history_prop, this.scwi.getHexFromString(string3.substring(n)));
                    break block4;
                }
                Log.unexpectedError((String)("SmartCardID: invalid ATR history start: " + n));
            }
            catch (NumberFormatException numberFormatException) {
                Log.unexpectedError((String)("SmartCardID: invalid ATR history start: [" + string4 + "]"));
            }
        }
    }

    private void stuffAPDU(Hashtable hashtable, Hashtable hashtable2) {
        String string = (String)hashtable2.get(Xchange_APDU);
        String string2 = (String)hashtable2.get(Xchange_APDU_rlen);
        int n = string.length();
        hashtable.put(this.ai_HEAD, string.substring(0, Math.min(8, n)));
        if (n >= 10) {
            hashtable.put(this.ai_TDATA, string.substring(10));
        }
        if (string2 != null) {
            hashtable.put(this.ai_RLEN, string2);
        }
    }

    public void tick() {
        this.mStime += this.mSticks;
    }

    private boolean write(String string, Hashtable hashtable, String string2) {
        hashtable.put("tag", string2);
        return this.term.write(string, hashtable);
    }
}

