/*
 * Decompiled with CFR 0.152.
 */
package admin.multihead.utmhconfig;

import java.util.ResourceBundle;

public class BindTerminals {
    private int primaryIdx = -1;
    private String[] terminals;
    private String pendingTerminalID = null;
    private String currentTerminalID = null;
    private int firstUnbound;
    private int nextToBind;
    private boolean ignoreExisting;
    private boolean discoveryCompleted = false;
    private ResourceBundle i18nBundle = null;

    private BindTerminals() {
    }

    public BindTerminals(ResourceBundle resourceBundle, int n) {
        this(resourceBundle, n, true);
    }

    public BindTerminals(ResourceBundle resourceBundle, int n, boolean bl) {
        this.terminals = new String[n];
        this.firstUnbound = 0;
        this.nextToBind = 0;
        this.ignoreExisting = bl;
        this.i18nBundle = resourceBundle;
    }

    private int findFirstUnbound() {
        int n = this.firstUnbound + 1;
        while (n < this.terminals.length && this.terminals[n] != null) {
            ++n;
        }
        return n;
    }

    private int findLastUnbound() {
        int n = this.terminals.length - 1;
        while (n >= 0 && this.terminals[n] != null) {
            --n;
        }
        return n;
    }

    public String getCurrentTerminalID() {
        return this.currentTerminalID;
    }

    public int getNextToBind() {
        return this.nextToBind;
    }

    public String getPendingTerminalID() {
        return this.pendingTerminalID;
    }

    public int getPrimaryIdx() {
        return this.primaryIdx;
    }

    public String[] getTerminals() {
        return this.terminals;
    }

    public boolean isDiscoveryCompleted() {
        return this.discoveryCompleted;
    }

    public boolean newTerminal(String string) throws IllegalStateException {
        this.currentTerminalID = string;
        if (this.pendingTerminalID == null) {
            this.pendingTerminalID = string;
            return this.discoveryCompleted;
        }
        if (this.discoveryCompleted) {
            throw new IllegalStateException(this.i18nBundle.getString("Exception.Discovery"));
        }
        if (this.ignoreExisting) {
            if (string.equals(this.pendingTerminalID)) {
                return this.discoveryCompleted;
            }
            int n = 0;
            while (n < this.terminals.length) {
                if (this.terminals[n] != null && this.terminals[n].equals(string)) {
                    return this.discoveryCompleted;
                }
                ++n;
            }
        }
        this.terminals[this.nextToBind] = this.pendingTerminalID;
        if (this.primaryIdx < 0) {
            this.primaryIdx = this.nextToBind;
        }
        if (this.nextToBind == this.firstUnbound) {
            this.firstUnbound = this.findFirstUnbound();
        }
        if (this.firstUnbound != this.findLastUnbound()) {
            this.pendingTerminalID = string;
            this.nextToBind = this.firstUnbound;
        } else {
            this.terminals[this.firstUnbound] = string;
            this.discoveryCompleted = true;
            this.nextToBind = this.firstUnbound = this.terminals.length;
        }
        return this.discoveryCompleted;
    }

    public void setNextToBind(int n) {
        if (!this.discoveryCompleted) {
            this.nextToBind = n;
        }
    }
}

