/*
 * Decompiled with CFR 0.152.
 */
package admin.multihead.utmhconfig;

import admin.multihead.utmhconfig.CreateConfig;
import admin.multihead.utmhconfig.MultiheadListCellRenderer;
import admin.multihead.utmhconfig.MultiheadListModel;
import auth.admin.Admin;
import auth.admin.UTDtuGroup;
import auth.admin.UTPolicyAttributes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MultiheadConfig
extends JFrame {
    private JLabel legalNoticeLabel;
    private JLabel bannerLabel;
    private JPanel listGroupsPanel;
    private JPanel listGroupsControlPanel;
    private JLabel listGroupsListLabel;
    private JScrollPane listGroupsListScrollPane;
    private JList listGroupsList;
    private JButton addGroupButton;
    private JButton deleteGroupButton;
    private JPanel listDetailPanel;
    private JLabel listDetailLabel;
    private JPanel listDetailTopPanel;
    private JLabel listDetailNameLabel;
    private JLabel listDetailName;
    private JLabel listDetailGeometryLabel;
    private JLabel listDetailGeometry;
    private JPanel listDetailBottomPanel;
    private JLabel listDetailDtuListTitleLabel;
    private JScrollPane listDetailDtuListScrollPane;
    private JList listDetailDtuList;
    private JPanel listButtonFillPanel;
    private JButton listExitButton;
    private CreateConfig createConfig = null;
    private Admin uta = Admin.getAdmin((String)"/etc/opt/SUNWut/utadmin.conf");
    public static ResourceBundle i18nBundle = ResourceBundle.getBundle("MHConfig");

    public MultiheadConfig() {
        if (this.uta == null) {
            try {
                String string = null;
                Process process = Runtime.getRuntime().exec("/usr/bin/id");
                if (process != null) {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    string = bufferedReader.readLine();
                } else {
                    System.out.println("Fatal: Couldn't exec id");
                    System.exit(2);
                }
                if (string.startsWith("uid=0(")) {
                    JOptionPane.showMessageDialog(this, i18nBundle.getString("Error.Config.Message"), i18nBundle.getString("Error.Title"), 0);
                    System.exit(2);
                } else {
                    JOptionPane.showMessageDialog(this, i18nBundle.getString("Error.Root.Message"), i18nBundle.getString("Error.Title"), 0);
                    System.exit(2);
                }
            }
            catch (IOException iOException) {
                System.out.println("Fatal: Couldn't exec id");
                System.exit(2);
            }
            JOptionPane.showMessageDialog(this, i18nBundle.getString("Root.Error.Message"), i18nBundle.getString("Root.Error.Title"), 0);
            System.exit(2);
        }
        this.initComponents();
        this.initMoreComponents();
        this.uta.getPolicyAttributes();
        if (!UTPolicyAttributes.isMultiheadEnabled()) {
            JOptionPane.showMessageDialog(this, i18nBundle.getString("Warning.Policy"), i18nBundle.getString("Warning.Title"), 0);
        }
        this.pack();
    }

    private void addGroupButtonAction(ActionEvent actionEvent) {
        this.createConfig = new CreateConfig(i18nBundle, this.uta, (MultiheadListModel)this.listGroupsList.getModel());
        this.createConfig.show();
    }

    private void deleteGroupAction(ActionEvent actionEvent) {
        MultiheadListModel multiheadListModel = (MultiheadListModel)this.listGroupsList.getModel();
        DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)this.listGroupsList.getSelectionModel();
        int n = defaultListSelectionModel.getMinSelectionIndex();
        if (multiheadListModel.getSize() > 0) {
            UTDtuGroup uTDtuGroup = (UTDtuGroup)multiheadListModel.getElementAt(n);
            String string = uTDtuGroup.getDtuGroupID();
            String string2 = i18nBundle.getString("CreateWizard.Check.Delete");
            if (JOptionPane.showConfirmDialog(this, string2, i18nBundle.getString("Warning.Title"), 2, 2) == 0) {
                this.uta.delDtuGrpByDtuGID(string, "MULTIHEAD");
                this.uta.syncGroup("MULTIHEAD", new String[0]);
                multiheadListModel.update();
                if (multiheadListModel.getSize() > 0) {
                    defaultListSelectionModel.setSelectionInterval(multiheadListModel.getSize() - 1, multiheadListModel.getSize() - 1);
                }
            }
        }
    }

    private void exitForm(WindowEvent windowEvent) {
        System.exit(0);
    }

    private void hastaLaVista(ActionEvent actionEvent) {
        System.exit(0);
    }

    private void initComponents() {
        this.legalNoticeLabel = new JLabel();
        this.bannerLabel = new JLabel();
        this.listGroupsPanel = new JPanel();
        this.listGroupsControlPanel = new JPanel();
        this.listGroupsListLabel = new JLabel();
        this.listGroupsListScrollPane = new JScrollPane();
        this.listGroupsList = new JList();
        this.addGroupButton = new JButton();
        this.deleteGroupButton = new JButton();
        this.listDetailPanel = new JPanel();
        this.listDetailLabel = new JLabel();
        this.listDetailTopPanel = new JPanel();
        this.listDetailNameLabel = new JLabel();
        this.listDetailName = new JLabel();
        this.listDetailGeometryLabel = new JLabel();
        this.listDetailGeometry = new JLabel();
        this.listDetailBottomPanel = new JPanel();
        this.listDetailDtuListTitleLabel = new JLabel();
        this.listDetailDtuListScrollPane = new JScrollPane();
        this.listDetailDtuList = new JList();
        this.listButtonFillPanel = new JPanel();
        this.listExitButton = new JButton();
        ((Component)this).setBackground(Color.white);
        this.setTitle(i18nBundle.getString("Title.Bar"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MultiheadConfig.this.exitForm(windowEvent);
            }
        });
        this.legalNoticeLabel.setOpaque(true);
        this.legalNoticeLabel.setBackground(Color.white);
        this.legalNoticeLabel.setText(i18nBundle.getString("GUI.LegalNotice"));
        this.legalNoticeLabel.setForeground(Color.black);
        this.legalNoticeLabel.setFont(new Font("Serif", 0, 12));
        this.getContentPane().add((Component)this.legalNoticeLabel, "South");
        this.bannerLabel.setIcon(new ImageIcon(i18nBundle.getString("Banner")));
        this.bannerLabel.setBackground(Color.white);
        this.bannerLabel.setBorder(new MatteBorder(1, 1, 1, 1, Color.white));
        this.bannerLabel.setHorizontalAlignment(2);
        this.getContentPane().add((Component)this.bannerLabel, "North");
        this.listGroupsPanel.setLayout(new GridBagLayout());
        this.listGroupsPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 2000000000));
        this.listGroupsPanel.setBackground(Color.white);
        this.listGroupsControlPanel.setLayout(new GridBagLayout());
        this.listGroupsControlPanel.setBackground(Color.white);
        this.listGroupsListLabel.setBackground(Color.white);
        this.listGroupsListLabel.setText(i18nBundle.getString("List.Title"));
        this.listGroupsListLabel.setForeground(Color.black);
        this.listGroupsListLabel.setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.listGroupsControlPanel.add((Component)this.listGroupsListLabel, gridBagConstraints);
        this.listGroupsListScrollPane.setPreferredSize(this.listGroupsList.getPreferredScrollableViewportSize());
        this.listGroupsListScrollPane.setMaximumSize(new Dimension(2000000000, 2000000000));
        this.listGroupsListScrollPane.setBackground(Color.white);
        this.listGroupsListScrollPane.setMinimumSize(this.listGroupsList.getPreferredScrollableViewportSize());
        this.listGroupsList.setBorder(new EtchedBorder());
        this.listGroupsList.setSelectionMode(0);
        this.listGroupsList.setModel(new MultiheadListModel(this.listGroupsList, this.uta, i18nBundle));
        this.listGroupsList.setCellRenderer(new MultiheadListCellRenderer());
        this.listGroupsListScrollPane.setViewportView(this.listGroupsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.8;
        this.listGroupsControlPanel.add((Component)this.listGroupsListScrollPane, gridBagConstraints);
        this.addGroupButton.setHorizontalTextPosition(0);
        this.addGroupButton.setMargin(this.deleteGroupButton.getMargin());
        this.addGroupButton.setBackground(Color.lightGray);
        this.addGroupButton.setBorder(new BevelBorder(0));
        this.addGroupButton.setText(i18nBundle.getString("List.Button.Add"));
        this.addGroupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiheadConfig.this.addGroupButtonAction(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 0.1;
        this.listGroupsControlPanel.add((Component)this.addGroupButton, gridBagConstraints);
        this.deleteGroupButton.setHorizontalTextPosition(0);
        this.deleteGroupButton.setBackground(Color.lightGray);
        this.deleteGroupButton.setBorder(new BevelBorder(0));
        this.deleteGroupButton.setText(i18nBundle.getString("List.Button.Delete"));
        this.deleteGroupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiheadConfig.this.deleteGroupAction(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 0.1;
        this.listGroupsControlPanel.add((Component)this.deleteGroupButton, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints2.anchor = 15;
        gridBagConstraints2.weightx = 0.1;
        gridBagConstraints2.weighty = 0.1;
        this.listGroupsPanel.add((Component)this.listGroupsControlPanel, gridBagConstraints2);
        this.listDetailPanel.setLayout(new GridBagLayout());
        this.listDetailPanel.setBackground(Color.white);
        this.listDetailLabel.setBackground(Color.white);
        this.listDetailLabel.setText(i18nBundle.getString("List.Detail"));
        this.listDetailLabel.setForeground(Color.black);
        this.listDetailLabel.setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.weighty = 0.1;
        this.listDetailPanel.add((Component)this.listDetailLabel, gridBagConstraints3);
        this.listDetailTopPanel.setLayout(new GridBagLayout());
        this.listDetailTopPanel.setBackground(Color.white);
        this.listDetailNameLabel.setBackground(Color.white);
        this.listDetailNameLabel.setText(i18nBundle.getString("List.Detail.GID"));
        this.listDetailNameLabel.setForeground(Color.black);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.anchor = 13;
        gridBagConstraints4.weighty = 0.1;
        this.listDetailTopPanel.add((Component)this.listDetailNameLabel, gridBagConstraints4);
        this.listDetailName.setForeground(Color.black);
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.gridwidth = 0;
        gridBagConstraints4.insets = new Insets(0, 4, 0, 4);
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.weighty = 0.1;
        this.listDetailTopPanel.add((Component)this.listDetailName, gridBagConstraints4);
        this.listDetailGeometryLabel.setBackground(Color.white);
        this.listDetailGeometryLabel.setText(i18nBundle.getString("List.Detail.Geometry"));
        this.listDetailGeometryLabel.setForeground(Color.black);
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.anchor = 13;
        gridBagConstraints4.weighty = 0.1;
        this.listDetailTopPanel.add((Component)this.listDetailGeometryLabel, gridBagConstraints4);
        this.listDetailGeometry.setForeground(Color.black);
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.gridwidth = 0;
        gridBagConstraints4.insets = new Insets(0, 4, 0, 4);
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.weighty = 0.1;
        this.listDetailTopPanel.add((Component)this.listDetailGeometry, gridBagConstraints4);
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.gridheight = 2;
        gridBagConstraints3.weighty = 0.1;
        this.listDetailPanel.add((Component)this.listDetailTopPanel, gridBagConstraints3);
        this.listDetailBottomPanel.setLayout(new BorderLayout());
        this.listDetailBottomPanel.setBackground(Color.white);
        this.listDetailDtuListTitleLabel.setBackground(Color.white);
        this.listDetailDtuListTitleLabel.setText(i18nBundle.getString("List.Detail.Dtus.Title"));
        this.listDetailDtuListTitleLabel.setForeground(Color.black);
        this.listDetailDtuListTitleLabel.setHorizontalAlignment(0);
        this.listDetailBottomPanel.add((Component)this.listDetailDtuListTitleLabel, "North");
        this.listDetailDtuListScrollPane.setPreferredSize(this.listDetailDtuList.getPreferredScrollableViewportSize());
        this.listDetailDtuListScrollPane.setBackground(Color.white);
        this.listDetailDtuListScrollPane.setMinimumSize(this.listDetailDtuList.getPreferredScrollableViewportSize());
        this.listDetailDtuList.setBorder(new EtchedBorder());
        this.listDetailDtuList.setModel(new MultiheadListModel(this.listDetailDtuList, this.uta, i18nBundle));
        this.listDetailDtuListScrollPane.setViewportView(this.listDetailDtuList);
        this.listDetailBottomPanel.add((Component)this.listDetailDtuListScrollPane, "Center");
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 4;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.gridheight = -1;
        gridBagConstraints3.fill = 3;
        gridBagConstraints3.weighty = 0.7;
        this.listDetailPanel.add((Component)this.listDetailBottomPanel, gridBagConstraints3);
        this.listButtonFillPanel.setOpaque(false);
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 5;
        gridBagConstraints3.gridwidth = -1;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.weightx = 0.1;
        this.listDetailPanel.add((Component)this.listButtonFillPanel, gridBagConstraints3);
        this.listExitButton.setHorizontalTextPosition(0);
        this.listExitButton.setMargin(this.deleteGroupButton.getMargin());
        this.listExitButton.setBackground(Color.lightGray);
        this.listExitButton.setBorder(new BevelBorder(0));
        this.listExitButton.setText(i18nBundle.getString("Exit"));
        this.listExitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiheadConfig.this.hastaLaVista(actionEvent);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 5;
        gridBagConstraints3.weighty = 0.1;
        this.listDetailPanel.add((Component)this.listExitButton, gridBagConstraints3);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints2.anchor = 15;
        gridBagConstraints2.weighty = 0.1;
        this.listGroupsPanel.add((Component)this.listDetailPanel, gridBagConstraints2);
        this.getContentPane().add((Component)this.listGroupsPanel, "Center");
    }

    private void initMoreComponents() {
        this.listGroupsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    MultiheadConfig.this.listGroupsSelectionChanged(((ListSelectionModel)listSelectionEvent.getSource()).getMinSelectionIndex());
                }
            }
        });
        this.listGroupsList.getModel().addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                MultiheadConfig.this.listContentsChanged(MultiheadConfig.this.listGroupsList, listDataEvent.getIndex0());
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                MultiheadConfig.this.listContentsChanged(MultiheadConfig.this.listGroupsList, listDataEvent.getIndex0());
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                MultiheadConfig.this.listContentsChanged(MultiheadConfig.this.listGroupsList, listDataEvent.getIndex0());
            }
        });
        ((MultiheadListModel)this.listGroupsList.getModel()).update();
    }

    public void listContentsChanged(JList jList, int n) {
        if (jList.getModel().getSize() > 0) {
            jList.setSelectedIndex(n);
            this.listGroupsSelectionChanged(n);
        } else {
            this.listGroupsSelectionChanged(-1);
        }
    }

    private void listGroupsSelectionChanged(int n) {
        MultiheadListModel multiheadListModel = (MultiheadListModel)this.listDetailDtuList.getModel();
        if (n < 0) {
            this.listDetailName.setText(null);
            this.listDetailGeometry.setText(null);
            multiheadListModel.newList(new String[0]);
        } else {
            MultiheadListModel multiheadListModel2 = (MultiheadListModel)this.listGroupsList.getModel();
            UTDtuGroup uTDtuGroup = (UTDtuGroup)multiheadListModel2.getElementAt(n);
            String string = uTDtuGroup.getPrivateData();
            String string2 = "geometry=";
            this.listDetailName.setText(uTDtuGroup.getDtuGroupID());
            this.listDetailGeometry.setText(string.substring(string.lastIndexOf("geometry=") + "geometry=".length()));
            multiheadListModel.newList(uTDtuGroup.getDtuCIDs());
        }
    }

    public static void main(String[] stringArray) {
        new MultiheadConfig().show();
    }
}

