/*
 * Decompiled with CFR 0.152.
 */
package admin.multihead.utmhconfig;

import admin.multihead.utmhconfig.IPToMacAddr;
import auth.sdk.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class TraceHotDesk {
    private static final String SessionToken = "_SUN_SUNRAY_SESSION(STRING) ";
    private static final String ConnectToken = "connect ";
    private String sessionID;
    private boolean deBounce;
    private ResourceBundle i18nBundle = null;
    private String lastAddrStr = "";
    private InetAddress host;
    private int port;
    protected BufferedReader sockin;
    public static final int AuthdPort = Utils.getPortForService((String)"utauthd-cb", (String)"tcp");

    public TraceHotDesk(ResourceBundle resourceBundle, boolean bl) throws IOException, IllegalStateException {
        this.i18nBundle = resourceBundle;
        this.common(bl, this.getSessionID());
    }

    public TraceHotDesk(ResourceBundle resourceBundle, boolean bl, String string) throws IOException {
        this.i18nBundle = resourceBundle;
        this.common(bl, string);
    }

    public TraceHotDesk(ResourceBundle resourceBundle, boolean bl, String string, InetAddress inetAddress, int n) throws IOException {
        this.i18nBundle = resourceBundle;
        this.common(bl, string, inetAddress, n);
    }

    private void common(boolean bl, String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String string2 = stringTokenizer.nextToken();
        int n = new Integer(stringTokenizer.nextToken());
        this.common(bl, string, InetAddress.getByName(string2), n);
    }

    private void common(boolean bl, String string, InetAddress inetAddress, int n) throws IOException {
        Socket socket = new Socket(inetAddress, n);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
        String string2 = "join " + string + "\n";
        this.deBounce = bl;
        this.sessionID = string;
        this.host = inetAddress;
        this.port = n;
        bufferedWriter.write(string2, 0, string2.length());
        bufferedWriter.flush();
        this.sockin = new BufferedReader(new InputStreamReader(socket.getInputStream()));
    }

    private String getSessionID() throws IOException, IllegalStateException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec("xprop -root").getInputStream()));
        while ((string = bufferedReader.readLine()) != null && !string.startsWith(SessionToken)) {
        }
        if (string == null) {
            throw new IllegalStateException(this.i18nBundle.getString("Exception.SunRay"));
        }
        bufferedReader.close();
        String string2 = string.substring(string.indexOf(34) + 1, string.lastIndexOf(34));
        return string2;
    }

    public InetAddress gethost() {
        return this.host;
    }

    public int getport() {
        return this.port;
    }

    public static void main(String[] stringArray) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("MHConfig");
            if (resourceBundle == null) {
                System.out.println("Couldn't open bundle!");
                System.exit(1);
            }
            if (stringArray.length != 1) {
                System.out.println("Usage TraceHotDesk t/f");
                System.out.println("\tBoolean arg controls de-bounce");
                System.exit(1);
            }
            boolean bl = stringArray[0].startsWith("t");
            TraceHotDesk traceHotDesk = stringArray.length == 2 ? new TraceHotDesk(resourceBundle, bl, stringArray[1]) : new TraceHotDesk(resourceBundle, bl);
            while (true) {
                String string = traceHotDesk.traceTerminalId();
                System.out.println("-> " + string);
            }
        }
        catch (IllegalStateException illegalStateException) {
            System.out.println("Exception: " + illegalStateException);
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException);
        }
    }

    public String traceIP() throws IOException {
        String string = null;
        do {
            String string2;
            if ((string2 = this.sockin.readLine()) == null) {
                throw new EOFException(this.i18nBundle.getString("Exception.EOF.session"));
            }
            if (!string2.startsWith(ConnectToken)) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            stringTokenizer.nextToken();
            string = stringTokenizer.nextToken();
            if (!this.deBounce) continue;
            if (this.lastAddrStr.compareTo(string) == 0) {
                string = null;
                continue;
            }
            this.lastAddrStr = string;
        } while (string == null);
        return string;
    }

    public String traceTerminalId() throws IOException, IllegalStateException {
        IPToMacAddr iPToMacAddr;
        String string;
        String string2 = this.traceIP();
        do {
            iPToMacAddr = new IPToMacAddr(this.i18nBundle, this.host, AuthdPort);
            try {
                Thread.currentThread();
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        } while ((string = iPToMacAddr.mapIPToTerminalId(string2)) == null);
        return string;
    }
}

