/*
 * Decompiled with CFR 0.152.
 */
package com.scmmicro.smartos.core;

import com.scmmicro.smartos.core.Protocol;
import com.scmmicro.smartos.exceptions.BadParameterException;
import com.scmmicro.smartos.exceptions.BadParameterValueException;
import com.scmmicro.smartos.exceptions.CardException;
import com.scmmicro.smartos.exceptions.CommunicationException;
import com.scmmicro.smartos.exceptions.TimeOutException;
import com.scmmicro.smartos.physical.Drive;
import com.scmmicro.smartos.util.Buffer;
import com.scmmicro.smartos.util.Conversion;
import com.sun.opencard.common.OCFDebug;

public class ProtocolT0
extends Protocol {
    boolean verbose = false;
    static final byte HEADER_SIZE = 5;
    static final byte CL_OK = 0;
    static final byte GET_RESPONSE = 2;
    static final byte LE = 4;
    static byte CLASS_GET_RESPONSE = 0;
    private byte getResponseLen = (byte)5;
    private byte[] getResponse;

    public ProtocolT0() {
        byte[] byArray = new byte[5];
        byArray[1] = -64;
        this.getResponse = byArray;
    }

    private void T0_Header(Buffer buffer, boolean bl, Drive drive) throws CommunicationException, CardException, TimeOutException {
        Buffer buffer2 = new Buffer(buffer.getData(), 5);
        if (!bl) {
            buffer.flushBytes(5);
            buffer.setCapacity(buffer.getLength());
        } else {
            buffer.setLength(0);
        }
        drive.sendBlock(buffer2);
    }

    private byte T0_Procedure(Buffer buffer, boolean bl, short s, byte by, Drive drive) throws CommunicationException, CardException, TimeOutException, Exception {
        byte by2 = 0;
        int n = 1;
        Buffer buffer2 = new Buffer(n);
        drive.receiveBlock(buffer2);
        try {
            OCFDebug.debugln((String)("ProtocolT0: T0_Procedure: recived INSByte, length = " + buffer2.getLength() + " getByte(0) = " + Integer.toHexString(0xFF & buffer2.getByte(0))));
        }
        catch (Exception exception) {}
        if (buffer2.getByte(0) == 96) {
            return 1;
        }
        if (buffer2.getByte(0) == 97) {
            buffer.setLength(0);
            this.T0_ReadSW2(buffer, drive);
            this.getResponse[4] = buffer.getByte(0);
            buffer.setLength(0);
            buffer.appendBytes(this.getResponseLen, this.getResponse);
            buffer.setByte(0, CLASS_GET_RESPONSE);
            return 2;
        }
        if (buffer2.getByte(0) == 96) {
            return 1;
        }
        if ((buffer2.getByte(0) & 0xF0) == 96 || (buffer2.getByte(0) & 0xF0) == 144) {
            if (!bl) {
                buffer.setLength(0);
            }
            buffer.appendBytes(1, buffer2.getData());
            this.T0_ReadSW2(buffer, drive);
            return by2;
        }
        if (buffer2.getByte(0) == by) {
            if (s == 0) {
                try {
                    OCFDebug.debugln((String)"ProtocolT0: T0_INS waiting for more bytes");
                }
                catch (Exception exception) {}
                by2 = this.T0_ReadSW1(buffer, bl, drive);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                if (drive.getNumReceived() == 0) {
                    return by2;
                }
            }
            by2 = !bl ? this.T0_WriteAll(buffer, bl, drive) : this.T0_ReadAll(buffer, bl, s, drive);
        }
        if (~buffer2.getByte(0) == by) {
            if (s == 0) {
                by2 = this.T0_ReadSW1(buffer, bl, drive);
                return 0;
            }
            by2 = !bl ? this.T0_WriteSingle(buffer, bl, drive) : this.T0_ReadSingle(buffer, bl, s, drive);
        }
        return by2;
    }

    private byte T0_ReadAll(Buffer buffer, boolean bl, short s, Drive drive) throws CommunicationException, CardException, TimeOutException, Exception {
        Buffer buffer2 = new Buffer(s - buffer.getLength());
        if (this.verbose) {
            OCFDebug.debugln((String)("ProtocolT0: T0_ReadAll:: T0_Buffer.getLength() = " + buffer.getLength()));
        }
        try {
            drive.receiveBlock(buffer2);
        }
        catch (Exception exception) {
            OCFDebug.debugln((String)("ProtocolT0:  T0_ReadAll:: exceptions = " + exception.toString()));
            throw new CommunicationException("receiveBlock");
        }
        buffer.appendBytes(buffer2.getLength(), buffer2.getData());
        return this.T0_ReadSW1(buffer, bl, drive);
    }

    private byte T0_ReadSW1(Buffer buffer, boolean bl, Drive drive) throws CommunicationException, CardException, TimeOutException, Exception {
        Buffer buffer2 = new Buffer(1);
        do {
            try {
                OCFDebug.debugln((String)"ProtocolT0: T0_ReadSW1: before receiveBlock ");
            }
            catch (Exception exception) {}
            drive.receiveBlock(buffer2);
            try {
                byte[] byArray = new byte[buffer2.getLength()];
                int n = byArray.length;
                System.arraycopy(buffer2.getData(), 0, byArray, 0, byArray.length);
                int n2 = 0;
                while (n2 < n) {
                    OCFDebug.debugln((String)("ProtocolT0: T0_ReadSW1: received " + buffer2.getLength() + " bytes  data = " + Integer.toHexString(0xFF & byArray[n2])));
                    ++n2;
                }
            }
            catch (Exception exception) {}
        } while (buffer2.getByte(0) == 96);
        if (buffer2.getByte(0) == 97) {
            buffer.setLength(0);
            this.T0_ReadSW2(buffer, drive);
            this.getResponse[4] = buffer.getByte(0);
            buffer.setLength(0);
            buffer.setData(this.getResponse);
            buffer.setByte(0, CLASS_GET_RESPONSE);
            return 2;
        }
        if (!bl) {
            buffer.setLength(0);
        }
        buffer.appendBytes(1, buffer2.getData());
        this.T0_ReadSW2(buffer, drive);
        return 0;
    }

    private void T0_ReadSW2(Buffer buffer, Drive drive) throws CommunicationException, CardException, TimeOutException {
        Buffer buffer2 = new Buffer(1);
        drive.receiveBlock(buffer2);
        try {
            byte[] byArray = new byte[buffer2.getLength()];
            int n = byArray.length;
            System.arraycopy(buffer2.getData(), 0, byArray, 0, byArray.length);
            int n2 = 0;
            while (n2 < n) {
                OCFDebug.debugln((String)("ProtocolT0: T0_ReadSW2: received " + buffer2.getLength() + " bytes  data = " + Integer.toHexString(0xFF & byArray[n2])));
                ++n2;
            }
        }
        catch (Exception exception) {}
        buffer.appendBytes(1, buffer2.getData());
    }

    private byte T0_ReadSingle(Buffer buffer, boolean bl, short s, Drive drive) throws CommunicationException, CardException, TimeOutException, Exception {
        byte by = 0;
        Buffer buffer2 = new Buffer(1);
        drive.receiveBlock(buffer2);
        buffer.setByte(buffer.getLength(), buffer2.getByte(0));
        buffer.setLength(buffer.getLength() + 1);
        by = buffer.getLength() == s ? this.T0_ReadSW1(buffer, bl, drive) : (byte)1;
        return by;
    }

    private byte T0_Setup(Buffer buffer, Drive drive) throws CommunicationException, CardException, TimeOutException {
        byte by = 0;
        boolean bl = false;
        bl = buffer.getLength() <= 5;
        byte by2 = buffer.getByte(1);
        short s = Conversion.byteToUShort(buffer.getByte(4));
        this.T0_Header(buffer, bl, drive);
        do {
            try {
                by = this.T0_Procedure(buffer, bl, s, by2, drive);
            }
            catch (Exception exception) {}
        } while (by == true);
        if (buffer.getLength() == 0) {
            throw new CardException(" Protocol error ");
        }
        return by;
    }

    private byte T0_WriteAll(Buffer buffer, boolean bl, Drive drive) throws CommunicationException, CardException, TimeOutException, Exception {
        block5: {
            if (this.verbose) {
                OCFDebug.debugln((String)("ProtocolT0: T0_WriteAll:: T0_Buffer.getLength() = " + buffer.getLength()));
            }
            try {
                drive.sendBlock(buffer);
            }
            catch (Exception exception) {
                OCFDebug.debugln((String)("ProtocolT0: T0_WriteAll:: exceptions = " + exception.toString()));
                throw new CommunicationException("sendBlock");
            }
            if (!this.verbose) break block5;
            try {
                OCFDebug.debugln((String)"ProtocolT0: T0_WriteAll::  - After sendBlock");
            }
            catch (Exception exception) {}
        }
        return this.T0_ReadSW1(buffer, bl, drive);
    }

    private byte T0_WriteSingle(Buffer buffer, boolean bl, Drive drive) throws CommunicationException, CardException, TimeOutException, Exception {
        byte by = 0;
        Buffer buffer2 = new Buffer(buffer.getData(), 1);
        drive.sendBlock(buffer2);
        if (buffer.getLength() > 1) {
            buffer.flushBytes(1);
            buffer.setCapacity(buffer.getLength());
            by = 1;
        } else {
            by = this.T0_ReadSW1(buffer, bl, drive);
        }
        return by;
    }

    void cardExchange(Buffer buffer, Buffer buffer2, Drive drive) throws CommunicationException, CardException, TimeOutException {
        byte by = 0;
        if (this.m_rSession.getParameters().Just_Atr == 1) {
            this.m_rSession.getParameters().Just_Atr = 0;
            try {
                drive.setParameter((byte)17, this.m_rSession.getParameters().CLP_ETULength);
                drive.setParameter((byte)2, this.m_rSession.getParameters().CLP_Cgt);
                long l = 10L * (this.m_rSession.getParameters().CLP_Cwt / 3580L);
                drive.setParameter((byte)15, l);
            }
            catch (BadParameterException badParameterException) {
                throw new CommunicationException("Drive.setParameter failed : " + badParameterException.toString());
            }
            catch (BadParameterValueException badParameterValueException) {
                throw new CommunicationException("Drive.setParameter failed : " + badParameterValueException.toString());
            }
        }
        Buffer buffer3 = new Buffer(buffer.getData());
        CLASS_GET_RESPONSE = buffer3.getByte(0);
        by = this.T0_Setup(buffer3, drive);
        if (by == 2) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                throw new CommunicationException("cardExchange Wait fails " + exception.toString());
            }
            by = this.T0_Setup(buffer3, drive);
        }
        if (by != 0) {
            throw new CardException();
        }
        buffer2.setData(buffer3.getData(), buffer3.getLength());
    }
}

