/*
 * Decompiled with CFR 0.152.
 */
package com.scmmicro.smartos.physical;

import com.scmmicro.smartos.exceptions.CommunicationException;
import com.scmmicro.smartos.exceptions.TimeOutException;
import com.scmmicro.smartos.physical.CardEvent;
import com.scmmicro.smartos.physical.SerialLinkListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class SerialPortAccess
implements SerialPortEventListener {
    private boolean verbose = false;
    SerialPort m_rPort;
    private byte[] SerialBuf = new byte[4096];
    private int SB_Len = 0;
    private int lastPacket = 0;
    protected SerialLinkListener m_rSerialLinkListener = null;
    private CardEvent scEvent = null;
    public OutputStream os;
    public InputStream is;
    private byte cardState;

    public SerialPortAccess(String string) throws CommunicationException, TimeOutException {
        try {
            CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)string);
            this.m_rPort = (SerialPort)commPortIdentifier.open("SmartOS SerialDrive", 3000);
        }
        catch (PortInUseException portInUseException) {
            throw new CommunicationException();
        }
        catch (NoSuchPortException noSuchPortException) {
            throw new CommunicationException();
        }
        try {
            this.m_rPort.setSerialPortParams(9600, 8, 1, 0);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {}
            this.os = this.m_rPort.getOutputStream();
            this.is = this.m_rPort.getInputStream();
            this.m_rPort.enableReceiveTimeout(1);
            this.m_rPort.addEventListener((SerialPortEventListener)this);
            this.m_rPort.notifyOnDataAvailable(true);
            this.m_rPort.notifyOnDSR(true);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            throw new CommunicationException();
        }
        catch (IOException iOException) {
            throw new CommunicationException();
        }
        catch (TooManyListenersException tooManyListenersException) {
            throw new CommunicationException();
        }
        this.debug(" Port init ok");
    }

    private static String BytesToString(byte[] byArray) {
        String string = "";
        byte[] byArray2 = new byte[2];
        byArray2[0] = 0;
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byArray2[1] = byArray[n2];
            BigInteger bigInteger = new BigInteger(byArray2);
            if (byArray[n2] < 16 && byArray[n2] >= 0) {
                string = String.valueOf(string) + "0";
            }
            string = String.valueOf(string) + bigInteger.toString(16);
            ++n2;
        }
        return string;
    }

    public void close() throws CommunicationException {
        try {
            this.os.close();
            this.is.close();
            this.m_rPort.removeEventListener();
            this.m_rPort.close();
        }
        catch (IOException iOException) {
            this.debug("Close In and out stream ERROR");
            throw new CommunicationException();
        }
        this.debug("Close Serial Port OK");
    }

    void debug(String string) {
        if (this.verbose) {
            System.out.println("SerialPortAccess : " + string);
        }
    }

    public synchronized int getBufSize() {
        if (this.SB_Len == 0) {
            try {
                this.wait(1L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            try {
                this.wait(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.SB_Len;
    }

    public void init() throws CommunicationException {
        this.debug("Init Serial port ok");
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        if (this.SB_Len < n2) {
            n2 = this.SB_Len;
        }
        int n3 = n;
        while (n3 < n + n2) {
            byArray[n3] = this.SerialBuf[n3 - n];
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.SB_Len - n2) {
            this.SerialBuf[n4] = this.SerialBuf[n4 + n2];
            ++n4;
        }
        this.SB_Len -= n2;
        this.lastPacket -= n2;
        if (this.lastPacket < 0) {
            this.lastPacket = 0;
        }
        this.debug("Read  " + n2 + " bytes");
        return n2;
    }

    public synchronized void serialEvent(SerialPortEvent serialPortEvent) {
        int n;
        byte[] byArray;
        if (serialPortEvent.getEventType() == 4) {
            this.debug(" reader movement !!! " + serialPortEvent.getNewValue());
            this.scEvent = new CardEvent(this.m_rSerialLinkListener);
            byte by = serialPortEvent.getNewValue() ? (byte)-16 : -15;
            this.scEvent.start(by);
            return;
        }
        if (this.verbose) {
            byArray = new byte[this.SB_Len];
            n = 0;
            while (n < this.SB_Len) {
                byArray[n] = this.SerialBuf[n];
                ++n;
            }
            this.debug("SerialBuf before read =  " + SerialPortAccess.BytesToString(byArray) + "; Len = " + this.SB_Len);
        }
        try {
            this.SB_Len += this.is.read(this.SerialBuf, this.SB_Len, 1024);
        }
        catch (IOException iOException) {
            System.out.println("SerialPortAccess : error reading port");
        }
        if (this.verbose) {
            byArray = new byte[this.SB_Len];
            n = 0;
            while (n < this.SB_Len) {
                byArray[n] = this.SerialBuf[n];
                ++n;
            }
            this.debug("SerialBuf after read =  " + SerialPortAccess.BytesToString(byArray) + "; Len = " + this.SB_Len);
        }
        int n2 = this.lastPacket;
        block8: while (n2 < this.SB_Len) {
            this.debug("looking for packet at " + n2);
            switch (this.SerialBuf[n2]) {
                case 33: {
                    if (n2 + 6 <= this.SB_Len && this.SerialBuf[n2 + 2] == 2 && this.SerialBuf[n2 + 3] == 100) {
                        this.scEvent = new CardEvent(this.m_rSerialLinkListener);
                        this.scEvent.start(this.SerialBuf[n2 + 4]);
                        this.SB_Len -= 6;
                        System.arraycopy(this.SerialBuf, n2 + 6, this.SerialBuf, n2, this.SB_Len - n2);
                        break;
                    }
                }
                case 32: {
                    if (n2 + 2 >= this.SB_Len || (n2 = n2 + (this.SerialBuf[n2 + 2] & 0xFF) + 4) > this.SB_Len) break block8;
                    this.lastPacket = n2;
                    break;
                }
                default: {
                    ++n2;
                }
            }
        }
        if (this.verbose) {
            this.debug("lastPacket is now " + this.lastPacket);
            byte[] byArray2 = new byte[this.SB_Len];
            int n3 = 0;
            while (n3 < this.SB_Len) {
                byArray2[n3] = this.SerialBuf[n3];
                ++n3;
            }
            this.debug("Updated SerialBuf =  " + SerialPortAccess.BytesToString(byArray2) + "; Len = " + this.SB_Len);
        }
    }

    public void setListener(SerialLinkListener serialLinkListener) {
        this.m_rSerialLinkListener = serialLinkListener;
    }

    public void switchBaudrate(int n) throws CommunicationException {
        try {
            this.m_rPort.setSerialPortParams(n, 8, 1, 0);
            this.is.read(this.SerialBuf, 0, 1024);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            throw new CommunicationException();
        }
        catch (IOException iOException) {
            throw new CommunicationException();
        }
        this.debug("Change Baudrate");
    }

    public synchronized void write(byte[] byArray, int n) throws CommunicationException {
        try {
            this.os.write(byArray, 0, n);
        }
        catch (IOException iOException) {
            throw new CommunicationException("Write " + iOException.toString());
        }
    }
}

