/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.terminal.sunray;

import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.terminal.sunray.CardNotPresentException;
import com.sun.opencard.terminal.sunray.SRCOM;
import com.sun.opencard.terminal.sunray.SRCOMeventListener;
import com.sun.opencard.terminal.sunray.SunRayCardTerminal;
import com.sun.opencard.terminal.sunray.SunRayReaderHandle;
import com.sun.opencard.terminal.sunray.SunRaySessionEventHandler;
import com.sun.opencard.terminal.sunray.TerminalUnavailableException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalFactory;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.TerminalInitException;

public class SunRayCardTerminalFactory
implements CardTerminalFactory,
SRCOMeventListener {
    private static final String SCCS_ID = "@(#)SunRayCardTerminalFactory.java\t1.21 02/12/03 SMI";
    private static Hashtable terminalsByName = new Hashtable();
    private static Properties terminalsByID = new Properties();
    private static Hashtable handlesByID = new Hashtable();
    private static String readerBaseName = "SunRayDTU";
    private static String modelName = "SunRayDTU Internal Reader";
    private static String deviceBaseName = "DTU@";
    private static String deviceInstance = "0";
    public static final String SunRay_CTevent_SessionCreated = "SessionCreated";
    public static final String SunRay_CTevent_SessionDestroyed = "SessionDestroyed";
    public static final String SunRay_CTevent_SessionExit = "SessionExit";
    public static final String SunRay_CTevent_SessionConnect = "SessionConnect";
    public static final String SunRay_CTevent_SessionDisconnect = "SessionDisconnect";
    private static final String dispinfoFileDir = "/var/opt/SUNWut/dispinfo/";
    private static final String displaysFileDir = "/var/opt/SUNWut/displays/";
    private static final String sessionProcDir = "/tmp/SUNWut/session_proc/";
    private static final String nativeLibPath = "/opt/SUNWut/lib";
    private static final String libSRCOMname = "libsrcom.so.2";
    private static final String libSCBUSname = "libutscr.so.2";
    CardTerminalRegistry ctr;

    public void SRCOMevent(int n, String string, String string2, String string3) {
        SunRayCardTerminalFactory.debug("SRCOMevent", "event: [" + SRCOM.SRCOMeventS[n] + "] " + "termID: [" + string + "] " + "termIP: [" + string2 + "] " + "SRCOMreaderName: [" + string3 + "]");
        switch (n) {
            case 1: {
                Properties properties = terminalsByID;
                synchronized (properties) {
                    terminalsByID.setProperty(string2, string);
                    break;
                }
            }
            case 2: {
                Properties properties = terminalsByID;
                synchronized (properties) {
                    ((Hashtable)terminalsByID).remove(string2);
                    break;
                }
            }
            case 3: {
                SunRayCardTerminal sunRayCardTerminal = SunRayCardTerminalFactory.getCardTerminal(string);
                if (sunRayCardTerminal != null) {
                    sunRayCardTerminal.cardInsertedCallback(string2);
                }
                SunRayCardTerminalFactory.debug("EVENT_CARD_INSERTED", String.valueOf(sunRayCardTerminal == null ? "did not send" : "sent") + " event to CT instance");
                break;
            }
            case 4: {
                SunRayCardTerminal sunRayCardTerminal = SunRayCardTerminalFactory.getCardTerminal(string);
                if (sunRayCardTerminal != null) {
                    sunRayCardTerminal.cardRemovedCallback();
                }
                SunRayCardTerminalFactory.debug("EVENT_CARD_REMOVED", String.valueOf(sunRayCardTerminal == null ? "did not send" : "sent") + " event to CT instance");
                break;
            }
        }
    }

    public static void allocateReader(String string, SunRayReaderHandle sunRayReaderHandle) throws TerminalInitException, CardNotPresentException, TerminalUnavailableException {
        String string2 = SunRayCardTerminalFactory.getTermIDfromIP(string);
        if (string2 == null) {
            throw new TerminalUnavailableException("no matching termID found for termIP: [" + string + "]");
        }
        if (sunRayReaderHandle.isAllocated()) {
            return;
        }
        String string3 = null;
        try {
            sunRayReaderHandle.setSRCOMreaderHandle(SRCOM.allocate(string2));
        }
        catch (CardNotPresentException cardNotPresentException) {
            string3 = ((Throwable)((Object)cardNotPresentException)).getMessage();
        }
        sunRayReaderHandle.setTermIP(string);
        sunRayReaderHandle.setTermID(string2);
        Hashtable hashtable = handlesByID;
        synchronized (hashtable) {
            handlesByID.put(string2, sunRayReaderHandle);
        }
        if (string3 != null) {
            throw new CardNotPresentException(string3);
        }
        sunRayReaderHandle.allocate();
    }

    public void close() {
        SunRayCardTerminalFactory.debug("open", "here");
    }

    public static String constructReaderName(String string) {
        return String.valueOf(readerBaseName) + "|:" + string;
    }

    public void createCardTerminals(CardTerminalRegistry cardTerminalRegistry, String[] stringArray) throws CardTerminalException, TerminalInitException {
        SunRayCardTerminalFactory.debug("createCardTerminals", "Found: " + stringArray.length + " parameters");
        switch (stringArray.length) {
            default: {
                deviceBaseName = stringArray[2];
            }
            case 2: {
                modelName = stringArray[1];
            }
            case 1: {
                readerBaseName = stringArray[0];
            }
            case 0: 
        }
        try {
            SRCOM.init(this, "/opt/SUNWut/lib/libsrcom.so.2", "/opt/SUNWut/lib/libutscr.so.2");
        }
        catch (TerminalInitException terminalInitException) {
            SunRayCardTerminalFactory.debug("createCardTerminals", "TerminalInitException: [" + terminalInitException.getMessage() + "]");
            throw new TerminalInitException(terminalInitException.getMessage());
        }
        SunRayCardTerminalFactory.debug("createCardTerminals", "readerBaseName: [" + readerBaseName + "] " + "modelName: [" + modelName + "] " + "deviceBaseName: [" + deviceBaseName + "]");
        this.ctr = cardTerminalRegistry;
        new SunRaySessionEventHandler(this);
        this.createExistingSessionCT();
    }

    private void createExistingSessionCT() {
        String[] stringArray = new File(displaysFileDir).list();
        if (stringArray == null) {
            SunRayCardTerminalFactory.debug("createExistingSessionCT", "no files in displays directory");
            return;
        }
        Properties properties = new Properties();
        properties.setProperty("event", SunRay_CTevent_SessionCreated);
        int n = 0;
        while (n < stringArray.length) {
            String string = SunRayCardTerminalFactory.getXdisplayNumber(stringArray[n]);
            if (string != null) {
                String string2 = SunRayCardTerminalFactory.getSessionID(string);
                if (string2 != null) {
                    properties.setProperty("Xdisplay", string);
                    properties.setProperty("readerName", SunRayCardTerminalFactory.constructReaderName(string));
                    this.sessionEvent(properties);
                } else {
                    SunRayCardTerminalFactory.debug("createExistingSessionCT", "Not a Sun Ray X display: [" + string + "]");
                }
            } else {
                SunRayCardTerminalFactory.debug("createExistingSessionCT", "file not in X display format: [" + stringArray[n] + "]");
            }
            ++n;
        }
    }

    public static void deallocateReader(SunRayReaderHandle sunRayReaderHandle) throws CardTerminalException {
        if (!sunRayReaderHandle.isAllocated()) {
            return;
        }
        Hashtable hashtable = handlesByID;
        synchronized (hashtable) {
            handlesByID.remove(sunRayReaderHandle.getTermID());
        }
        sunRayReaderHandle.deallocate();
        SRCOM.deallocate(sunRayReaderHandle.getSRCOMreaderHandle());
    }

    private static void debug(String string, String string2) {
        try {
            OCFDebug.debugln((String)("SunRayCardTerminalFactory: <" + string + "> " + string2));
        }
        catch (Exception exception) {}
    }

    public static SunRayCardTerminal getCardTerminal(String string) {
        String string2;
        SunRayCardTerminal sunRayCardTerminal = null;
        SunRayReaderHandle sunRayReaderHandle = (SunRayReaderHandle)handlesByID.get(string);
        if (sunRayReaderHandle != null && (string2 = sunRayReaderHandle.getReaderName()) != null) {
            sunRayCardTerminal = (SunRayCardTerminal)terminalsByName.get(string2);
        }
        return sunRayCardTerminal;
    }

    public static String getSessionID(String string) {
        return SunRayCardTerminalFactory.getTokenFromFile(displaysFileDir + string, "SESSION");
    }

    public static String getTermIDfromIP(String string) {
        String string2;
        Properties properties = terminalsByID;
        synchronized (properties) {
            string2 = terminalsByID.getProperty(string);
        }
        return string2;
    }

    public static String getTermIDfromXdisplay(String string) {
        return SunRayCardTerminalFactory.getTokenFromFile(dispinfoFileDir + string, "TERMINAL_ID");
    }

    private static String getTokenFromFile(String string, String string2) {
        File file = new File(string);
        if (!file.canRead()) {
            SunRayCardTerminalFactory.debug("getTokenFromFile", "can't read file: [" + string + "]");
            return null;
        }
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            try {
                String string3;
                while ((string3 = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, "=");
                    if (!stringTokenizer.nextToken().trim().equals(string2)) continue;
                    fileReader.close();
                    return stringTokenizer.nextToken().trim();
                }
            }
            catch (IOException iOException) {
                SunRayCardTerminalFactory.debug("getTokenFromFile", "IOException");
            }
            catch (NoSuchElementException noSuchElementException) {
                SunRayCardTerminalFactory.debug("getTokenFromFile", "NoSuchElementException");
            }
            fileReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            SunRayCardTerminalFactory.debug("getTokenFromFile", "FileNotFoundException");
        }
        catch (IOException iOException) {}
        SunRayCardTerminalFactory.debug("getTokenFromFile", "token: [" + string2 + "] not found " + "in file: [" + string + "]");
        return null;
    }

    public static long getUIDfromXdisplay(String string) throws CardTerminalException {
        long l;
        String string2 = SunRayCardTerminalFactory.getTokenFromFile(sessionProcDir + string, "uid");
        if (string2 == null) {
            throw new CardTerminalException("no UID for X display: [" + string + "]");
        }
        try {
            l = new Long(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CardTerminalException("bad UID: [" + string2 + "] " + "for X display: [" + string + "]");
        }
        return l;
    }

    public static String getXdisplayNumber(String string) {
        if (string == null) {
            SunRayCardTerminalFactory.debug("getXdisplayNumber", "No X display!");
            return null;
        }
        String string2 = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            string2 = stringTokenizer.nextToken();
            new Float(string2);
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
            string2 = new Integer(stringTokenizer2.nextToken()).toString();
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = null;
            SunRayCardTerminalFactory.debug("getXdisplayNumber", "NoSuchElementException");
        }
        catch (NumberFormatException numberFormatException) {
            string2 = null;
            SunRayCardTerminalFactory.debug("getXdisplayNumber", "NumberFormatException");
        }
        if (string2 == null) {
            SunRayCardTerminalFactory.debug("getXdisplayNumber", "malformed X display: [" + string + "]");
            return null;
        }
        return string2;
    }

    public void open() {
        SunRayCardTerminalFactory.debug("open", "here");
    }

    public void sessionCreated(Properties properties) {
        SunRayCardTerminalFactory.debug("sessionCreated", "eventProps: [" + ((Hashtable)properties).toString() + "]");
        String string = properties.getProperty("Xdisplay");
        if (string == null) {
            SunRayCardTerminalFactory.debug("sessionCreated", "No X display!");
            return;
        }
        String string2 = SunRayCardTerminalFactory.getSessionID(string);
        if (string2 == null) {
            SunRayCardTerminalFactory.debug("sessionCreated", "can't get session ID for X display: [" + string + "]");
            return;
        }
        SunRayCardTerminalFactory.debug("sessionCreated", "Xdisplay: [" + string + "] " + "sessionID: [" + string2 + "]");
        String string3 = String.valueOf(deviceBaseName) + deviceInstance + ":" + string;
        String string4 = SunRayCardTerminalFactory.constructReaderName(string);
        Properties properties2 = new Properties();
        properties2.setProperty("readerName", string4);
        properties2.setProperty("modelName", modelName);
        properties2.setProperty("deviceAddress", string3);
        properties2.setProperty("Xdisplay", string);
        properties2.setProperty("filterKey", ":" + string);
        properties2.setProperty("sessionID", string2);
        if (terminalsByName.containsKey(string4)) {
            SunRayCardTerminal sunRayCardTerminal = (SunRayCardTerminal)terminalsByName.get(string4);
            SunRayCardTerminalFactory.debug("sessionCreated", "existing CT found for client");
            sunRayCardTerminal.sessionCreated(properties2);
            return;
        }
        try {
            SunRayCardTerminal sunRayCardTerminal = new SunRayCardTerminal(properties2);
            Hashtable hashtable = terminalsByName;
            synchronized (hashtable) {
                terminalsByName.put(string4, sunRayCardTerminal);
            }
            sunRayCardTerminal.sessionCreated(properties2);
            sunRayCardTerminal.addSessionListener(this);
            this.ctr.add((CardTerminal)sunRayCardTerminal);
            SunRayCardTerminalFactory.debug("sessionCreated", "added to CardTerminalRegistry: readerName: [" + string4 + "] " + "modelName: [" + modelName + "] " + "deviceAddress: [" + string3 + "]");
        }
        catch (CardTerminalException cardTerminalException) {
            Hashtable hashtable = terminalsByName;
            synchronized (hashtable) {
                terminalsByName.remove(string4);
            }
            SunRayCardTerminalFactory.debug("sessionCreated", "error adding: [" + string4 + "] " + " [" + cardTerminalException.getMessage() + "]");
        }
    }

    private void sessionDestroyed(Properties properties) {
        SunRayCardTerminalFactory.debug("sessionDestroyed", "eventProps: [" + ((Hashtable)properties).toString() + "]");
        String string = properties.getProperty("Xdisplay");
        if (string == null) {
            SunRayCardTerminalFactory.debug("sessionDestroyed", "No X display!");
            return;
        }
        String string2 = properties.getProperty("readerName");
        if (!terminalsByName.containsKey(string2)) {
            SunRayCardTerminalFactory.debug("sessionDestroyed", "terminal not found: [" + string2 + "]");
            return;
        }
        SunRayCardTerminal sunRayCardTerminal = (SunRayCardTerminal)terminalsByName.get(string2);
        sunRayCardTerminal.sessionDestroyed(properties);
        try {
            this.ctr.remove(string2);
        }
        catch (CardTerminalException cardTerminalException) {
            SunRayCardTerminalFactory.debug("sessionDestroyed", "can't remove CT from Card Terminal Registry: [" + cardTerminalException.getMessage() + "]");
        }
        Hashtable hashtable = terminalsByName;
        synchronized (hashtable) {
            terminalsByName.remove(string2);
        }
        SunRayCardTerminalFactory.debug("sessionDestroyed", "readerName: [" + string2 + "] " + "Xdisplay: [" + string + "]");
    }

    public void sessionEvent(Properties properties) {
        String string = properties.getProperty("readerName");
        String string2 = properties.getProperty("event");
        SunRayCardTerminalFactory.debug("sessionEvent", "readerName: [" + string + "] " + "event: [" + string2 + "] " + "eventProps: [" + ((Hashtable)properties).toString() + "]");
        if (string2.equals(SunRay_CTevent_SessionExit)) {
            this.sessionDestroyed(properties);
        } else if (string2.equals(SunRay_CTevent_SessionCreated)) {
            this.sessionCreated(properties);
        } else if (string2.equals(SunRay_CTevent_SessionDestroyed)) {
            SunRayCardTerminalFactory.debug("sessionEvent", "Advisory Session Destroyed event ignored.");
        } else if (!string2.equals(SunRay_CTevent_SessionConnect) && !string2.equals(SunRay_CTevent_SessionDisconnect)) {
            SunRayCardTerminalFactory.debug("sessionEvent", "invalid event!");
        }
    }
}

