/*
 * Decompiled with CFR 0.152.
 */
package auth.admin;

import auth.admin.SmartCardConfigFile;
import auth.admin.UTDtuGroup;
import auth.admin.User;
import auth.sdk.Log;
import auth.sdk.LogicalToken;
import auth.sdk.RawToken;

public class AdminImpl {
    private static AdminImpl theAdminImpl = null;
    private static String configFile = null;
    private static boolean fail = false;
    public static final int NO_CHANGE = -2;
    public static final int ERROR = -1;
    public static final int SUCCESS = 0;

    static {
        System.loadLibrary("utjadmin");
    }

    private AdminImpl() {
    }

    public native int addDtuGrp(String var1, String var2, String var3, int var4, int var5, String[] var6, int var7);

    public native int addSimpleLogicalToken(String var1, String var2);

    public native String addSimpleUser2(String var1, String var2, int var3, String var4, String var5);

    public native void closeConnection();

    public native int delDtuGrpByDtuGID(String var1, String var2);

    public native void desktopEvent(String var1, String var2, String var3, String var4, String var5, long var6);

    public native int desktopExists(String var1);

    private static void error_exit(String message) {
        Log.configError((String)("AdminImpl:" + message));
        System.exit(1);
    }

    public static AdminImpl getAdminImpl(String config) {
        if (theAdminImpl != null) {
            if (config == null) {
                try {
                    config = theAdminImpl.getUTAdminConfigFile();
                }
                catch (Exception e) {
                    AdminImpl.error_exit(e.toString());
                }
            }
            if (config != null && config.equals(configFile)) {
                return theAdminImpl;
            }
            return null;
        }
        theAdminImpl = new AdminImpl();
        if (theAdminImpl != null) {
            if (config == null) {
                try {
                    config = theAdminImpl.getUTAdminConfigFile();
                }
                catch (Exception e) {
                    AdminImpl.error_exit(e.toString());
                }
            }
            if (config != null) {
                if (theAdminImpl.openConnection(config)) {
                    configFile = config;
                } else {
                    AdminImpl.error_exit("utjadmin.so or configuration error in " + config);
                }
            } else {
                theAdminImpl = null;
            }
        }
        return theAdminImpl;
    }

    public static String getConfigFile() {
        return configFile;
    }

    public native SmartCardConfigFile[] getConfigFiles();

    public native String[] getCryptoEntByTokenID(String var1);

    public native UTDtuGroup[] getDtuGrpByDtuCID(String var1, String var2);

    public native UTDtuGroup[] getDtuGrpByDtuGID(String var1, String var2);

    public native String getDtuGrpPrimByDtuCID(String var1, String var2);

    public native int getGeneration(String var1);

    public native LogicalToken getLogicalToken(String var1);

    public native void getPolicyAttributes();

    public native String getProbeOrderTimestamp();

    public native RawToken getRawToken(String var1);

    public native String[] getTrustedGMHosts(String var1);

    public native String getUTAdminConfigFile();

    public native User getUser(String var1);

    public native User[] getUstatus();

    public native int incGeneration(String var1);

    public native boolean isGenerationValid(String var1, int var2);

    public native boolean isValidGroupName(String var1, String[] var2);

    public native int logicalTokenExists(String var1);

    public native String logicalTokenIDtoUserID(String var1);

    private native boolean openConnection(String var1);

    public native int rawTokenExists(String var1);

    public native String rawTokenIDtoLogicalTokenID(String var1);

    public native String rawTokenIDtoUserID(String var1);

    public native int syncGroup(String var1, String[] var2);

    public native void userEvent(String var1, String var2, String var3, int var4, String var5, long var6);

    public native int userExists(String var1);
}

