/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.terminal.scm.SCMI2c;

import com.sun.opencard.terminal.scm.SCMI2c.I2CCardMovementListener;
import com.sun.opencard.terminal.scm.SCMI2c.I2CDeviceAccessException;
import com.sun.opencard.terminal.scm.SCMI2c.I2CErrorException;
import com.sun.opencard.terminal.scm.SCMI2c.I2CIllegalRegisterException;
import com.sun.opencard.terminal.scm.SCMI2c.I2CNoCardException;
import com.sun.opencard.terminal.scm.SCMI2c.I2CShortCircuitException;
import com.sun.opencard.terminal.scm.SCMI2c.I2CTimeoutException;
import com.sun.opencard.terminal.scm.SCMI2c.SCMI2CNative;

public class I2CMappingLayer
implements Runnable {
    protected String devname = null;
    protected int TXtimeout_default = 1000;
    protected int RXtimeout_default = 2000;
    protected int cardPresentPollTime = 1000;
    protected I2CCardMovementListener listener;
    protected int i2cfd = -1;
    protected SCMI2CNative i2cnative;
    protected boolean lastCardInsertedState = false;
    protected boolean firstCardPresent = true;
    static final byte ADR_ETULength = 0;
    static final byte ADR_Cgt = 2;
    static final byte ADR_Cwt = 4;
    static final byte ADR_Bgt = 8;
    static final byte ADR_Bwt = 10;
    static final byte ADR_Tcon = 14;
    static final byte ADR_UARTControl = 15;
    static final byte ADR_FIFOConfig = 16;
    static final byte ADR_ITControl = 17;
    static final byte ADR_ITStatus = 18;
    static final byte ADR_DATA = 19;
    static final byte ADR_IOConfig = 20;
    static final byte ADR_SCControl = 21;
    static final byte ADR_ClkControl = 22;
    static final byte ADR_FwVersion = 23;
    static final byte ADR_Baudrate = 25;
    private static final int ETU_LENGTH_MSB = 0;
    private static final int ETU_LENGTH_MSB_RST = 128;
    private static final int ETU_LENGTH_MSB_DIV = 48;
    private static final int ETU_LENGTH_LSB = 1;
    private static final int CGT_MSB = 2;
    private static final int CGT_LSB = 3;
    private static final int CWT_BYTE3 = 4;
    private static final int CWT_BYTE2 = 5;
    private static final int CWT_BYTE1 = 6;
    private static final int CWT_BYTE0 = 7;
    private static final int BGT_MSB = 8;
    private static final int BGT_LSB = 9;
    private static final int BWT_BYTE3 = 10;
    private static final int BWT_BYTE2 = 11;
    private static final int BWT_BYTE1 = 12;
    private static final int BWT_BYTE0 = 13;
    private static final int TCON = 14;
    private static final int TCON_MGT = 128;
    private static final int TCON_MWT = 64;
    private static final int TCON_WTR = 4;
    private static final int TCON_GT = 2;
    private static final int TCON_WT = 1;
    private static final int UART_CONTROL = 15;
    private static final int UART_CONTROL_UEN = 64;
    private static final int UART_CONTROL_RST = 32;
    private static final int UART_CONTROL_CONV = 16;
    private static final int UART_CONTROL_TS = 8;
    private static final int UART_CONTROL_PE = 4;
    private static final int UART_CONTROL_RESEND = 3;
    private static final int FIFO_CONFIG = 16;
    private static final int FIFO_CONFIG_RFP = 128;
    private static final int FIFO_CONFIG_LD0 = 1;
    private static final int FIFO_CONFIG_LD1 = 2;
    private static final int FIFO_CONFIG_LD2 = 4;
    private static final int FIFO_CONFIG_LD3 = 8;
    private static final int FIFO_CONFIG_LD4 = 16;
    private static final int FIFO_CONFIG_LEVEL = 15;
    private static final int INTR_CONTROL = 17;
    private static final int INTR_CONTROL_SSL = 32;
    private static final int INTR_CONTROL_DRM = 16;
    private static final int INTR_CONTROL_DSM = 8;
    private static final int INTR_CONTROL_WTE = 4;
    private static final int INTR_CONTROL_SIM = 2;
    private static final int INTR_CONTROL_MEM = 1;
    private static final int INTR_STATUS = 18;
    private static final int INTR_STATUS_FNE = 128;
    private static final int INTR_STATUS_FE = 64;
    private static final int INTR_STATUS_OE = 32;
    private static final int INTR_STATUS_DR = 16;
    private static final int INTR_STATUS_TRE = 8;
    private static final int INTR_STATUS_WTOVF = 4;
    private static final int INTR_STATUS_SENSE = 2;
    private static final int INTR_STATUS_MOV = 1;
    private static final int DATA = 19;
    private static final int IO_CONFIG = 20;
    private static final int IO_CONFIG_SD = 1;
    private static final int IO_CONFIG_SL = 2;
    private static final int IO_CONFIG_SDE = 4;
    private static final int IO_CONFIG_ALT0 = 8;
    private static final int IO_CONFIG_ALT1 = 16;
    private static final int IO_CONFIG_ALT2 = 32;
    private static final int SC_CONTROL = 21;
    private static final int SC_CONTROL_IO = 128;
    private static final int SC_CONTROL_VCE = 64;
    private static final int SC_CONTROL_RST = 32;
    private static final int SC_CONTROL_SCE = 16;
    private static final int SC_CONTROL_SCK = 8;
    private static final int SC_CONTROL_C8 = 4;
    private static final int SC_CONTROL_C4 = 2;
    private static final int SC_CONTROL_VPE = 1;
    private static final int CLK_CONTROL = 22;
    private static final int CLK_CONTROL_OEN = 1;
    private static final int CLK_CONTROL_CKE = 2;

    public I2CMappingLayer(String string, I2CCardMovementListener i2CCardMovementListener) throws I2CDeviceAccessException, I2CErrorException {
        this.devname = string;
        if (i2CCardMovementListener == null) {
            i2CCardMovementListener = new I2CTestCardMovementListener();
        }
        this.listener = i2CCardMovementListener;
        this.i2cnative = new SCMI2CNative();
        this.i2cfd = this.i2cnative.open(string);
        this.setSendTimeout(this.TXtimeout_default);
        this.setReceiveTimeout(this.RXtimeout_default);
        this.i2cnative.enablerxtxpolling(this.i2cfd);
        new Thread((Runnable)this, "I2CMappingLayer").start();
    }

    public void cardPowerManagement(int n) throws I2CDeviceAccessException, I2CErrorException {
        this.checkAccess();
        try {
            switch (n) {
                case 1: {
                    this.writeRegister(21, this.readRegister(21) & 0xFFFFFFFFFFFFFFDFL);
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                    this.writeRegister(21, 0L);
                    break;
                }
                case 2: {
                    this.writeRegister(21, (byte)this.readRegister(21) & 0xFFFFFFDF);
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                    this.writeRegister(21, 0L);
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                    byte by = (byte)this.readRegister(21);
                    by = (byte)(by | 0x80);
                    this.writeRegister(21, by);
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                    by = (byte)(by | 0x41);
                    this.writeRegister(21, by);
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                    by = (byte)(by | 0x10);
                    this.writeRegister(21, by);
                    try {
                        Thread.sleep(40L);
                    }
                    catch (Exception exception) {}
                    by = (byte)(by | 0x20);
                    this.writeRegister(21, by);
                    try {
                        Thread.sleep(400L);
                    }
                    catch (Exception exception) {}
                    break;
                }
                default: {
                    throw new I2CDeviceAccessException("invalid parameter");
                }
            }
        }
        catch (I2CIllegalRegisterException i2CIllegalRegisterException) {
            throw new I2CErrorException("I2CIllegalRegisterException");
        }
    }

    private void checkAccess() throws I2CDeviceAccessException {
        if (this.i2cfd == -1) {
            throw new I2CDeviceAccessException("device not open");
        }
    }

    public int checkRegister(int n) throws I2CIllegalRegisterException {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
            case 10: {
                n2 = 4;
                break;
            }
            case 14: {
                n2 = 1;
                break;
            }
            case 15: {
                n2 = 1;
                break;
            }
            case 16: {
                n2 = 1;
                break;
            }
            case 17: {
                n2 = -1;
                break;
            }
            case 18: {
                n2 = -1;
                break;
            }
            case 19: {
                n2 = -1;
                break;
            }
            case 20: {
                n2 = 1;
                break;
            }
            case 21: {
                n2 = 1;
                break;
            }
            case 22: {
                n2 = 1;
                break;
            }
            case 23: {
                n2 = -1;
                break;
            }
            case 25: {
                n2 = -1;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        if (n2 == -1) {
            throw new I2CIllegalRegisterException("illegal register offset: 0x" + Integer.toHexString(n));
        }
        return n2;
    }

    public void checkShortCircuit() throws I2CDeviceAccessException, I2CErrorException, I2CShortCircuitException {
        this.checkAccess();
        this.i2cnative.checkshortcircuit(this.i2cfd);
    }

    public int getNumReceived() throws I2CDeviceAccessException, I2CErrorException {
        this.checkAccess();
        return this.i2cnative.getnumreceived(this.i2cfd);
    }

    public boolean isCardPresent() throws I2CDeviceAccessException, I2CErrorException {
        this.checkAccess();
        try {
            this.i2cnative.cardpresent(this.i2cfd);
        }
        catch (I2CNoCardException i2CNoCardException) {
            return false;
        }
        this.i2cnative.enablerxtxpolling(this.i2cfd);
        return true;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("usage: java_goop I2c_device_name");
            System.exit(-1);
        }
        String string = stringArray[0];
        I2CMappingLayer i2CMappingLayer = null;
        try {
            i2CMappingLayer = new I2CMappingLayer(string, new I2CTestCardMovementListener());
        }
        catch (Exception exception) {
            System.out.println("I2CMappingLayer:main: error:\n(exception) = " + exception.toString());
            System.exit(-2);
        }
        I2CMappingLayer.testBlockIO(i2CMappingLayer);
    }

    private static boolean powerupAndResetCard(I2CMappingLayer i2CMappingLayer) throws I2CDeviceAccessException, I2CErrorException, I2CIllegalRegisterException {
        block6: {
            try {
                int n = 15;
                int n2 = 32;
                i2CMappingLayer.writeRegister(n, n2);
                System.out.println("    ADR_UARTControl(" + n + ") = " + Integer.toHexString(n2));
                n = 15;
                n2 = 68;
                i2CMappingLayer.writeRegister(n, n2 |= 0xB);
                System.out.println("    ADR_UARTControl(" + n + ") = " + Integer.toHexString(n2));
                n = 16;
                n2 = 129;
                i2CMappingLayer.writeRegister(n, n2);
                System.out.println("    ADR_FIFOConfig(" + n + ") = " + Integer.toHexString(n2));
                n = 20;
                n2 = 2;
                i2CMappingLayer.writeRegister(n, n2);
                System.out.println("    ADR_IOConfig(" + n + ") = " + Integer.toHexString(n2));
                n = 21;
                n2 = 65;
                i2CMappingLayer.writeRegister(n, n2);
                System.out.println("    ADR_SCControl(" + n + ") = " + Integer.toHexString(n2));
                n = 20;
                n2 = 6;
                i2CMappingLayer.writeRegister(n, n2);
                System.out.println("    ADR_IOConfig(" + n + ") = " + Integer.toHexString(n2));
                n = 21;
                n2 = 65;
                i2CMappingLayer.writeRegister(n, n2 |= 0x90);
                System.out.println("    ADR_SCControl(" + n + ") = " + Integer.toHexString(n2));
                Thread.sleep(200L);
                n = 21;
                n2 = 241;
                i2CMappingLayer.writeRegister(n, n2);
                System.out.println("    ADR_SCControl(" + n + ") = " + Integer.toHexString(n2));
            }
            catch (Exception exception) {
                System.out.println("powerupAndResetCard: exception = " + exception.toString());
                return false;
            }
            System.out.println("card is reset, now waiting for ATR");
            try {
                Thread.sleep(5000L);
                int n = i2CMappingLayer.getNumReceived();
                System.out.println("    getNumReceived = [" + n + "]");
                if (n > 0) {
                    byte[] byArray = new byte[n];
                    int n3 = i2CMappingLayer.receiveBlock(byArray);
                    System.out.print("      receiveBlock = [" + n3 + "]\n" + "          ATR = [ ");
                    int n4 = 0;
                    while (n4 < n3) {
                        System.out.print("0x" + Integer.toHexString(byArray[n4]) + " ");
                        ++n4;
                    }
                    System.out.println("]\n ATR display done");
                    break block6;
                }
                System.out.println("no ATR received within timeout period");
                return false;
            }
            catch (Exception exception) {
                System.out.println("got exception while waiting for ATR:\n(exception) = " + exception.toString());
                return false;
            }
        }
        return true;
    }

    public long readRegister(int n) throws I2CDeviceAccessException, I2CErrorException, I2CIllegalRegisterException {
        this.checkAccess();
        long l = 0L;
        int n2 = this.checkRegister(n);
        while (n2-- > 0) {
            long l2 = this.i2cnative.readregister(this.i2cfd, n++);
            l |= l2 << n2 * 8;
        }
        return l;
    }

    public int receiveBlock(byte[] byArray) throws I2CDeviceAccessException, I2CErrorException, I2CNoCardException, I2CTimeoutException {
        this.checkAccess();
        return this.i2cnative.receiveblock(this.i2cfd, byArray, byArray.length);
    }

    public void resetDriver() throws I2CDeviceAccessException, I2CErrorException {
        this.i2cfd = this.i2cnative.close(this.i2cfd);
        this.lastCardInsertedState = false;
        this.firstCardPresent = true;
        this.i2cfd = this.i2cnative.open(this.devname);
        this.i2cnative.enablerxtxpolling(this.i2cfd);
    }

    public synchronized void run() {
        boolean bl = false;
        while (true) {
            try {
                bl = this.isCardPresent();
            }
            catch (Exception exception) {
                bl = false;
            }
            if (this.listener != null && (this.firstCardPresent || this.lastCardInsertedState != bl)) {
                this.firstCardPresent = false;
                this.lastCardInsertedState = bl;
                this.listener.cardMovement(bl);
            }
            try {
                Thread.sleep(this.cardPresentPollTime);
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public int sendBlock(byte[] byArray) throws I2CDeviceAccessException, I2CErrorException, I2CNoCardException, I2CTimeoutException {
        this.checkAccess();
        int n = this.i2cnative.sendblock(this.i2cfd, byArray, byArray.length);
        return n;
    }

    public void setReceiveTimeout(int n) throws I2CDeviceAccessException, I2CErrorException {
        this.checkAccess();
        this.i2cnative.setreceivetimeout(this.i2cfd, n);
    }

    public void setSendTimeout(int n) throws I2CDeviceAccessException, I2CErrorException {
        this.checkAccess();
        this.i2cnative.setsendtimeout(this.i2cfd, n);
    }

    private static void testBlockIO(I2CMappingLayer i2CMappingLayer) {
        System.out.println("testBlockIO: doing block transfer tests:\n");
        try {
            if (!I2CMappingLayer.powerupAndResetCard(i2CMappingLayer)) {
                return;
            }
            return;
        }
        catch (Exception exception) {
            System.out.println("testBlockIO: exception from sendBlock:\n(exception) = " + exception.toString());
            return;
        }
    }

    public void writeRegister(int n, long l) throws I2CDeviceAccessException, I2CErrorException, I2CIllegalRegisterException {
        this.checkAccess();
        int n2 = this.checkRegister(n);
        while (n2-- > 0) {
            this.i2cnative.writeregister(this.i2cfd, n++, (byte)(l >> n2 * 8));
        }
    }

    private static class I2CTestCardMovementListener
    implements I2CCardMovementListener {
        I2CTestCardMovementListener() {
        }

        public void cardMovement(boolean bl) {
            System.out.println("I2CTestCardMovementListener:cardMovement: present = [" + bl + "]");
        }
    }
}

