/*
 * Decompiled with CFR 0.152.
 */
package tester;

import com.scmmicro.smartos.core.Session;
import com.scmmicro.smartos.exceptions.CardException;
import com.scmmicro.smartos.util.Buffer;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import tester.AutomaticTestListener;
import tester.MessageBox;

public class AutomaticTest
extends Thread {
    private BufferedReader m_rScenario;
    private String m_sCurrentLine;
    private int m_nCurrentLineLength;
    private Frame m_frParent;
    private int m_nCurrentLine;
    private AutomaticTestListener m_rListener;
    private boolean m_bWaitForResponse;
    private String m_sResponseWished;
    private byte m_nReaderCommand;
    private String m_sResponse;
    private byte m_nResponse;
    private boolean m_bErrorOccured;
    private Session m_rSession;
    private String m_sLogFileName;
    private String m_sRequest;
    private static final char COMMENT_MARKER = '#';
    private static final char MESSAGE_MARKER = '!';
    private static final char RESPONSE_MARKER = '>';
    private static final char REQUEST_MARKER = '?';
    private static final char JOKER = 'X';
    private static final String LOG_FILE_NAME = "log.";
    private static final String PARAMETER_CMD_PREFIXE = "80600000";
    private static final String READER_CMD_PREFIXE = "201";
    private static final char CARD = '0';
    private static final char READER = '1';
    private static final char HOST = '2';
    private static final byte DEST_CARD = 0;
    private static final byte DEST_READER = 1;
    private static final byte DEST_ERROR = 2;
    private static final byte GETPARAMETER_CMD = 1;
    private static final byte SETPARAMETER_CMD = 3;
    private static final char RESET = '0';
    private static final char WARM_RESET = '4';
    private static final char DEACTIVATE_CONTACTS = '5';
    private static final String MSG_TITLE = "Automatic tests";

    public AutomaticTest(Frame frame, Session session) {
        this.m_frParent = frame;
        this.m_nCurrentLine = 1;
        this.m_bWaitForResponse = false;
        this.m_sResponseWished = "";
        this.m_rSession = session;
        this.m_bErrorOccured = false;
    }

    private boolean AnalyseResponse_(String string) {
        char[] cArray = this.m_sResponse.toCharArray();
        int n = string.length();
        if (n != this.m_sResponse.length()) {
            return false;
        }
        int n2 = 0;
        int n3 = string.indexOf(88, n2);
        while (n3 != -1) {
            cArray[n3] = 88;
            n2 = n3 + 1;
            n3 = n2 < n ? string.indexOf(88, n2) : -1;
        }
        return string.equals(String.valueOf(cArray));
    }

    private static String BytesToString(byte[] byArray) {
        String string = "";
        byte[] byArray2 = new byte[2];
        byArray2[0] = 0;
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byArray2[1] = byArray[n2];
            BigInteger bigInteger = new BigInteger(byArray2);
            if (byArray[n2] < 16 && byArray[n2] >= 0) {
                string = String.valueOf(string) + "0";
            }
            string = String.valueOf(string) + bigInteger.toString(16);
            ++n2;
        }
        return string;
    }

    private void addError_(int n, String string) throws IOException {
        BufferedWriter bufferedWriter;
        if (!this.m_bErrorOccured) {
            this.m_bErrorOccured = true;
            bufferedWriter = this.createLogFile_();
        } else {
            bufferedWriter = new BufferedWriter(new FileWriter(this.m_sLogFileName, true));
        }
        bufferedWriter.write(String.valueOf(n) + ": ");
        bufferedWriter.write("    " + string);
        bufferedWriter.newLine();
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    private void addError_(int n, String string, String string2, String string3) throws IOException {
        BufferedWriter bufferedWriter;
        if (!this.m_bErrorOccured) {
            this.m_bErrorOccured = true;
            bufferedWriter = this.createLogFile_();
        } else {
            bufferedWriter = new BufferedWriter(new FileWriter(this.m_sLogFileName, true));
        }
        bufferedWriter.write(String.valueOf(n) + ": ");
        bufferedWriter.write(string);
        bufferedWriter.newLine();
        bufferedWriter.write(">" + string2);
        bufferedWriter.newLine();
        bufferedWriter.write("#" + string3);
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    void analyseCommand_() throws IOException {
        if (this.m_sCurrentLine.length() == 0) {
            return;
        }
        if (this.m_sCurrentLine.charAt(0) == '#') {
            return;
        }
        if (this.m_sCurrentLine.charAt(0) == '!') {
            new MessageBox(this.m_frParent, MSG_TITLE, this.m_sCurrentLine.substring(1));
            return;
        }
        if (this.m_sCurrentLine.charAt(0) == '>') {
            if (!this.m_bWaitForResponse) {
                this.addError_(this.m_nCurrentLine, "Syntax error (response encontred and not wished)");
            } else {
                this.m_bWaitForResponse = false;
                this.m_sCurrentLine = this.m_sCurrentLine.substring(1);
                this.deleteBlanks_(false);
                if (!this.AnalyseResponse_(this.m_sCurrentLine)) {
                    this.addError_(this.m_nCurrentLine, this.m_sRequest, this.m_sCurrentLine, this.m_sResponse);
                }
            }
            return;
        }
        if (this.m_bWaitForResponse) {
            this.addError_(this.m_nCurrentLine, ": Syntax error (response expected)");
        }
        this.m_bWaitForResponse = false;
        this.m_sRequest = this.m_sCurrentLine;
        this.deleteBlanks_(false);
        byte by = this.analyseRequest_();
        switch (by) {
            case 0: {
                this.cardCommand_();
                break;
            }
            case 1: {
                this.readerAccess_();
                break;
            }
        }
    }

    private byte analyseRequest_() throws IOException {
        if (this.m_sCurrentLine.charAt(0) != '2') {
            this.addError_(this.m_nCurrentLine, "expeditor must be 2");
            return 2;
        }
        if (this.m_sCurrentLine.charAt(1) != ',') {
            this.addError_(this.m_nCurrentLine, "expeditor and destinator must be separated by a colon");
            return 2;
        }
        if (this.m_sCurrentLine.charAt(2) == '0') {
            this.m_sCurrentLine = this.m_sCurrentLine.substring(3);
            this.deleteBlanks_(false);
            this.m_nCurrentLineLength = this.m_sCurrentLine.length();
            return 0;
        }
        if (this.m_sCurrentLine.charAt(2) == '1') {
            this.m_sCurrentLine = this.m_sCurrentLine.substring(3);
            this.deleteBlanks_(false);
            this.m_nCurrentLineLength = this.m_sCurrentLine.length();
            return 1;
        }
        this.addError_(this.m_nCurrentLine, "destinator must be 0 or 1");
        return 2;
    }

    private void cardCommand_() throws IOException {
        int n = this.m_sCurrentLine.length();
        if (n % 2 != 0) {
            this.addError_(this.m_nCurrentLine, "Invalid command length");
            this.m_sResponse = "";
            return;
        }
        byte[] byArray = new byte[n /= 2];
        int n2 = 0;
        while (n2 < n) {
            this.stringtoBytes_(this.m_sCurrentLine.substring(2 * n2, 2 * n2 + 2), byArray, n2);
            ++n2;
        }
        Buffer buffer = new Buffer(0);
        buffer.setData(byArray);
        Buffer buffer2 = new Buffer(0);
        try {
            this.m_rSession.cardExchange(buffer, buffer2);
        }
        catch (CardException cardException) {
            try {
                if (this.m_rSession.getParameter((byte)4) == 0L) {
                    this.addError_(this.m_nCurrentLine, "NO CARD");
                    this.m_sResponse = "";
                    return;
                }
                this.addError_(this.m_nCurrentLine, "ERROR PROTOCOL" + cardException.toString());
                this.m_sResponse = "";
            }
            catch (Exception exception) {
                this.addError_(this.m_nCurrentLine, "ERROR COMM");
                this.m_sResponse = "";
                return;
            }
            return;
        }
        catch (Exception exception) {
            this.addError_(this.m_nCurrentLine, exception.toString());
            this.m_sResponse = "";
            return;
        }
        this.m_sResponse = AutomaticTest.BytesToString(buffer2.getData());
        this.m_bWaitForResponse = true;
    }

    private BufferedWriter createLogFile_() throws IOException {
        File file = new File("");
        this.m_sLogFileName = String.valueOf(file.getAbsolutePath()) + LOG_FILE_NAME;
        boolean bl = false;
        int n = 1;
        while (n < 1000 && !bl) {
            String string = this.m_sLogFileName;
            if (n < 100) {
                string = String.valueOf(string) + "0";
            }
            if (n < 10) {
                string = String.valueOf(string) + "0";
            }
            if (!(file = new File(string = String.valueOf(string) + Integer.toString(n))).exists()) {
                this.m_sLogFileName = string;
                bl = true;
            }
            ++n;
        }
        if (n > 998) {
            throw new IOException("Can't create log file (no more numbers left)");
        }
        return new BufferedWriter(new FileWriter(this.m_sLogFileName));
    }

    void deleteBlanks_(boolean bl) {
        int n = 0;
        while (n < this.m_nCurrentLineLength && (this.m_sCurrentLine.charAt(n) == ' ' || this.m_sCurrentLine.charAt(n) == '\t')) {
            ++n;
        }
        if (n > 0) {
            this.m_sCurrentLine = this.m_sCurrentLine.substring(n);
        }
        this.m_nCurrentLineLength = this.m_sCurrentLine.length();
        if (!bl) {
            return;
        }
        n = this.m_nCurrentLineLength - 1;
        while (n > 0 && (this.m_sCurrentLine.charAt(n) == ' ' || this.m_sCurrentLine.charAt(n) == '\t')) {
            --n;
        }
        if (n < this.m_nCurrentLineLength - 1) {
            this.m_sCurrentLine = this.m_sCurrentLine.substring(0, n + 1);
        }
        this.m_nCurrentLineLength = this.m_sCurrentLine.length();
    }

    public void openScenarioFile(String string) throws FileNotFoundException {
        this.m_rScenario = new BufferedReader(new FileReader(string));
    }

    private void readerAccess_() throws IOException {
        if (this.m_sCurrentLine.charAt(0) == '2') {
            this.readerCommand_();
        } else if (this.m_sCurrentLine.charAt(0) == '8') {
            this.readerParameter_();
        } else {
            this.addError_(this.m_nCurrentLine, "unrecognized command");
        }
    }

    private void readerCommand_() throws IOException {
        int n;
        Buffer buffer = new Buffer(0);
        buffer.setLength(0);
        Buffer buffer2 = new Buffer(0);
        if (!this.m_sCurrentLine.startsWith(READER_CMD_PREFIXE)) {
            this.addError_(this.m_nCurrentLine, "unrecognized command");
            return;
        }
        if (this.m_sCurrentLine.charAt(3) == '0') {
            n = 0;
        } else if (this.m_sCurrentLine.charAt(3) == '4') {
            n = 1;
        } else if (this.m_sCurrentLine.charAt(3) == '5') {
            n = 2;
        } else {
            this.addError_(this.m_nCurrentLine, "unrecognized command");
            return;
        }
        try {
            this.m_rSession.readerExchange((byte)n, buffer, buffer2);
        }
        catch (CardException cardException) {
            try {
                if (this.m_rSession.getParameter((byte)4) == 0L) {
                    this.addError_(this.m_nCurrentLine, "NO CARD");
                    this.m_sResponse = "";
                    return;
                }
                this.addError_(this.m_nCurrentLine, "ERROR ATR");
                this.m_sResponse = "";
            }
            catch (Exception exception) {
                this.addError_(this.m_nCurrentLine, "ERROR COMM");
                this.m_sResponse = "";
                return;
            }
            return;
        }
        catch (Exception exception) {
            this.addError_(this.m_nCurrentLine, "ERROR COMM");
            this.m_sResponse = "";
            return;
        }
        this.m_sResponse = AutomaticTest.BytesToString(buffer2.getData());
        this.m_bWaitForResponse = true;
    }

    private void readerParameter_() throws IOException {
        if (!this.m_sCurrentLine.startsWith(PARAMETER_CMD_PREFIXE)) {
            this.addError_(this.m_nCurrentLine, "unrecognized command");
            return;
        }
        int n = PARAMETER_CMD_PREFIXE.length();
        try {
            String string = this.m_sCurrentLine.substring(n, n + 2);
            byte by = Byte.parseByte(string, 16);
            if (this.m_sCurrentLine.length() < (n += 2) + 2) {
                this.addError_(this.m_nCurrentLine, "unrecognized command");
                return;
            }
            string = this.m_sCurrentLine.substring(n, n + 2);
            byte by2 = Byte.parseByte(string, 16);
            n += 2;
            if (by2 == 1) {
                long l = this.m_rSession.getParameter(by2);
                this.m_sResponse = Long.toString(l, 16);
            } else {
                if (this.m_sCurrentLine.length() < n + 2) {
                    this.addError_(this.m_nCurrentLine, "unrecognized command");
                    return;
                }
                string = this.m_sCurrentLine.substring(n, n + 2);
                byte by3 = Byte.parseByte(string, 16);
                if (this.m_sCurrentLine.length() < (n += 2) + by3) {
                    this.addError_(this.m_nCurrentLine, "unrecognized command");
                    return;
                }
                string = this.m_sCurrentLine.substring(n, n + by3 + 1);
                long l = Long.parseLong(string, 16);
                this.m_rSession.setParameter(by2, l);
                this.m_sResponse = "9000";
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.addError_(this.m_nCurrentLine, "unrecognized command");
            return;
        }
        catch (Exception exception) {
            this.m_sResponse = "error parameter";
        }
        this.m_bWaitForResponse = true;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        if (this.m_rSession == null) {
            if (this.m_rListener != null) {
                this.m_rListener.scenarError("Invalid session");
            }
            return;
        }
        if (this.m_frParent == null) {
            if (this.m_rListener != null) {
                this.m_rListener.scenarError("invalid Frame");
            }
            return;
        }
        try {
            this.m_sCurrentLine = this.m_rScenario.readLine();
            if (true) ** GOTO lbl28
        }
        catch (IOException var1_1) {
            if (this.m_rListener != null) {
                this.m_rListener.scenarError(var1_1.toString());
            }
            return;
        }
        do {
            this.m_nCurrentLineLength = this.m_sCurrentLine.length();
            this.deleteBlanks_(true);
            try {
                this.analyseCommand_();
                ++this.m_nCurrentLine;
                this.m_sCurrentLine = this.m_rScenario.readLine();
            }
            catch (IOException var1_2) {
                if (this.m_rListener != null) {
                    this.m_rListener.scenarError(var1_2.toString());
                }
                return;
            }
lbl28:
            // 2 sources

        } while (this.m_sCurrentLine != null);
        if (this.m_rListener != null) {
            this.m_rListener.TestComplete(this.m_bErrorOccured ^ true);
        }
    }

    public void setListener(AutomaticTestListener automaticTestListener) {
        this.m_rListener = automaticTestListener;
    }

    private void stringtoBytes_(String string, byte[] byArray, int n) {
        BigInteger bigInteger = new BigInteger(string, 16);
        byArray[n] = (byte)bigInteger.intValue();
    }
}

