/*
 * Decompiled with CFR 0.152.
 */
package auth.sdk;

import java.util.Hashtable;

public class Syslog {
    private static boolean _native = false;
    public static boolean initialized = false;
    private static Syslog theSyslog = null;
    private static Hashtable facilities;
    private static Hashtable priorities;
    public static final int LOG_KERN = 0;
    public static final int LOG_USER = 8;
    public static final int LOG_MAIL = 16;
    public static final int LOG_DAEMON = 24;
    public static final int LOG_AUTH = 32;
    public static final int LOG_SYSLOG = 40;
    public static final int LOG_LPR = 48;
    public static final int LOG_NEWS = 56;
    public static final int LOG_UUCP = 64;
    public static final int LOG_CRON = 120;
    public static final int LOG_LOCAL0 = 128;
    public static final int LOG_LOCAL1 = 136;
    public static final int LOG_LOCAL2 = 144;
    public static final int LOG_LOCAL3 = 152;
    public static final int LOG_LOCAL4 = 160;
    public static final int LOG_LOCAL5 = 168;
    public static final int LOG_LOCAL6 = 176;
    public static final int LOG_LOCAL7 = 184;
    public static final int LOG_NFACILITIES = 24;
    public static final int LOG_FACMASK = 1016;
    private static int facility;
    public static final int LOG_EMERG = 0;
    public static final int LOG_ALERT = 1;
    public static final int LOG_CRIT = 2;
    public static final int LOG_ERR = 3;
    public static final int LOG_WARNING = 4;
    public static final int LOG_NOTICE = 5;
    public static final int LOG_INFO = 6;
    public static final int LOG_DEBUG = 7;
    public static final int LOG_DISABLED = -1;
    public static final int LOG_PRIMASK = 7;
    private static final int LOG_PID = 1;
    private static final int LOG_CONS = 2;
    private static final int LOG_ODELAY = 4;
    private static final int LOG_NDELAY = 8;
    private static final int LOG_NOWAIT = 16;

    static {
        facility = 24;
        try {
            System.loadLibrary("utsyslog");
            _native = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
        facilities = new Hashtable();
        facilities.put("kern", new Integer(0));
        facilities.put("user", new Integer(8));
        facilities.put("mail", new Integer(16));
        facilities.put("daemon", new Integer(24));
        facilities.put("auth", new Integer(32));
        facilities.put("syslog", new Integer(40));
        facilities.put("lpr", new Integer(48));
        facilities.put("news", new Integer(56));
        facilities.put("uucp", new Integer(64));
        facilities.put("cron", new Integer(120));
        facilities.put("local0", new Integer(128));
        facilities.put("local1", new Integer(136));
        facilities.put("local2", new Integer(144));
        facilities.put("local3", new Integer(152));
        facilities.put("local4", new Integer(160));
        facilities.put("local5", new Integer(168));
        facilities.put("local6", new Integer(176));
        facilities.put("local7", new Integer(184));
        priorities = new Hashtable();
        priorities.put("OFF", new Integer(-1));
        priorities.put("emerg", new Integer(0));
        priorities.put("alert", new Integer(1));
        priorities.put("crit", new Integer(2));
        priorities.put("err", new Integer(3));
        priorities.put("warning", new Integer(4));
        priorities.put("notice", new Integer(5));
        priorities.put("info", new Integer(6));
        priorities.put("debug", new Integer(7));
    }

    private Syslog(String string, int n) {
        if (_native) {
            Syslog.openlog(string, 8, n);
        }
    }

    public static native void _closelog();

    public static native int _setlogmask(int var0);

    private static native void _syslog(int var0, String var1);

    public static void closelog() {
        if (_native) {
            Syslog._closelog();
        }
    }

    public static synchronized void init(String string, int n) {
        if (theSyslog == null) {
            theSyslog = new Syslog(string, n);
            initialized = true;
        }
    }

    public static int mapFacility(String string) throws Exception {
        Integer n = (Integer)facilities.get(string);
        if (n == null) {
            throw new Exception("no such facility");
        }
        return n;
    }

    public static int mapPriority(String string) throws Exception {
        Integer n = (Integer)priorities.get(string);
        if (n == null) {
            throw new Exception("no such priority");
        }
        return n;
    }

    private static native void openlog(String var0, int var1, int var2);

    public static int setlogmask(int n) {
        if (_native) {
            return Syslog._setlogmask(n);
        }
        return n;
    }

    public static void syslog(int n, String string) {
        if (_native) {
            Syslog._syslog(n, string);
        } else {
            System.out.println("<" + n + ">" + string);
        }
    }
}

