/*
 * Copyright (c) 1999-2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_SCMI2C_H
#define	_SCMI2C_H

#pragma ident	"@(#)scmi2c.h	1.1	00/04/07 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * Header file for SCM Smart Transporter Chip, an I2C driver.
 */


/*
 * Define the ioctls that this driver supports
 */

#define	IOC_READREGISTER	0x1000	/* read byte from STC register */
#define	IOC_WRITEREGISTER	0x1001	/* write byte to STC register */
#define	IOC_GETNUMRECEIVED	0x1002	/* # of bytes avail. for reading */
#define	IOC_CARDINSERTED	0x1003	/* return card inserted status */
#define	IOC_START_XMTRCV_POLLING	0x1004 /* start xmtrcv polling */
#define	IOC_STOP_XMTRCV_POLLING	0x1005  /* stop xmtrcv polling */
#define	IOC_SET_READTIMEOUT	0x1006	/* set character read timeout */
#define	IOC_SET_WRITETIMEOUT	0x1007	/* set write block timeout */
#define	IOC_EXTENDED_ERRORS	0x1008	/* get STC errors from read/write */

/*
 * Define the arguments that each ioctl expects and the values that
 *	it returns.
 * 	-1 is returned if called with un supported
 *	ioctl code and errno will be set to ENOTTY
 */

/*
 * IOC_READREGISTER, IOC_WRITEREGISTER - provides register-level
 *	access to all STC registers with INTR_STATUS exception
 *
 *    Calling:
 *	scmi2c_rwreg_t - struct that contains register offset to access
 *			and data to read from register or data to
 *			write to register
 *
 *    Returns:
 *	-1 on error, errno is set:
 *		EIO	- I/O error when communicating with STC
 *		EACCES	- Prohibited (but valid) register offset specified
 *		EINVAL	- Invalid register offset specified
 *		EFAULT	- Error during the copyin or copyout
 * 	0 on success
 */

typedef struct {
	uint8_t		offset;	/* offset of register to access */
	uint8_t		data;	/* data to write or data read */
} scmi2c_rwreg_t;

/*
 * Open and close system calls.
 *
 *	0 on success
 *	-1 on error, errno is set:
 *	ENXIO	- Device not found or not available
 *	EBUSY	- The channel is in use by another
 *	EPERM	- Permission denied - not super user
 */

/*
 * The block read and write are done via read and write system calls.
 *
 *    Returns:
 *	0 on success
 *	-1 on error, errno is set:
 *	EIO 	- I/O error when communicating with STC
 *	ENXIO	- Device not found or not available
 *      EINVAL	- Invalid count specified
 *	EUNATCH	- XMITRCV_POLLING is not running
 *	ETIME	- Operation timed out
 *	EBUSY	- The channel is in use by another
 *	EFAULT	- Error during the copyin or copyout
 *	EINTR	- Read/Write terminated - kill signal.
 */

/*
 * IOC_SET_READTIMEOUT, IOC_SET_WRITE_TIMEOUT
 * set the character read and block write timeout in mS.
 *
 * Calling:
 *	(uint32_t)
 *	- on error the errno is set as:
 *		EFAULT - Error during the copyin or copyout
 *		EINVAL - if wrong number of args.
 */

/*
 * IOC_START_XMTRCV_POLLING, IOC_STOP_XMTRCV_POLLING
 *  Start and stop xmt and rcv polling
 *
 * Calling:
 *	(none)
 *
 *    Returns:
 *	0 on success
 *	- on errno the errno is set as:
 *	EUNATCH	- XMTRCV_POLLING not running
 *
 */

/*
 * IOC_GETNUMRECEIVED - return the number of bytes currently available
 *	for reading via the IOC_ReceiveBlock ioctl
 *
 *    Calling:
 *	(uint32_t *)
 *
 *    Returns:
 *	(uint32_t) - number of bytes available to be read,
 *			 (0 is a valid value)
 *	on error, errno is set:
 *		EFAULT	- Error during the copyin or copyout
 *		EINVAL	- Wrong number of args.
 */

/*
 * IOC_CARDINSERTED - returns the card inserted status
 *
 *    Calling:
 *	(unit32_t *)
 *
 *    Returns:
 *	0 on no error.
 *	0 - if no card is inserted
 *	1 - if card is inserted
 *	on error, errno is set:
 *		EIO - I/O error when communicating with STC
 *		EFAULT - Error during the copyin or copyout
 *		EINVAL - if wrong number of args.
 */

/*
 * IOC_EXTENDED_ERRORS	- returns STC errors during the last read/write
 *
 *    Calling:
 *	(unit32_t *)
 *
 *    Returns:
 *	(uint32_t) - extended error bits
 *	0 on no error.
 *	errors as in rwerr_flags bits set are copied to the user buffer.
 *	on error, errno is set:
 *		EFAULT - Error during the copyin or copyout
 *		EINVAL - if wrong number of args.
 */

/*
 * Extended error bits for IOC_EXTENDED_ERRORS
 */
#define	CARDNOTPRESENT		0x01
#define	CARDMOVEMENT		0x02
#define	OVERRUN			0x04
#define	FRAMING_ERROR		0x08
#define	SHORT_CIRCUIT		0x10
#define	WAITING_TIME_OVERFLOW	0x20

#define	ERROR_FLAGS (CARDNOTPRESENT)

#ifdef	__cplusplus
}
#endif

#endif	/* _SCMI2C_H */
