#!/bin/ksh
#
# Copyright (c) 1999, by Sun Microsystems, Inc.
# All rights reserved.
#
# create_server.sh - private script to generate an empty server directory
# from the configuration templates
#
# create_server.sh instance_name server_root 
#                   [sws_install_path] [config_file] [server_user]
#
#
#-------------------------------------------------------------------------------
#  Argument processing:
#

umask 022
if [ $# -lt 2 ]; then
	echo `gettext SRAS "usage: create_server.sh instance_name server_root [sws_install_path] [config_file] [server_user]"`
	echo `gettext SRAS "supply \"-\" for the optional parameters."`
	exit 1
fi

SERVER=$1
SERVER_ROOT=$2
SWSPATH=$3
CONFIG_FILE=$4
SERVER_USER=$5

if [ x"-" = x"$SWSPATH" ]; then
	SWSPATH="/"
fi

if [ "/" = "$SWSPATH"  ]; then
	SWSPATH=""
fi

if [ ! -d ${SWSPATH}/etc/opt/SUNWut/http ]; then
	echo
	echo `gettext SRAS "SRAS does not appear to be installed in"` $SWSPATH 
	echo
	echo `gettext SRAS "usage: create_server.sh instance_name server_root [sws_install_path] [config_file] [server_user]"`
	echo `gettext SRAS "supply \"-\" for the optional parameters."`
	exit 2
fi

if [ x"-" = x"$SERVER_USER" ]; then
	SERVER_USER=root;
fi

if [ x"-" = x"$CONFIG_FILE" ]; then
	CONFIG_FILE=${SWSPATH}/etc/opt/SUNWut/http/${SERVER}.httpd.conf;
fi

#-------------------------------------------------------------------------------
#	PutFile template-file target-file
#
# Routine to 'situate' a template by replacing macro-strings and
# by either removing or unadorning variant lines 
# (currently, lines marked #SERVLET)

PutFile() {
    INPUT=$1
    MIDDLE=/tmp/sws.$$
    OUTPUT=$2
    M4="/usr/ccs/bin/m4 -DSERVER_ROOT=$SERVER_ROOT -DSERVER_USER=$SERVER_USER"  

    pkginfo SUNWhtsvl >/dev/null 2>&1
    if [ $? -eq 0 ]; then
	HAVESERVLETS=1
    else
	HAVESERVLETS=0
    fi

    if [ $HAVESERVLETS -eq 1 ]; then
	$M4 $INPUT | sed 's/#SERVLET//g' > $MIDDLE;
    else
	$M4 $INPUT | grep -v '#SERVLET' > $MIDDLE;
    fi;

	pkginfo SUNWixpl > /dev/null 2>&1
	if [ $? -eq 0 ]; then
	    $M4 $MIDDLE | sed 's/#USERDOCSRC/ISP/g' > $OUTPUT;
	else
	    $M4 $MIDDLE | sed 's/#USERDOCSRC/UNIXSYS/g' > $OUTPUT;
	fi;

	/bin/rm -f $MIDDLE
}

#------------------------------------------------------------------------------
# Main server configuration tree creation:
#
# - transfer the server template files and create the SERVER_ROOT area
#
# - Note that we don't do -anything- if the configuration file already exists.
#   Either we generate the configuration, or the administrator does;
#   we don't do half&half stuff.
#------------------------------------------------------------------------------

if [ ! -f ${CONFIG_FILE} ]; then

	if [ ! -f ${SWSPATH}/etc/opt/SUNWut/http/server.httpd.conf ]; then
		echo `gettext SRAS "The server configuration file does not exist\n"`
		exit 1
	fi;

	echo `gettext SRAS "Creating server configuration file:"`
	echo " ${CONFIG_FILE} "
	PutFile ${SWSPATH}/etc/opt/SUNWut/http/server.httpd.conf ${CONFIG_FILE};
	chown adm:adm ${CONFIG_FILE}

        if [ ! -d ${SERVER_ROOT} ]; then

	    echo `gettext SRAS "Creating server root directory:"`
	    echo " ${SERVER_ROOT}"
	    mkdir -p $SERVER_ROOT
    
	    if [ -f ${SWSPATH}/etc/opt/SUNWut/http/server_template/map.conf ]; then
	        PutFile ${SWSPATH}/etc/opt/SUNWut/http/server_template/map.conf \
	                ${SERVER_ROOT}/map.conf
	    fi;
        fi
	chown -R adm:adm ${SERVER_ROOT}

	mkdir -p ${SERVER_ROOT}/logs

	# These satisfy the default maps installed internally in the daemon.
	# These should probably be corrected in the source file,
	# although then there is the problem of the installation root.
	
	if [ ! -d ${SERVER_ROOT}/sws-icons ]; then
		ln -s ${SWSPATH}/opt/SUNWut/http/sws-icons ${SERVER_ROOT}/sws-icons
	fi

	if [ ! -d ${SERVER_ROOT}/cgi-bin ]; then
		mkdir -p ${SERVER_ROOT}/cgi-bin
		ln -s ${SWSPATH}/opt/SUNWut/http/lib/cgi-bin/* ${SERVER_ROOT}/cgi-bin
	fi

	# Make sure everything at this level is owned by adm.
	chown -R adm:adm ${SERVER_ROOT}

	# Finally, create a default site for the instance we built.

	${SWSPATH}/opt/SUNWut/http/lib/create_site.sh default_site \
		${SERVER_ROOT}/websites/default_site $3 -

	chown adm:adm ${SERVER_ROOT}/websites

fi

