// ident "@(#)list.js.src	1.9 02/08/21 SMI"
// Copyright 1999,2002 Sun Microsystems, Inc.  All rights reserved.
// CONSULT THE SOURCE TREE FOR A FULLY-COMMENTED PRECURSOR TO THIS FILE.
var nodeIds = new Array;
function putCookie(name, value) {
	document.cookie = name + '=' + escape(value);
}
function getCookie(name) {
	var matchstring = name + "=";
	var cookies = document.cookie.split("; ");
	for (var i = 0 ; i < cookies.length ; ++i) {
		var coo = cookies[i];
		if (coo.indexOf(matchstring) == 0) {
			return (unescape(coo.substr(matchstring.length)));
		}
	}
	return null;
}
function putState(a) {
	putCookie("stateCookie", a.join(""));
}
function getState() {
	var s;
	var a;
	s = getCookie("stateCookie");
	if (s != null) {
		a = s.split("");
	}
	else {
		a = new Array;
	}
	return a;
}
var expandState = new Array;
function collapse(id, frameName) {
	if (id < nodeIds.length) {
		expandState[id] = "0";
		putState(expandState);
		nodeIds[id].topOfTrie().paint(frameName);
	}
}
function expand(id, frameName) {
	if (id < nodeIds.length) {
		expandState[id] = "1";
		putState(expandState);
		nodeIds[id].topOfTrie().paint(frameName);
	}
}
function List(expand) {
	if (List.prototype.initialised != true) {
		List.prototype.initialised = true;
		List.prototype.addItem = addItemToList;
		List.prototype.setFont = setFontForList;
		List.prototype.addList = addListToList;
		List.prototype.build = buildList;
		List.prototype.setBodyOptions = setBodyForList;
		List.prototype.paint = paintList;
	}
	this.trie = new Trie(expand, "");
}
function addItemToList(s) {
	var t = new Trie(false,s);
	this.trie.append(t);
	return t;
}
function setFontForList(fs) {
	this.trie.setFont(fs);
}
function addListToList(l,s) {
	l.trie.setContent(s);
	this.trie.append(l.trie);
}
function buildList(x,y) {
}
function setBodyForList(opts) {
	this.trie.setBodyOptions(opts);
}
function paintList(frameName) {
	this.trie.paint(frameName);
}
var padImage = "/images/pad.gif";
var openImage = "/images/true.gif";
var closedImage = "/images/false.gif";
function Trie(expand, content) {
	if (Trie.prototype.initialised != true) {
		Trie.prototype.initialised = true;
		Trie.prototype.append = appendToTrie;
		Trie.prototype.paint = paintTrie;
		Trie.prototype.toString = stringForTrie;
		Trie.prototype.setContent = setContentForTrie;
		Trie.prototype.setFont = setFontForTrie;
		Trie.prototype.setBodyOptions = setBodyForTrie;
		Trie.prototype.setWrap = setWrapForTrie;
		Trie.prototype.setIndent = setIndentForTrie;
		Trie.prototype.topOfTrie = getTopOfTrie;
		Trie.prototype._paintSub = _paintSubTrie;
		Trie.prototype._paintNode = _paintNode;
	}
	this.expanded = expand;
	this.content = content;
	this.children = new Array;
	this.height = 1;
	this.above = null;
	this.fontString = null;
	this.bodyOptions = null;
	this.wrap = false;
	this.indent = true;
	this.id = nodeIds.length;
	nodeIds.push(this);
	expandState[this.id] = (this.expanded ? "1" : "0");
}
function stringForTrie() {
	return( "content: " + this.content + "\n" +
		"expanded: " + this.expanded + "\n" +
		"height: " + this.height + "\n" +
		"id: " + this.id + "\n" +
		"parent: " + ((this.above == null) ? "null" : this.above.id) + "\n" +
		"children: " + this.children.length + "\n" +
		"" );
}
function setContentForTrie(s) {
	this.content = s;
}
function setFontForTrie(s) {
	this.fontString = s;
}
function setBodyForTrie(opts) {
	this.bodyOptions = opts;
}
function setWrapForTrie(allowWrap) {
	this.wrap = (allowWrap ? true : false);
}
function setIndentForTrie(doIndent) {
	this.indent = (doIndent ? true : false);
}
function appendToTrie(item) {
	this.children.push(item);
	item.above = this;
	for (var node = item ; node.above != null ; node = node.above) {
		if (node.above.height > node.height) {
			break;
		}
		node.above.height = 1 + node.height;
	}
}
function paintTrie(frameName) {
	var frame = window.frames[frameName];
	var doc = frame.document.open();
	var oldExpandState = getState();
	if (oldExpandState.length == expandState.length) {
		expandState = oldExpandState;
	}
	doc.write("<HTML><HEAD></HEAD><BODY");
	if (this.bodyOptions != null) {
		doc.write(" ", this.bodyOptions);
	}
	doc.writeln(">");
	if (this.fontString != null) {
		doc.writeln("<FONT ", this.fontString, ">");
	}
	doc.writeln("<TABLE BORDER=0>");
	this.topOfTrie()._paintSub(frame, frameName, 0,
		this.height, expandState);
	doc.writeln("</TABLE>");
	if (this.fontString != null) {
		doc.writeln("</FONT>");
	}
	doc.writeln("</BODY></HTML>");
	doc.close();
}
function getTopOfTrie() {
	var node = this;
	while (node.above != null) {
		node = node.above;
	}
	return node;
}
function _paintSubTrie(frame, frameName, depth, maxdepth, expflags) {
	var isExpanded;
	if (expflags[this.id] != undefined) {
		isExpanded = (expflags[this.id] != "0");
	}
	else {
		isExpanded = this.expanded;
	}
	this._paintNode(frame, frameName, depth, maxdepth, isExpanded);
	if (isExpanded) {
		for (var c = 0 ; c < this.children.length ; ++c) {
			this.children[c]._paintSub(frame, frameName,
			    1+depth, maxdepth, expflags);
		}
	}
}
function _paintNode(frame, frameName, depth, maxdepth, isExpanded) {
	var doc = frame.document;
	if (this.content.length == 0) {
		return;
	}
	doc.write("<TR><TD", (this.wrap ? "" : " NOWRAP"), ">");
	for (pad = 1 ; pad < depth ; ++pad) {
		doc.write("<IMG SRC=\"", padImage, "\" ALT=\"_\">");
	}
	if (this.fontString != null) {
		doc.write("<FONT ", this.fontString, ">");
	}
	if (this.children.length > 0) {
		if (isExpanded) {
			doc.write("<A HREF=\"javascript:parent.collapse(",
				this.id, ",'", frameName, "');\">",
				"<IMG SRC=\"", openImage, "\" BORDER=0 ALT=\"[-]\">",
				"</A>");
		}
		else {
			doc.write("<A HREF=\"javascript:parent.expand(",
				this.id, ",'", frameName, "');\">",
				"<IMG SRC=\"", closedImage, "\" BORDER=0 ALT=\"[+]\">",
				"</A>");
		}
	}
	else {
		if (this.indent) {
			doc.write("<IMG SRC=\"", padImage, "\" ALT=\"_\">");
		}
	}
	doc.write(this.content);
	if (this.fontString != null) {
		doc.write("</FONT>");
	}
	doc.writeln("</TD></TR>");
}
// end of "@(#)list.js.src	1.9"
