/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;

public class Configuration {
    private static final String JAVA_HELP_PORT = "JavaHelpPort";
    private static final String LOG_LEVEL_PARAM = "LogLevel";
    private static final String SERVER_LIMIT = "ServerLimit";
    private static final String DEFAULT_LOG_LEVEL = "SEVERE";

    public int getJavaHelpPort() {
        int result;
        ExternalContext ctx = FacesContext.getCurrentInstance().getExternalContext();
        String helpPort = ctx.getInitParameter(JAVA_HELP_PORT);
        if (helpPort != null) {
            try {
                result = Integer.parseInt(helpPort);
            }
            catch (NumberFormatException ex) {
                result = this.getDefaultJavaHelpPort();
            }
        } else {
            result = this.getDefaultJavaHelpPort();
        }
        return result;
    }

    public int getDefaultJavaHelpPort() {
        ExternalContext ctx = FacesContext.getCurrentInstance().getExternalContext();
        HttpServletRequest request = (HttpServletRequest)ctx.getRequest();
        return request.getServerPort();
    }

    public String getLogLevel() {
        ExternalContext ctx = FacesContext.getCurrentInstance().getExternalContext();
        String logLevel = ctx.getInitParameter(LOG_LEVEL_PARAM);
        if (logLevel != null) {
            return logLevel;
        }
        return DEFAULT_LOG_LEVEL;
    }

    public int getServerLimit() {
        int result;
        ExternalContext ctx = FacesContext.getCurrentInstance().getExternalContext();
        String limit = ctx.getInitParameter(SERVER_LIMIT);
        if (limit != null) {
            try {
                result = Integer.parseInt(limit);
            }
            catch (NumberFormatException ex) {
                result = Integer.MAX_VALUE;
            }
        } else {
            result = Integer.MAX_VALUE;
        }
        return result;
    }
}

