/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console;

import com.sun.ut.console.Context;
import com.sun.ut.console.I18N;
import com.sun.ut.service.ServiceException;
import com.sun.web.ui.component.Alert;

public class StatusMessage {
    public static final String STATUS_MESSAGE = "statusMessage";
    public static final String STATUS_MESSAGE_DATA = "statusMessageData";
    public static final String ALERT_ID = "alert";
    public static final String INFO = "information";
    public static final String WARNING = "warning";
    public static final String ERROR = "error";
    public static final String SUCCESS = "success";
    private StatusMessageData data = null;
    private boolean followsRedirects = false;

    public Alert getAlert() {
        Alert alert = new Alert();
        alert.setId(ALERT_ID);
        alert.setTransient(true);
        if (this.isVisible()) {
            alert.setType(this.getContent().getType());
            alert.setSummary(this.getContent().getSummary());
            alert.setDetail(this.getContent().getDetails());
            alert.setRendered(true);
            if (this.getContent().getLinkText() != null) {
                alert.setLinkText(this.getContent().getLinkText());
                alert.setLinkTarget(this.getContent().getLinkTarget());
                alert.setLinkURL(this.getContent().getLinkURL());
            }
        } else {
            alert.setRendered(false);
        }
        this.reset();
        return alert;
    }

    public void setAlert(Alert alert) {
    }

    public void reset() {
        this.data = null;
        Context.setSessionAttribute(STATUS_MESSAGE_DATA, null);
        this.followsRedirects = false;
    }

    public boolean isVisible() {
        return this.getContent() != null;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followsRedirects = followRedirects;
    }

    public boolean getFollowRedirects() {
        return this.followsRedirects;
    }

    public void status(String type, String summary, String details) {
        this.status(type, summary, details, null, null, null, null, false);
    }

    public void status(String type, String summary, String details, Object[] args) {
        this.status(type, summary, details, args, null, null, null, false);
    }

    public void status(String type, String summary, String details, boolean followRedirects) {
        this.status(type, summary, details, null, null, null, null, followRedirects);
    }

    public void status(String type, String summary, String details, Object[] args, boolean followRedirects) {
        this.status(type, summary, details, args, null, null, null, followRedirects);
    }

    public void status(String type, String summary, String details, Object[] args, String linkText, String linkTarget, String linkURL, boolean followRedirects) {
        this.followsRedirects = followRedirects;
        StatusMessageData content = new StatusMessageData();
        content.setType(type);
        content.setSummary(I18N.getResource(summary));
        if (args == null) {
            content.setDetails(I18N.getResource(details));
        } else {
            content.setDetails(I18N.getResource(details, args));
        }
        content.setLinkText(I18N.getResource(linkText));
        content.setLinkTarget(linkTarget);
        content.setLinkURL(linkURL);
        this.setContent(content);
    }

    public void info(String summary, String details) {
        this.status(INFO, summary, details);
    }

    public void info(String summary, String details, Object[] args) {
        this.status(INFO, summary, details, args);
    }

    public void info(String summary, String details, boolean followRedirects) {
        this.status(INFO, summary, details, followRedirects);
    }

    public void info(String summary, String details, String linkText, String linkTarget, String linkURL, boolean followRedirects) {
        this.status(INFO, summary, details, null, linkText, linkTarget, linkURL, followRedirects);
    }

    public void warning(String summary, String details) {
        this.status(WARNING, summary, details);
    }

    public void warning(String summary, String details, boolean followRedirects) {
        this.status(WARNING, summary, details, followRedirects);
    }

    public void warning(String summary, String details, String linkText, String linkTarget, String linkURL, boolean followRedirects) {
        this.status(WARNING, summary, details, null, linkText, linkTarget, linkURL, followRedirects);
    }

    public void error(ServiceException ex) {
        this.error("error_operation_failed", ex, false);
    }

    public void error(String summary, ServiceException ex) {
        this.error(summary, ex, false);
    }

    public void error(ServiceException ex, boolean followRedirects) {
        this.error("error_operation_failed", ex, followRedirects);
    }

    public void error(String summary, ServiceException ex, boolean followRedirects) {
        String details = ex.getMessageKey();
        Object[] args = ex.getMessageArgs();
        if (details == null) {
            details = "error_internal";
        }
        this.status(ERROR, summary, details, args, followRedirects);
    }

    public void error(String summary, String details) {
        this.status(ERROR, summary, details);
    }

    public void error(String summary, String details, Object[] args) {
        this.status(ERROR, summary, details, args);
    }

    public void error(String summary, String details, boolean followRedirects) {
        this.status(ERROR, summary, details, followRedirects);
    }

    public void error(String summary, String details, String linkText, String linkTarget, String linkURL, boolean followRedirects) {
        this.status(ERROR, summary, details, null, linkText, linkTarget, linkURL, followRedirects);
    }

    public void error(String summary, String details, Object[] args, String linkText, String linkTarget, String linkURL, boolean followRedirects) {
        this.status(ERROR, summary, details, args, linkText, linkTarget, linkURL, followRedirects);
    }

    public void success(String summary, String details) {
        this.status(SUCCESS, summary, details);
    }

    public void success(String summary, String details, boolean followRedirects) {
        this.status(SUCCESS, summary, details, followRedirects);
    }

    public void success(String summary, String details, String linkText, String linkTarget, String linkURL, boolean followRedirects) {
        this.status(SUCCESS, summary, details, null, linkText, linkTarget, linkURL, followRedirects);
    }

    public void restartRequired() {
        this.restartRequired(false);
    }

    public void coldRestartRequired() {
        this.coldRestartRequired(false);
    }

    public void restartRequired(boolean followRedirects) {
        this.warning("alert_stored_changes", "alert_restart_details", "alert_restart_instruction", "", "../server/Servers.jsp", followRedirects);
    }

    public void coldRestartRequired(boolean followRedirects) {
        this.warning("alert_stored_changes", "alert_cold_restart_details", "alert_restart_instruction", "", "../server/Servers.jsp", followRedirects);
    }

    public static StatusMessage getStatusMessage() {
        StatusMessage msg = (StatusMessage)Context.getRequestAttribute(STATUS_MESSAGE);
        if (msg == null) {
            msg = new StatusMessage();
            Context.setRequestAttribute(STATUS_MESSAGE, msg);
        }
        return msg;
    }

    public StatusMessageData getContent() {
        if (this.data == null) {
            this.data = (StatusMessageData)Context.getSessionAttribute(STATUS_MESSAGE_DATA);
        }
        return this.data;
    }

    public void setContent(StatusMessageData content) {
        this.data = content;
        if (this.followsRedirects) {
            Context.setSessionAttribute(STATUS_MESSAGE_DATA, this.data);
        }
    }

    public StatusMessageData createContent(String type, String summary, String details, String linkText, String linkTarget, String linkURL) {
        StatusMessageData content = new StatusMessageData();
        content.setType(type);
        content.setSummary(summary);
        content.setDetails(details);
        content.setLinkText(linkText);
        content.setLinkTarget(linkTarget);
        content.setLinkURL(linkURL);
        return content;
    }

    class StatusMessageData {
        private String type;
        private String summary;
        private String details;
        private String linkText;
        private String linkTarget;
        private String linkURL;

        StatusMessageData() {
        }

        public void setSummary(String summary) {
            this.summary = summary;
        }

        public String getSummary() {
            return this.summary;
        }

        public void setDetails(String details) {
            this.details = details;
        }

        public String getDetails() {
            return this.details;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void setLinkText(String linkText) {
            this.linkText = linkText;
        }

        public String getLinkText() {
            return this.linkText;
        }

        public void setLinkTarget(String linkTarget) {
            this.linkTarget = linkTarget;
        }

        public String getLinkTarget() {
            return this.linkTarget;
        }

        public void setLinkURL(String linkURL) {
            this.linkURL = linkURL;
        }

        public String getLinkURL() {
            return this.linkURL;
        }
    }
}

