/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.advanced;

import com.sun.ut.console.BaseHandler;
import com.sun.ut.console.I18N;
import com.sun.ut.service.ServiceException;

public class PasswordHandler
extends BaseHandler {
    private static final int MINIMUM_PASSWORD_LENGTH = 5;
    private String password;
    private String newPassword;
    private String confirmPassword;

    public String getPassword() {
        return this.password;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public String getOnClick() {
        String onClickScript = "javascript: return true;";
        try {
            String primaryHostName = this.getProvider().getPrimaryHostName();
            if (primaryHostName != null) {
                onClickScript = "javascript: return confirm(\"" + I18N.getResource("password_alert_fog") + "\");";
            }
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
        }
        return onClickScript;
    }

    public String modify() {
        if (this.password == null || this.password.length() <= 0) {
            this.getStatusMessage().error("password_alert_modify", "password_alert_invalid");
        } else if (this.newPassword == null || this.newPassword.length() < 5) {
            this.getStatusMessage().error("password_alert_modify", "password_alert_length");
        } else if (this.newPassword.indexOf(" ") != -1) {
            this.getStatusMessage().error("password_alert_modify", "password_alert_whitespace");
        } else if (this.confirmPassword == null || !this.confirmPassword.equals(this.newPassword)) {
            this.getStatusMessage().error("password_alert_modify", "password_alert_match");
        } else {
            try {
                this.getProvider().modifyPassword(this.password, this.newPassword);
                this.getAuditService().publishEvent("datastore_password_changed");
                String primaryHostName = this.getProvider().getPrimaryHostName();
                if (primaryHostName != null) {
                    this.getStatusMessage().info("alert_stored_changes", "password_info_modify_fog_warning");
                } else {
                    this.getStatusMessage().info("alert_stored_changes", "password_info_modify");
                }
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error("password_alert_modify", se);
            }
        }
        this.password = null;
        this.newPassword = null;
        this.confirmPassword = null;
        return "";
    }
}

